/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.lights;

import com.beatcraft.data.types.Color;
import com.beatcraft.lightshow.lights.LightObject;
import com.beatcraft.lightshow.lights.LightState;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.RenderUtil;
import com.beatcraft.render.effect.Bloomfog;
import com.beatcraft.utils.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.commons.lang3.function.TriFunction;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class FloodLight
extends LightObject {
    private final float startOffset;
    private final float width;
    private final float length;
    private final float fadeLength;
    private final float spread;
    private final float[] segmentLengths;
    private List<class_3545<Vector3f, Float>[]> faces;
    private List<class_3545<Vector3f, Float>[]> fadeFaces;
    private List<class_3545<Vector3f, Float>[]> lines;

    @Override
    public FloodLight cloneOffset(Vector3f offset) {
        return (FloodLight)new FloodLight(this.startOffset, this.width, this.length, this.fadeLength, this.spread, this.segmentLengths, this.position.add((Vector3fc)offset, new Vector3f()), new Quaternionf((Quaternionfc)this.orientation)).withRotation(new Quaternionf((Quaternionfc)this.rotation)).withTranslationSwizzle(this.translationSwizzle, this.translationPolarity).withRotationSwizzle(this.rotationSwizzle, this.rotationPolarity, (TriFunction<Float, Float, Float, Quaternionf>)this.quaternionBuilder);
    }

    public FloodLight(float startOffset, float width, float length, float fadeLength, float spread, float[] segmentLengths, Vector3f pos, Quaternionf rot) {
        this.startOffset = startOffset;
        this.width = width;
        this.length = length;
        this.fadeLength = fadeLength;
        this.spread = spread;
        this.segmentLengths = segmentLengths;
        this.position = pos;
        this.orientation = rot;
        this.setDimensions(startOffset, width, length, fadeLength, spread, segmentLengths);
        this.lightState = new LightState(new Color(0), 0.0f);
    }

    public FloodLight withRotation(Quaternionf rotation) {
        this.rotation = rotation;
        return this;
    }

    private List<class_3545<Vector3f, Float>[]> getFaces(Hitbox bounds, float spread, boolean includeBottomFace, float low, float high) {
        ArrayList<class_3545<Vector3f, Float>[]> out = new ArrayList<class_3545<Vector3f, Float>[]>();
        if (includeBottomFace) {
            out.add(new class_3545[]{new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(high))});
        }
        out.add(new class_3545[]{new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(low)), new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(low))});
        out.add(new class_3545[]{new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(low)), new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(low)), new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(high))});
        out.add(new class_3545[]{new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(low)), new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(low)), new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(high))});
        out.add(new class_3545[]{new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(high)), new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(low)), new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(low))});
        return out;
    }

    private List<class_3545<Vector3f, Float>[]> getLines(Hitbox bounds, float spread) {
        return List.of({new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(1.0f)), new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(1.0f))}, {new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(1.0f)), new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(1.0f))}, {new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(1.0f)), new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(1.0f))}, {new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(1.0f)), new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(1.0f))}, {new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(0.0f)), new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(0.0f))}, {new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(0.0f)), new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(0.0f))}, {new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(0.0f)), new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(0.0f))}, {new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(0.0f)), new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(0.0f))}, {new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(1.0f)), new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(0.0f))}, {new class_3545((Object)new Vector3f(bounds.min.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(1.0f)), new class_3545((Object)new Vector3f(bounds.min.x - spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(0.0f))}, {new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.max.z), (Object)Float.valueOf(1.0f)), new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.max.z + spread), (Object)Float.valueOf(0.0f))}, {new class_3545((Object)new Vector3f(bounds.max.x, bounds.min.y, bounds.min.z), (Object)Float.valueOf(1.0f)), new class_3545((Object)new Vector3f(bounds.max.x + spread, bounds.max.y, bounds.min.z - spread), (Object)Float.valueOf(0.0f))});
    }

    public void setDimensions(float startOffset, float width, float length, float fadeLength, float spread, float[] segmentLengths) {
        float maxY = startOffset + length;
        float fadeY = startOffset + fadeLength;
        float delta = width / 2.0f;
        Hitbox baseDimensions = new Hitbox(new Vector3f(-delta, startOffset, -delta), new Vector3f(delta, maxY, delta));
        Hitbox fadeDimensions = new Hitbox(new Vector3f(-delta, startOffset, -delta), new Vector3f(delta, fadeY, delta));
        float midSpread = spread * fadeLength / length;
        ArrayList<Float> yVals = new ArrayList<Float>();
        for (float y : segmentLengths) {
            yVals.add(Float.valueOf(y));
        }
        yVals.add(Float.valueOf(fadeY));
        yVals.sort(Float::compare);
        float cy = startOffset;
        ArrayList<class_3545<Vector3f, Float>[]> faces0 = new ArrayList<class_3545<Vector3f, Float>[]>();
        for (Float y : yVals) {
            float dl0 = MathUtil.inverseLerp(startOffset, fadeY, cy);
            float dl1 = MathUtil.inverseLerp(startOffset, fadeY, y.floatValue());
            float s0 = class_3532.method_16439((float)dl0, (float)0.0f, (float)midSpread);
            float s1 = class_3532.method_16439((float)dl1, (float)0.0f, (float)midSpread);
            Hitbox dim = new Hitbox(new Vector3f(-width - s0, cy, -width - s0), new Vector3f(width + s0, y.floatValue(), width + s0));
            List<class_3545<Vector3f, Float>[]> subSection = this.getFaces(dim, s1 - s0, cy == startOffset, 1.0f - dl1, 1.0f - dl0);
            faces0.addAll(subSection);
            cy = y.floatValue();
        }
        this.faces = this.getFaces(baseDimensions, spread, true, 0.0f, 1.0f);
        this.fadeFaces = List.copyOf(faces0);
        this.lines = this.getLines(baseDimensions, spread);
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera, Bloomfog bloomfog) {
        Vector3f pos = MemoryPool.newVector3f(this.position);
        Vector3f off = MemoryPool.newVector3f(this.offset);
        Quaternionf ori = MemoryPool.newQuaternionf(this.orientation);
        Quaternionf rot = MemoryPool.newQuaternionf(this.rotation);
        Quaternionf wrot = MemoryPool.newQuaternionf(this.worldRotation);
        Vector3f pos3 = MemoryPool.newVector3f(this.position);
        Vector3f off3 = MemoryPool.newVector3f(this.offset);
        Quaternionf ori3 = MemoryPool.newQuaternionf(this.orientation);
        Quaternionf rot3 = MemoryPool.newQuaternionf(this.rotation);
        Quaternionf wrot3 = MemoryPool.newQuaternionf(this.worldRotation);
        Vector3f pos4 = MemoryPool.newVector3f(this.position);
        Vector3f off4 = MemoryPool.newVector3f(this.offset);
        Quaternionf ori4 = MemoryPool.newQuaternionf(this.orientation);
        Quaternionf rot4 = MemoryPool.newQuaternionf(this.rotation);
        Quaternionf wrot4 = MemoryPool.newQuaternionf(this.worldRotation);
        LightState state = this.lightState.copy();
        state.clampAlpha();
        if (bloomfog != null) {
            bloomfog.record((b, c, r, m) -> this._render((class_287)b, (Vector3f)c, 1, (Quaternionf)r, ori, rot, wrot, pos, off, state, (boolean)m));
            bloomfog.recordBloomCall((TriConsumer<class_287, Vector3f, Quaternionf>)((TriConsumer)(b, v, q) -> this._renderBloom((class_287)b, (Vector3f)v, (Quaternionf)q, ori3, rot3, wrot3, pos3, off3, state)));
        }
        BeatCraftRenderer.recordLightRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(b, c) -> this._render((class_287)b, (Vector3f)c, 0, null, ori4, rot4, wrot4, pos4, off4, state, false)));
    }

    @Override
    public void setBrightness(float value) {
        this.lightState.setBrightness(value);
    }

    @Override
    public void setColor(int color) {
        this.lightState.setColor(new Color(color));
    }

    private void _renderBloom(class_287 buffer, Vector3f cameraPos, Quaternionf cameraRotation, Quaternionf orientation, Quaternionf rotation, Quaternionf worldRotation, Vector3f position, Vector3f offset, LightState lightState) {
        int color = lightState.getBloomColor();
        if ((color >> 24 & 0xFF) <= 1) {
            return;
        }
        Color c = new Color(color);
        Matrix4f mat = this.createTransformMatrix(false, orientation, rotation, this.transformState, position, worldRotation, offset, cameraPos);
        for (class_3545<Vector3f, Float>[] face : this.fadeFaces) {
            Vector3f v0 = ((Vector3f)face[0].method_15442()).mulPosition((Matrix4fc)mat, new Vector3f());
            Vector3f v1 = ((Vector3f)face[1].method_15442()).mulPosition((Matrix4fc)mat, new Vector3f());
            Vector3f v2 = ((Vector3f)face[2].method_15442()).mulPosition((Matrix4fc)mat, new Vector3f());
            Vector3f v3 = ((Vector3f)face[3].method_15442()).mulPosition((Matrix4fc)mat, new Vector3f());
            v0.rotate((Quaternionfc)cameraRotation);
            v1.rotate((Quaternionfc)cameraRotation);
            v2.rotate((Quaternionfc)cameraRotation);
            v3.rotate((Quaternionfc)cameraRotation);
            buffer.method_60830(v0).method_39415(c.withAlpha(((Float)face[0].method_15441()).floatValue()).lerpBrightness(((Float)face[0].method_15441()).floatValue()));
            buffer.method_60830(v1).method_39415(c.withAlpha(((Float)face[1].method_15441()).floatValue()).lerpBrightness(((Float)face[1].method_15441()).floatValue()));
            buffer.method_60830(v2).method_39415(c.withAlpha(((Float)face[2].method_15441()).floatValue()).lerpBrightness(((Float)face[2].method_15441()).floatValue()));
            buffer.method_60830(v0).method_39415(c.withAlpha(((Float)face[0].method_15441()).floatValue()).lerpBrightness(((Float)face[0].method_15441()).floatValue()));
            buffer.method_60830(v2).method_39415(c.withAlpha(((Float)face[2].method_15441()).floatValue()).lerpBrightness(((Float)face[2].method_15441()).floatValue()));
            buffer.method_60830(v3).method_39415(c.withAlpha(((Float)face[3].method_15441()).floatValue()).lerpBrightness(((Float)face[3].method_15441()).floatValue()));
        }
    }

    private void _render(class_287 buffer, Vector3f cameraPos, int isBloomfog, Quaternionf cameraRotation, Quaternionf orientation, Quaternionf rotation, Quaternionf worldRotation, Vector3f position, Vector3f offset, LightState lightState, boolean mirrorDraw) {
        int color;
        int n = color = isBloomfog > 0 ? lightState.getBloomColor() : lightState.getEffectiveColor();
        if ((color >> 24 & 0xFF) <= 1) {
            return;
        }
        Matrix4f mat = this.createTransformMatrix(mirrorDraw, orientation, rotation, this.transformState, position, worldRotation, offset, cameraPos);
        Color c = new Color(color);
        if (isBloomfog == 1 && !mirrorDraw) {
            for (class_3545<Vector3f, Float>[] line : this.lines) {
                Vector3f v0 = ((Vector3f)line[0].method_15442()).mulPosition((Matrix4fc)mat, new Vector3f());
                Vector3f v1 = ((Vector3f)line[1].method_15442()).mulPosition((Matrix4fc)mat, new Vector3f());
                v0.rotate((Quaternionfc)cameraRotation);
                v1.rotate((Quaternionfc)cameraRotation);
                Vector3f n2 = v1.sub((Vector3fc)v0, new Vector3f());
                List<class_3545<Vector3f, Float>[]> segments = RenderUtil.chopEdgeLerp(v0, v1, 5.0f, ((Float)line[0].method_15441()).floatValue(), ((Float)line[1].method_15441()).floatValue());
                for (class_3545<Vector3f, Float>[] segment : segments) {
                    buffer.method_60830((Vector3f)segment[0].method_15442()).method_39415(new Color(color).withAlpha(((Float)segment[0].method_15441()).floatValue()).lerpBrightness(((Float)segment[0].method_15441()).floatValue())).method_22914(n2.x, n2.y, n2.z);
                    buffer.method_60830((Vector3f)segment[1].method_15442()).method_39415(new Color(color).withAlpha(((Float)segment[1].method_15441()).floatValue()).lerpBrightness(((Float)segment[1].method_15441()).floatValue())).method_22914(-n2.x, -n2.y, -n2.z);
                }
            }
        } else {
            List<class_3545<Vector3f, Float>[]> iterFaces = isBloomfog > 0 ? this.faces : this.fadeFaces;
            for (class_3545<Vector3f, Float>[] face : iterFaces) {
                Vector3f v0 = ((Vector3f)face[0].method_15442()).mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).mulPosition((Matrix4fc)mat);
                Vector3f v1 = ((Vector3f)face[1].method_15442()).mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).mulPosition((Matrix4fc)mat);
                Vector3f v2 = ((Vector3f)face[2].method_15442()).mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).mulPosition((Matrix4fc)mat);
                Vector3f v3 = ((Vector3f)face[3].method_15442()).mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).mulPosition((Matrix4fc)mat);
                if (isBloomfog > 0) {
                    v0.rotate((Quaternionfc)cameraRotation);
                    v1.rotate((Quaternionfc)cameraRotation);
                    v2.rotate((Quaternionfc)cameraRotation);
                    v3.rotate((Quaternionfc)cameraRotation);
                }
                buffer.method_60830(v0).method_39415(c.withAlpha(((Float)face[0].method_15441()).floatValue()).lerpBrightness(((Float)face[0].method_15441()).floatValue()));
                buffer.method_60830(v1).method_39415(c.withAlpha(((Float)face[1].method_15441()).floatValue()).lerpBrightness(((Float)face[1].method_15441()).floatValue()));
                buffer.method_60830(v2).method_39415(c.withAlpha(((Float)face[2].method_15441()).floatValue()).lerpBrightness(((Float)face[2].method_15441()).floatValue()));
                buffer.method_60830(v3).method_39415(c.withAlpha(((Float)face[3].method_15441()).floatValue()).lerpBrightness(((Float)face[3].method_15441()).floatValue()));
            }
        }
    }
}

