/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.lightshow_event_visualizer;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.BeatmapPlayer;
import com.beatcraft.beatmap.Difficulty;
import com.beatcraft.lightshow.environment.Environment;
import com.beatcraft.lightshow.environment.EnvironmentV2;
import com.beatcraft.lightshow.environment.EnvironmentV3;
import com.beatcraft.lightshow.environment.EnvironmentV4;
import com.beatcraft.lightshow.event.EventBuilder;
import com.beatcraft.lightshow.event.events.LightEventV3;
import com.beatcraft.lightshow.event.events.RotationEventV3;
import com.beatcraft.lightshow.lights.TransformState;
import com.beatcraft.render.DebugRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@net.fabricmc.api.Environment(value=EnvType.CLIENT)
public class EventVisualizer {
    public static ArrayList<Integer> hiddenGroups = new ArrayList();
    public static HashMap<Integer, ArrayList<Integer>> hiddenIDs = new HashMap();
    public static Integer previewGroup = null;
    private static final ArrayList<EventBuilder.GroupKey> targets = new ArrayList();
    private static final float LANE_WIDTH = 1.0f;
    private static final float LANE_GAP = 0.2f;
    private static final float SUB_LANE_WIDTH = 0.1f;
    private static final float SUB_LANE_GAP = 0.0333f;
    private static final float EVENT_Y = 0.02f;
    private static final float Y_SPACING = 1.0f;
    private static float beatSpacing = 1.0f;
    private static float fDist = 1.0f;
    private static float bDist = 1.0f;
    private static float currentWidth = 0.0f;
    private static float beat = 0.0f;

    public static void refresh() {
        Difficulty beatmap = BeatmapPlayer.currentBeatmap;
        if (beatmap == null) {
            return;
        }
        Environment environment = beatmap.lightShowEnvironment;
        if (environment == null) {
            return;
        }
        beatSpacing = BeatCraftClient.playerConfig.getDebugLightshowBeatSpacing();
        fDist = BeatCraftClient.playerConfig.getDebugLightshowLookAhead();
        bDist = BeatCraftClient.playerConfig.getDebugLightshowLookBehind();
        if (environment instanceof EnvironmentV4) {
            EnvironmentV4 env4 = (EnvironmentV4)environment;
        } else if (environment instanceof EnvironmentV3) {
            EnvironmentV3 env3 = (EnvironmentV3)environment;
            int groupCount = env3.getGroupCount();
            targets.clear();
            currentWidth = 0.0f;
            int lanes = 0;
            for (int group = 0; group < groupCount; ++group) {
                if (hiddenGroups.contains(group)) continue;
                int lightCount = env3.getLightCount(group);
                for (int lightID = 0; lightID < lightCount; ++lightID) {
                    if (hiddenIDs.computeIfAbsent(group, k -> new ArrayList()).contains(lightID)) continue;
                    targets.add(new EventBuilder.GroupKey(group, lightID));
                    ++lanes;
                }
                currentWidth += 1.0f;
            }
            currentWidth -= 1.0f;
            currentWidth *= 0.1667f;
            currentWidth += (float)(--lanes) * 0.1333f;
        } else if (environment instanceof EnvironmentV2) {
            EnvironmentV2 environmentV2 = (EnvironmentV2)environment;
        }
    }

    public static void update(float beat) {
        EventVisualizer.beat = beat;
    }

    public static void render(class_4184 camera) {
        if (DebugRenderer.doDebugRendering && BeatCraftClient.playerConfig.doLightshowEventRendering()) {
            Difficulty beatmap = BeatmapPlayer.currentBeatmap;
            if (beatmap == null) {
                return;
            }
            Environment environment = beatmap.lightShowEnvironment;
            if (environment == null) {
                return;
            }
            float lowerBound = beat - bDist;
            float upperBound = beat + fDist;
            float version = environment.getVersion();
            class_289 tessellator = class_289.method_1348();
            if (version == 4.0f) {
                EnvironmentV4 environmentV4 = (EnvironmentV4)environment;
            } else if (version == 3.0f) {
                EnvironmentV3 env3 = (EnvironmentV3)environment;
                if (previewGroup == null) {
                    float x = currentWidth / 2.0f;
                    int lg = 0;
                    class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
                    for (EventBuilder.GroupKey target : targets) {
                        int cg = target.getGroup();
                        int cid = target.getLightId();
                        List<LightEventV3> lightEvents = env3.getLightEvents(cg, cid, lowerBound, upperBound);
                        List<RotationEventV3> rotationXEvents = env3.getRotationEvents(cg, cid, TransformState.Axis.RX, lowerBound, upperBound);
                        List<RotationEventV3> rotationYEvents = env3.getRotationEvents(cg, cid, TransformState.Axis.RY, lowerBound, upperBound);
                        List<RotationEventV3> rotationZEvents = env3.getRotationEvents(cg, cid, TransformState.Axis.RZ, lowerBound, upperBound);
                        Vector3f c = camera.field_18712.method_46409();
                        if (lg != cg) {
                            lg = cg;
                            x -= 0.3f;
                        } else {
                            x -= 0.1333f;
                        }
                        buffer.method_60830(new Vector3f(-currentWidth / 2.0f - 0.2666f, 0.03f, -0.1f).sub((Vector3fc)c)).method_39415(-1);
                        buffer.method_60830(new Vector3f(currentWidth / 2.0f - 0.1f, 0.03f, -0.1f).sub((Vector3fc)c)).method_39415(-1);
                        buffer.method_60830(new Vector3f(currentWidth / 2.0f - 0.1f, 0.03f, 0.0f).sub((Vector3fc)c)).method_39415(-1);
                        buffer.method_60830(new Vector3f(-currentWidth / 2.0f - 0.2666f, 0.03f, 0.0f).sub((Vector3fc)c)).method_39415(-1);
                        for (LightEventV3 event : lightEvents) {
                            float sz = (Math.max(event.getEventBeat(), lowerBound) - beat) * beatSpacing;
                            float ez = (Math.min(event.getEventBeat() + event.getEventDuration(), upperBound) - beat) * beatSpacing;
                            int startColor = event.startState.getBloomColor();
                            boolean isStep = event.easing.apply(Float.valueOf(0.9f)).floatValue() == 0.0f;
                            int endColor = isStep ? startColor : event.lightState.getBloomColor();
                            float startX = x;
                            float startX2 = x - 0.1f;
                            float endX = x;
                            float endX2 = x - 0.1f;
                            if (event.lightState.strobeFrequency != 0.0f) {
                                endX = x - 0.05f;
                            }
                            if (event.startState.strobeFrequency != 0.0f) {
                                startX = x - 0.05f;
                            }
                            buffer.method_60830(new Vector3f(startX, 0.02f, sz).sub((Vector3fc)c)).method_39415(startColor);
                            buffer.method_60830(new Vector3f(endX, 0.02f, ez).sub((Vector3fc)c)).method_39415(endColor);
                            buffer.method_60830(new Vector3f(endX2, 0.02f, ez).sub((Vector3fc)c)).method_39415(endColor);
                            buffer.method_60830(new Vector3f(startX2, 0.02f, sz).sub((Vector3fc)c)).method_39415(startColor);
                        }
                    }
                    class_9801 buff = buffer.method_60794();
                    if (buff != null) {
                        RenderSystem.setShader(class_757::method_34540);
                        RenderSystem.disableCull();
                        class_286.method_43433((class_9801)buff);
                        RenderSystem.enableCull();
                    }
                }
            } else if (version == 2.0f) {
                EnvironmentV2 environmentV2 = (EnvironmentV2)environment;
            }
        }
    }
}

