/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.menu;

import blue.endless.jankson.annotation.Nullable;
import com.beatcraft.menu.Menu;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.dynamic_loader.DynamicTexture;
import com.beatcraft.utils.MathUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public abstract class MenuPanel<T extends Menu> {
    protected Vector3f position = new Vector3f();
    protected Quaternionf orientation = new Quaternionf();
    protected Vector2f size = new Vector2f();
    protected int backgroundColor = -1879048192;
    protected T data;
    protected ArrayList<Widget> widgets = new ArrayList();

    public MenuPanel(T data) {
        this.data = data;
    }

    public class_3545<Vector3f, Vector2f> raycast(Vector3f position, Quaternionf orientation) {
        return MathUtil.raycastPlane(position, orientation, this.position, this.orientation, this.size.div(128.0f, new Vector2f()));
    }

    public Vector3f getNormal() {
        return new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)this.orientation);
    }

    public void render(class_4597.class_4598 immediate, @Nullable Vector2f pointerPosition) {
        class_332 context = new class_332(class_310.method_1551(), immediate);
        Vector3f camPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        context.translate(-camPos.x, -camPos.y, -camPos.z);
        context.translate(this.position.x, this.position.y, this.position.z);
        context.multiply(this.orientation);
        context.scale(0.0078125f, 0.0078125f, 0.0078125f);
        context.push();
        context.method_25294((int)(-this.size.x / 2.0f), (int)(-this.size.y / 2.0f), (int)(this.size.x / 2.0f), (int)(this.size.y / 2.0f), this.backgroundColor);
        this.widgets.forEach(w -> w.draw(context, pointerPosition == null ? null : pointerPosition.mul(-128.0f, new Vector2f())));
        context.method_51452();
        context.pop();
    }

    @Environment(value=EnvType.CLIENT)
    protected static abstract class Widget {
        protected Vector3f position = new Vector3f();
        protected Vector2f size = new Vector2f();
        protected ArrayList<Widget> children = new ArrayList();

        protected Widget() {
        }

        protected void draw(class_332 context, @Nullable Vector2f pointerPosition) {
            context.push();
            Vector2f p = pointerPosition == null ? null : new Vector2f((Vector2fc)pointerPosition).sub((Vector2fc)new Vector2f(this.position.x, this.position.y));
            this.render(context, p);
            this.children.forEach(w -> w.draw(context, p));
            context.pop();
        }

        protected abstract void render(class_332 var1, @Nullable Vector2f var2);
    }

    @Environment(value=EnvType.CLIENT)
    protected static class ContainerWidget
    extends Widget {
        protected ContainerWidget(Vector3f position, Vector2f size, Widget ... children) {
            this.position = position;
            this.size = size;
            this.children = new ArrayList<Widget>(Arrays.stream(children).toList());
        }

        @Override
        protected void render(class_332 context, Vector2f pointerPosition) {
            context.translate(-this.position.x, -this.position.y, -this.position.z);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected static class DynamicGradientWidget
    extends Widget {
        private final Callable<Integer> col1;
        private final Callable<Integer> col2;
        private final float angle;

        protected DynamicGradientWidget(Vector3f position, Vector2f size, Callable<Integer> col1, Callable<Integer> col2, float angle) {
            this.position = position;
            this.size = size;
            this.col1 = col1;
            this.col2 = col2;
            this.angle = angle;
        }

        @Override
        protected void render(class_332 context, Vector2f pointerPosition) {
            context.translate(-this.position.x, -this.position.y, -this.position.z);
            try {
                context.method_25296((int)(-this.size.x) / 2, (int)(-this.size.y) / 2, (int)this.size.x / 2, (int)this.size.y / 2, this.col1.call().intValue(), this.col2.call().intValue());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected static class GradientWidget
    extends Widget {
        private final int col1;
        private final int col2;
        private final float angle;

        protected GradientWidget(Vector3f position, Vector2f size, int col1, int col2, float angle) {
            this.position = position;
            this.size = size;
            this.col1 = col1;
            this.col2 = col2;
            this.angle = angle;
        }

        @Override
        protected void render(class_332 context, Vector2f pointerPosition) {
            context.translate(-this.position.x, -this.position.y, -this.position.z);
            context.method_25296((int)(-this.size.x) / 2, (int)(-this.size.y) / 2, (int)this.size.x / 2, (int)this.size.y / 2, this.col1, this.col2);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected static class HoverWidget
    extends Widget {
        protected ArrayList<Widget> childrenB;
        protected boolean hovered = false;

        protected HoverWidget(Vector3f position, Vector2f size, List<Widget> childrenA, List<Widget> childrenB) {
            this.position = position;
            this.size = size;
            this.children = new ArrayList<Widget>(childrenA);
            this.childrenB = new ArrayList<Widget>(childrenB);
        }

        @Override
        protected void draw(class_332 context, @Nullable Vector2f pointerPosition) {
            context.push();
            Vector2f p = pointerPosition == null ? null : new Vector2f((Vector2fc)pointerPosition).sub((Vector2fc)new Vector2f(this.position.x, this.position.y));
            this.render(context, p);
            if (this.hovered) {
                this.childrenB.forEach(w -> w.draw(context, p));
            } else {
                this.children.forEach(w -> w.draw(context, p));
            }
            context.pop();
        }

        @Override
        protected void render(class_332 context, @Nullable Vector2f pointerPosition) {
            context.translate(-this.position.x, -this.position.y, -this.position.z);
            if (pointerPosition != null) {
                this.hovered = MathUtil.check2DPointCollision(pointerPosition, new Vector2f(), this.size);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected static class ToggleWidget
    extends Widget {
        protected ArrayList<Widget> childrenB;
        protected Consumer<Boolean> changeHandler;
        protected boolean state = false;

        protected ToggleWidget(Vector3f position, Vector2f size, List<Widget> childrenA, List<Widget> childrenB, Consumer<Boolean> toggleHandler) {
            this.children = new ArrayList<Widget>(childrenA);
            this.childrenB = new ArrayList<Widget>(childrenB);
            this.position = position;
            this.size = size;
            this.changeHandler = toggleHandler;
        }

        public void setState(boolean state) {
            if (state == this.state) {
                return;
            }
            this.state = state;
            this.changeHandler.accept(state);
        }

        @Override
        protected void draw(class_332 context, @Nullable Vector2f pointerPosition) {
            context.push();
            Vector2f p = pointerPosition == null ? null : new Vector2f((Vector2fc)pointerPosition).sub((Vector2fc)new Vector2f(this.position.x, this.position.y));
            this.render(context, p);
            if (this.state) {
                this.children.forEach(w -> w.draw(context, p));
            } else {
                this.childrenB.forEach(w -> w.draw(context, p));
            }
            context.pop();
        }

        @Override
        protected void render(class_332 context, @Nullable Vector2f pointerPosition) {
            context.translate(-this.position.x, -this.position.y, -this.position.z);
            if (pointerPosition != null && MathUtil.check2DPointCollision(pointerPosition, new Vector2f(), this.size) && HUDRenderer.isTriggerPressed()) {
                assert (class_310.method_1551().field_1724 != null);
                class_310.method_1551().field_1724.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 0.2f, 1.0f);
                this.state = !this.state;
                this.changeHandler.accept(this.state);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected static class TextureWidget
    extends Widget {
        protected class_2960 texture = null;
        protected DynamicTexture dynamicTexture = null;
        protected float scaleX = 1.0f;
        protected float scaleY = 1.0f;

        protected TextureWidget(class_2960 texture, Vector3f position, Vector2f size) {
            this.texture = texture;
            this.position = position;
            this.size = size;
        }

        protected TextureWidget(DynamicTexture texture, Vector3f position) {
            this.position = position;
            this.dynamicTexture = texture;
            this.texture = texture.id();
        }

        protected TextureWidget withScale(float scale) {
            this.scaleX = scale;
            this.scaleY = scale;
            return this;
        }

        protected TextureWidget withScale(float scaleX, float scaleY) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            return this;
        }

        @Override
        protected void render(class_332 context, @Nullable Vector2f pointerPosition) {
            context.translate(-this.position.x, -this.position.y, -this.position.z);
            context.scale(-this.scaleX, -this.scaleY, -1.0f);
            context.method_25290(this.texture, -((int)(this.size.x / 2.0f)), -((int)(this.size.y / 2.0f)), (float)((int)this.size.x), (float)((int)this.size.y), (int)this.size.x, (int)this.size.y, (int)this.size.x, (int)this.size.y);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected static class TextWidget
    extends Widget {
        protected String text;
        protected float scale = 1.0f;
        public int color = -1;
        private int alignment = 1;
        private int wrapWidth = 0;
        private boolean doDynamicScaling = false;
        private int scalingWidth = 0;
        private boolean doDynamicUpdating = false;
        private Callable<String> textGetter = null;

        protected TextWidget(Callable<String> textProvider, Vector3f position, float scale) {
            try {
                this.text = textProvider.call();
                this.doDynamicUpdating = true;
                this.textGetter = textProvider;
                this.position = position;
                this.scale = scale;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected TextWidget(Callable<String> textProvider, Vector3f position) {
            try {
                this.text = textProvider.call();
                this.doDynamicUpdating = true;
                this.textGetter = textProvider;
                this.position = position;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected TextWidget(String text, Vector3f position, float scale) {
            this.text = text;
            this.position = position;
            this.scale = scale;
        }

        protected TextWidget(String text, Vector3f position) {
            this.text = text;
            this.position = position;
        }

        protected TextWidget alignedLeft() {
            this.alignment = 0;
            return this;
        }

        protected TextWidget withWrapWidth(int width) {
            this.wrapWidth = width;
            this.alignment = -1;
            return this;
        }

        protected TextWidget withColor(int color) {
            this.color = color;
            return this;
        }

        protected TextWidget withScale(float scale) {
            this.scale = scale;
            return this;
        }

        protected TextWidget withDynamicScaling(int maxWidth) {
            this.scalingWidth = maxWidth;
            this.doDynamicScaling = true;
            return this;
        }

        @Override
        protected void render(class_332 context, @Nullable Vector2f pointerPosition) {
            int currentWidth;
            context.translate(-this.position.x, -this.position.y, -this.position.z);
            context.scale(-this.scale, -this.scale, -this.scale);
            if (this.doDynamicUpdating) {
                try {
                    this.text = this.textGetter.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.doDynamicScaling && (currentWidth = class_310.method_1551().field_1772.method_1727(this.text)) > this.scalingWidth) {
                float rescale = (float)this.scalingWidth / (float)currentWidth;
                context.push();
                context.scale(rescale, rescale, rescale);
            }
            if (this.alignment == 0) {
                context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)this.text), 0, 0, this.color, false);
            } else if (this.alignment == 1) {
                context.method_51439(class_310.method_1551().field_1772, class_2561.method_30163((String)this.text), -class_310.method_1551().field_1772.method_1727(this.text) / 2, 0, this.color, false);
            } else if (this.alignment == -1) {
                context.method_51440(class_310.method_1551().field_1772, (class_5348)class_2561.method_30163((String)this.text), -this.wrapWidth / 2, 0, this.wrapWidth, this.color);
            }
            if (pointerPosition != null) {
                pointerPosition.mul(this.scale);
            }
            if (this.doDynamicScaling && (currentWidth = class_310.method_1551().field_1772.method_1727(this.text)) > this.scalingWidth) {
                context.pop();
            }
            context.scale(-1.0f / this.scale, -1.0f / this.scale, -1.0f / this.scale);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected static class ButtonWidget
    extends Widget {
        protected Runnable onClickHandler;

        protected ButtonWidget(Vector3f position, Vector2f size, Runnable onClickHandler, Widget ... children) {
            this.position = position;
            this.size = size;
            this.onClickHandler = onClickHandler;
            this.children = new ArrayList<Widget>(Arrays.stream(children).toList());
        }

        @Override
        protected void render(class_332 context, @Nullable Vector2f pointerPosition) {
            context.translate(-this.position.x, -this.position.y, -this.position.z);
            if (pointerPosition != null && MathUtil.check2DPointCollision(pointerPosition, new Vector2f(), this.size) && HUDRenderer.isTriggerPressed()) {
                assert (class_310.method_1551().field_1724 != null);
                class_310.method_1551().field_1724.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 0.2f, 1.0f);
                this.onClickHandler.run();
            }
        }
    }
}

