/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.menu;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.data.ControllerProfile;
import com.beatcraft.menu.SettingsMenu;
import com.beatcraft.render.menu.MenuPanel;
import java.util.List;
import java.util.concurrent.Callable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4597;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class SettingsMenuPanel
extends MenuPanel<SettingsMenu> {
    private int selected;
    private boolean refresh = false;

    public SettingsMenuPanel() {
        super(new SettingsMenu());
        this.backgroundColor = 0;
        this.position.set(0.1f, 2.0f, 6.0f);
        this.size.set(1000.0f, 500.0f);
        this.initLayout();
    }

    private Vector3f clampVector3(Vector3f input, int axis, float min, float max) {
        if (axis == 0) {
            return new Vector3f(Math.clamp(input.x, min, max), input.y, input.z);
        }
        if (axis == 1) {
            return new Vector3f(input.x, Math.clamp(input.y, min, max), input.z);
        }
        return new Vector3f(input.x, input.y, Math.clamp(input.z, min, max));
    }

    @Override
    public void render(class_4597.class_4598 immediate, Vector2f pointerPosition) {
        super.render(immediate, pointerPosition);
        if (this.refresh) {
            this.refresh = false;
            this.initLayout();
        }
    }

    private void initLayout() {
        this.widgets.clear();
        this.selected = BeatCraftClient.playerConfig.getSelectedControllerProfileIndex();
        ControllerProfile profile = BeatCraftClient.playerConfig.getActiveControllerProfile();
        MenuPanel.TextWidget selectedProfileDisplay = new MenuPanel.TextWidget(this.selected == -1 ? "DEFAULT" : String.valueOf(this.selected), new Vector3f(0.0f, 189.0f, 0.0f)).withScale(3.0f);
        MenuPanel.ButtonWidget profileBack = SettingsMenuPanel.getButton(new MenuPanel.TextWidget("<", new Vector3f(0.0f, -11.0f, 0.05f)).withScale(3.0f), this::back, new Vector3f(-100.0f, 200.0f, 0.0f), new Vector2f(50.0f, 50.0f));
        MenuPanel.ButtonWidget profileNext = SettingsMenuPanel.getButton(new MenuPanel.TextWidget(">", new Vector3f(0.0f, -11.0f, 0.05f)).withScale(3.0f), this::next, new Vector3f(100.0f, 200.0f, 0.0f), new Vector2f(50.0f, 50.0f));
        MenuPanel.ButtonWidget newProfile = SettingsMenuPanel.getButton(new MenuPanel.TextWidget("NEW PROFILE", new Vector3f(0.0f, -11.0f, 0.05f)).withScale(3.0f), this::addProfile, new Vector3f(270.0f, 200.0f, 0.0f), new Vector2f(200.0f, 50.0f));
        this.widgets.addAll(List.of(new MenuPanel.TextWidget("CONTROLLER PROFILES", new Vector3f(0.0f, -200.0f, 0.0f), 3.0f), selectedProfileDisplay, profileBack, profileNext, newProfile));
        if (this.selected >= 0) {
            int LEFT = -100;
            int RIGHT = 250;
            this.widgets.addAll(List.of(SettingsMenuPanel.getOptionModifier("Left position X", () -> profile.setLeftTranslation(this.clampVector3(profile.getLeftTranslation().add(-0.01f, 0.0f, 0.0f), 0, -0.1f, 0.1f)), () -> profile.setLeftTranslation(this.clampVector3(profile.getLeftTranslation().add(0.01f, 0.0f, 0.0f), 0, -0.1f, 0.1f)), () -> String.format("%.2f", Float.valueOf(profile.getLeftTranslation().x)), new Vector3f((float)LEFT, -100.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("Left position Y", () -> profile.setLeftTranslation(this.clampVector3(profile.getLeftTranslation().add(0.0f, -0.01f, 0.0f), 1, -0.1f, 0.1f)), () -> profile.setLeftTranslation(this.clampVector3(profile.getLeftTranslation().add(0.0f, 0.01f, 0.0f), 1, -0.1f, 0.1f)), () -> String.format("%.2f", Float.valueOf(profile.getLeftTranslation().y)), new Vector3f((float)LEFT, -50.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("Left position Z", () -> profile.setLeftTranslation(this.clampVector3(profile.getLeftTranslation().add(0.0f, 0.0f, -0.01f), 2, -0.1f, 0.1f)), () -> profile.setLeftTranslation(this.clampVector3(profile.getLeftTranslation().add(0.0f, 0.0f, 0.01f), 2, -0.1f, 0.1f)), () -> String.format("%.2f", Float.valueOf(profile.getLeftTranslation().z)), new Vector3f((float)LEFT, 0.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("Left rotation X", () -> profile.setLeftRotation(this.clampVector3(profile.getLeftRotationEuler().add(-1.0f, 0.0f, 0.0f), 0, -180.0f, 180.0f)), () -> profile.setLeftRotation(this.clampVector3(profile.getLeftRotationEuler().add(1.0f, 0.0f, 0.0f), 0, -180.0f, 180.0f)), () -> String.format("%.0f", Float.valueOf(profile.getLeftRotationEuler().x)), new Vector3f((float)LEFT, 50.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("Left rotation Y", () -> profile.setLeftRotation(this.clampVector3(profile.getLeftRotationEuler().add(0.0f, -1.0f, 0.0f), 1, -180.0f, 180.0f)), () -> profile.setLeftRotation(this.clampVector3(profile.getLeftRotationEuler().add(0.0f, 1.0f, 0.0f), 1, -180.0f, 180.0f)), () -> String.format("%.0f", Float.valueOf(profile.getLeftRotationEuler().y)), new Vector3f((float)LEFT, 100.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("Left rotation Z", () -> profile.setLeftRotation(this.clampVector3(profile.getLeftRotationEuler().add(0.0f, 0.0f, -1.0f), 2, -180.0f, 180.0f)), () -> profile.setLeftRotation(this.clampVector3(profile.getLeftRotationEuler().add(0.0f, 0.0f, 1.0f), 2, -180.0f, 180.0f)), () -> String.format("%.0f", Float.valueOf(profile.getLeftRotationEuler().z)), new Vector3f((float)LEFT, 150.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("right position X", () -> profile.setRightTranslation(this.clampVector3(profile.getRightTranslation().add(-0.01f, 0.0f, 0.0f), 0, -0.1f, 0.1f)), () -> profile.setRightTranslation(this.clampVector3(profile.getRightTranslation().add(0.01f, 0.0f, 0.0f), 0, -0.1f, 0.1f)), () -> String.format("%.2f", Float.valueOf(profile.getRightTranslation().x)), new Vector3f((float)RIGHT, -100.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("right position Y", () -> profile.setRightTranslation(this.clampVector3(profile.getRightTranslation().add(0.0f, -0.01f, 0.0f), 1, -0.1f, 0.1f)), () -> profile.setRightTranslation(this.clampVector3(profile.getRightTranslation().add(0.0f, 0.01f, 0.0f), 1, -0.1f, 0.1f)), () -> String.format("%.2f", Float.valueOf(profile.getRightTranslation().y)), new Vector3f((float)RIGHT, -50.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("right position Z", () -> profile.setRightTranslation(this.clampVector3(profile.getRightTranslation().add(0.0f, 0.0f, -0.01f), 2, -0.1f, 0.1f)), () -> profile.setRightTranslation(this.clampVector3(profile.getRightTranslation().add(0.0f, 0.0f, 0.01f), 2, -0.1f, 0.1f)), () -> String.format("%.2f", Float.valueOf(profile.getRightTranslation().z)), new Vector3f((float)RIGHT, 0.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("right rotation X", () -> profile.setRightRotation(this.clampVector3(profile.getRightRotationEuler().add(-1.0f, 0.0f, 0.0f), 0, -180.0f, 180.0f)), () -> profile.setRightRotation(this.clampVector3(profile.getRightRotationEuler().add(1.0f, 0.0f, 0.0f), 0, -180.0f, 180.0f)), () -> String.format("%.0f", Float.valueOf(profile.getRightRotationEuler().x)), new Vector3f((float)RIGHT, 50.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("right rotation Y", () -> profile.setRightRotation(this.clampVector3(profile.getRightRotationEuler().add(0.0f, -1.0f, 0.0f), 1, -180.0f, 180.0f)), () -> profile.setRightRotation(this.clampVector3(profile.getRightRotationEuler().add(0.0f, 1.0f, 0.0f), 1, -180.0f, 180.0f)), () -> String.format("%.0f", Float.valueOf(profile.getRightRotationEuler().y)), new Vector3f((float)RIGHT, 100.0f, -0.01f)), SettingsMenuPanel.getOptionModifier("right rotation Z", () -> profile.setRightRotation(this.clampVector3(profile.getRightRotationEuler().add(0.0f, 0.0f, -1.0f), 2, -180.0f, 180.0f)), () -> profile.setRightRotation(this.clampVector3(profile.getRightRotationEuler().add(0.0f, 0.0f, 1.0f), 2, -180.0f, 180.0f)), () -> String.format("%.0f", Float.valueOf(profile.getRightRotationEuler().z)), new Vector3f((float)RIGHT, 150.0f, -0.01f))));
        }
    }

    protected static MenuPanel.ButtonWidget getButton(MenuPanel.Widget display, Runnable onClick, Vector3f position, Vector2f size) {
        return SettingsMenuPanel.getButton(display, onClick, position, size, 0x5F222222, 0x5F444444);
    }

    protected static MenuPanel.ButtonWidget getButton(MenuPanel.Widget display, Runnable onClick, Vector3f position, Vector2f size, int c1, int c2) {
        return new MenuPanel.ButtonWidget(position, size, onClick, new MenuPanel.HoverWidget(new Vector3f(), new Vector2f((Vector2fc)size), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((Vector2fc)size), c1, c1, 0.0f)), List.of(new MenuPanel.GradientWidget(new Vector3f(), new Vector2f((Vector2fc)size), c2, c2, 0.0f))), display);
    }

    protected static MenuPanel.Widget getOptionModifier(String label, Runnable down, Runnable up, Callable<String> getter, Vector3f position) {
        Vector2f SIZE = new Vector2f();
        try {
            MenuPanel.TextWidget valueDisplay = new MenuPanel.TextWidget(getter, new Vector3f(0.0f, -11.0f, 0.0f)).withScale(3.0f);
            Runnable left = () -> {
                try {
                    down.run();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            Runnable right = () -> {
                try {
                    up.run();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            return new MenuPanel.ContainerWidget(position, new Vector2f((Vector2fc)SIZE), new MenuPanel.TextWidget(label, new Vector3f(-160.0f, -11.0f, -0.01f)).withScale(1.5f), SettingsMenuPanel.getButton(new MenuPanel.TextWidget("<", new Vector3f(0.0f, -11.0f, 0.05f), 3.0f), left, new Vector3f(-60.0f, 0.0f, 0.0f), new Vector2f(50.0f, 50.0f)), valueDisplay, SettingsMenuPanel.getButton(new MenuPanel.TextWidget(">", new Vector3f(0.0f, -11.0f, 0.05f), 3.0f), right, new Vector3f(60.0f, 0.0f, 0.0f), new Vector2f(50.0f, 50.0f)));
        }
        catch (Exception e) {
            return new MenuPanel.TextWidget("ERROR creating widget!", new Vector3f());
        }
    }

    private void back() {
        BeatCraftClient.playerConfig.selectProfile(this.selected - 1);
        this.refresh = true;
    }

    private void next() {
        BeatCraftClient.playerConfig.selectProfile(this.selected + 1);
        this.refresh = true;
    }

    private void addProfile() {
        BeatCraftClient.playerConfig.addProfile();
        BeatCraftClient.playerConfig.selectProfile(BeatCraftClient.playerConfig.getProfileCount());
    }
}

