/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.mesh;

import com.beatcraft.BeatCraft;
import com.beatcraft.mixin_utils.ModelLoaderAccessor;
import com.beatcraft.render.mesh.Quad;
import com.beatcraft.render.mesh.QuadMesh;
import com.beatcraft.render.mesh.TriangleMesh;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_783;
import net.minecraft.class_793;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class MeshLoader {
    public static QuadMesh COLOR_NOTE_MESH;
    public static QuadMesh CHAIN_HEAD_MESH;
    public static QuadMesh CHAIN_LINK_MESH;
    public static QuadMesh BOMB_MESH;
    public static TriangleMesh COLOR_NOTE_RENDER_MESH;
    public static TriangleMesh CHAIN_HEAD_RENDER_MESH;
    public static TriangleMesh CHAIN_LINK_RENDER_MESH;
    public static TriangleMesh NOTE_ARROW_RENDER_MESH;
    public static TriangleMesh NOTE_DOT_RENDER_MESH;
    public static TriangleMesh CHAIN_DOT_RENDER_MESH;
    public static TriangleMesh BOMB_RENDER_MESH;
    public static final class_2960 NOTE_TEXTURE;
    public static final class_2960 ARROW_TEXTURE;
    private static ModelLoaderAccessor modelLoader;

    public static void loadGameplayMeshes(ModelLoaderAccessor modelLoader) {
        MeshLoader.modelLoader = modelLoader;
        COLOR_NOTE_MESH = MeshLoader.loadMesh(BeatCraft.id("item/color_note"));
        MeshLoader.COLOR_NOTE_MESH.texture = NOTE_TEXTURE;
        CHAIN_HEAD_MESH = MeshLoader.loadMesh(BeatCraft.id("item/color_note_chain_head"));
        MeshLoader.CHAIN_HEAD_MESH.texture = NOTE_TEXTURE;
        CHAIN_LINK_MESH = MeshLoader.loadMesh(BeatCraft.id("item/color_note_chain_link"));
        MeshLoader.CHAIN_LINK_MESH.texture = NOTE_TEXTURE;
        BOMB_MESH = MeshLoader.loadMesh(BeatCraft.id("item/bomb_note"));
        MeshLoader.BOMB_MESH.texture = NOTE_TEXTURE;
        QuadMesh arrow_mesh = MeshLoader.loadMesh(BeatCraft.id("item/note_arrow"));
        arrow_mesh.texture = ARROW_TEXTURE;
        QuadMesh dot_mesh = MeshLoader.loadMesh(BeatCraft.id("item/note_dot"));
        dot_mesh.texture = ARROW_TEXTURE;
        QuadMesh chain_dot_mesh = MeshLoader.loadMesh(BeatCraft.id("item/chain_note_dot"));
        chain_dot_mesh.texture = ARROW_TEXTURE;
        COLOR_NOTE_RENDER_MESH = COLOR_NOTE_MESH.toTriangleMesh();
        CHAIN_HEAD_RENDER_MESH = CHAIN_HEAD_MESH.toTriangleMesh();
        CHAIN_LINK_RENDER_MESH = CHAIN_LINK_MESH.toTriangleMesh();
        BOMB_RENDER_MESH = BOMB_MESH.toTriangleMesh();
        NOTE_ARROW_RENDER_MESH = arrow_mesh.toTriangleMesh();
        NOTE_DOT_RENDER_MESH = dot_mesh.toTriangleMesh();
        CHAIN_DOT_RENDER_MESH = chain_dot_mesh.toTriangleMesh();
    }

    public static QuadMesh loadMesh(class_2960 identifier) {
        try {
            class_793 model = modelLoader.beatCraft$loadJsonModel(identifier);
            QuadMesh mesh = new QuadMesh();
            model.method_3433().forEach(element -> {
                Vector3f origin;
                Vector3f min = element.field_4228.mul(0.03125f, new Vector3f());
                Vector3f max = element.field_4231.mul(0.03125f, new Vector3f());
                float angleDegrees = 0.0f;
                class_2350.class_2351 axis = class_2350.class_2351.field_11048;
                if (element.field_4232 != null) {
                    angleDegrees = element.field_4232.comp_1120();
                    axis = element.field_4232.comp_1119();
                    origin = element.field_4232.comp_1118().mul(0.5f);
                } else {
                    origin = new Vector3f(0.0f, 0.0f, 0.0f);
                }
                int start = mesh.vertices.size();
                if (angleDegrees != 0.0f) {
                    mesh.addUniquePermutedVertices(min, max);
                } else {
                    mesh.addPermutedVertices(min, max);
                }
                int end = mesh.vertices.size();
                element.field_4230.forEach((dir, face) -> {
                    Vector2f[] uvs = MeshLoader.getUvs(face);
                    switch (dir) {
                        case field_11033: {
                            mesh.quads.add(new Quad(mesh.vertIdx(min), mesh.vertIdx(new Vector3f(min.x, min.y, max.z)), mesh.vertIdx(new Vector3f(max.x, min.y, max.z)), mesh.vertIdx(new Vector3f(max.x, min.y, min.z)), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11036: {
                            mesh.quads.add(new Quad(mesh.vertIdx(new Vector3f(min.x, max.y, max.z)), mesh.vertIdx(new Vector3f(min.x, max.y, min.z)), mesh.vertIdx(new Vector3f(max.x, max.y, min.z)), mesh.vertIdx(max), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11043: {
                            mesh.quads.add(new Quad(mesh.vertIdx(new Vector3f(max.x, min.y, min.z)), mesh.vertIdx(new Vector3f(max.x, max.y, min.z)), mesh.vertIdx(new Vector3f(min.x, max.y, min.z)), mesh.vertIdx(min), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11035: {
                            mesh.quads.add(new Quad(mesh.vertIdx(new Vector3f(min.x, min.y, max.z)), mesh.vertIdx(new Vector3f(min.x, max.y, max.z)), mesh.vertIdx(max), mesh.vertIdx(new Vector3f(max.x, min.y, max.z)), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11039: {
                            mesh.quads.add(new Quad(mesh.vertIdx(min), mesh.vertIdx(new Vector3f(min.x, max.y, min.z)), mesh.vertIdx(new Vector3f(min.x, max.y, max.z)), mesh.vertIdx(new Vector3f(min.x, min.y, max.z)), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11034: {
                            mesh.quads.add(new Quad(mesh.vertIdx(new Vector3f(max.x, min.y, max.z)), mesh.vertIdx(max), mesh.vertIdx(new Vector3f(max.x, max.y, min.z)), mesh.vertIdx(new Vector3f(max.x, min.y, min.z)), uvs[2], uvs[0], uvs[1], uvs[3]));
                        }
                    }
                });
                if (angleDegrees != 0.0f) {
                    Vector3f rotationAxis = axis == class_2350.class_2351.field_11048 ? new Vector3f(1.0f, 0.0f, 0.0f) : (axis == class_2350.class_2351.field_11052 ? new Vector3f(0.0f, 1.0f, 0.0f) : new Vector3f(0.0f, 0.0f, 1.0f));
                    Quaternionf rotation = new Quaternionf().rotationAxis(angleDegrees * ((float)Math.PI / 180), (Vector3fc)rotationAxis);
                    mesh.transformVertices(start, end, vert -> {
                        vert.sub((Vector3fc)origin);
                        vert.rotate((Quaternionfc)rotation);
                        vert.add((Vector3fc)origin);
                    });
                }
            });
            return mesh;
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to load model json!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Vector2f @NotNull [] getUvs(class_783 face) {
        float[] rawUvs = face.comp_2870().field_4235;
        Vector2f[] uvs = new Vector2f[]{new Vector2f(rawUvs[0] / 16.0f, rawUvs[1] / 16.0f), new Vector2f(rawUvs[2] / 16.0f, rawUvs[1] / 16.0f), new Vector2f(rawUvs[0] / 16.0f, rawUvs[3] / 16.0f), new Vector2f(rawUvs[2] / 16.0f, rawUvs[3] / 16.0f)};
        for (int rotation = face.comp_2870().field_4234; rotation > 0; rotation -= 90) {
            uvs = new Vector2f[]{uvs[2], uvs[0], uvs[3], uvs[1]};
        }
        return uvs;
    }

    static {
        NOTE_TEXTURE = BeatCraft.id("textures/gameplay_objects/color_note.png");
        ARROW_TEXTURE = BeatCraft.id("textures/gameplay_objects/arrow.png");
    }
}

