/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.mesh;

import com.beatcraft.render.mesh.Geometry;
import com.beatcraft.render.mesh.TriangleMesh;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_3545;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class Triangle
implements Geometry {
    private final int[] indices;
    private final Vector2f[] uvs;

    public Triangle(List<Integer> indices, List<Vector2f> uvs) {
        this.indices = new int[]{indices.getFirst(), indices.get(1), indices.get(2)};
        this.uvs = uvs.toArray(new Vector2f[0]);
    }

    public Triangle(int a, int b, int c, Vector2f uvA, Vector2f uvB, Vector2f uvC) {
        this.indices = new int[]{a, b, c};
        this.uvs = new Vector2f[]{uvA, uvB, uvC};
    }

    public int a() {
        return this.indices[0];
    }

    public int b() {
        return this.indices[1];
    }

    public int c() {
        return this.indices[2];
    }

    public Vector2f uvA() {
        return this.uvs[0];
    }

    public Vector2f uvB() {
        return this.uvs[1];
    }

    public Vector2f uvC() {
        return this.uvs[2];
    }

    public int[] getIndices() {
        return this.indices;
    }

    public Vector2f[] getUvs() {
        return this.uvs;
    }

    public void draw(class_287 buffer, int color, TriangleMesh mesh, Vector3f position, Quaternionf orientation, Vector3f cameraPos) {
        Vector3f v0 = mesh.vertices.get(this.indices[0]).rotate((Quaternionfc)orientation, new Vector3f()).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        Vector3f v1 = mesh.vertices.get(this.indices[1]).rotate((Quaternionfc)orientation, new Vector3f()).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        Vector3f v2 = mesh.vertices.get(this.indices[2]).rotate((Quaternionfc)orientation, new Vector3f()).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        buffer.method_22912(v0.x, v0.y, v0.z).method_22913(this.uvs[0].x, this.uvs[0].y).method_39415(color);
        buffer.method_22912(v1.x, v1.y, v1.z).method_22913(this.uvs[1].x, this.uvs[1].y).method_39415(color);
        buffer.method_22912(v2.x, v2.y, v2.z).method_22913(this.uvs[2].x, this.uvs[2].y).method_39415(color);
    }

    public void drawMirrored(class_287 buffer, int color, TriangleMesh mesh, Vector3f position, Quaternionf orientation, Vector3f cameraPos) {
        Vector3f v0 = mesh.vertices.get(this.indices[0]).mul(1.0f, -1.0f, 1.0f, new Vector3f()).rotate((Quaternionfc)orientation).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        Vector3f v1 = mesh.vertices.get(this.indices[1]).mul(1.0f, -1.0f, 1.0f, new Vector3f()).rotate((Quaternionfc)orientation).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        Vector3f v2 = mesh.vertices.get(this.indices[2]).mul(1.0f, -1.0f, 1.0f, new Vector3f()).rotate((Quaternionfc)orientation).add((Vector3fc)position).sub((Vector3fc)cameraPos);
        buffer.method_22912(v0.x, v0.y, v0.z).method_22913(this.uvs[0].x, this.uvs[0].y).method_39415(color);
        buffer.method_22912(v1.x, v1.y, v1.z).method_22913(this.uvs[1].x, this.uvs[1].y).method_39415(color);
        buffer.method_22912(v2.x, v2.y, v2.z).method_22913(this.uvs[2].x, this.uvs[2].y).method_39415(color);
    }

    public static List<Triangle> fromList(ArrayList<Vector3f> vertices, List<List<class_3545<Vector3f, Vector2f>>> triData) {
        ArrayList<Triangle> tris = new ArrayList<Triangle>();
        for (List<class_3545<Vector3f, Vector2f>> tri : triData) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            ArrayList<Vector2f> uvs = new ArrayList<Vector2f>();
            for (class_3545<Vector3f, Vector2f> vert : tri) {
                int i;
                if (vertices.contains(vert.method_15442())) {
                    i = vertices.indexOf(vert.method_15442());
                } else {
                    i = vertices.size();
                    vertices.add(new Vector3f((Vector3fc)vert.method_15442()));
                }
                indices.add(i);
                uvs.add((Vector2f)vert.method_15441());
            }
            tris.add(new Triangle(indices, uvs));
        }
        return tris;
    }
}

