/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.object;

import com.beatcraft.animation.AnimationState;
import com.beatcraft.beatmap.data.CutDirection;
import com.beatcraft.beatmap.data.NoteType;
import com.beatcraft.beatmap.data.object.ColorNote;
import com.beatcraft.beatmap.data.object.ScorableObject;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.logic.Hitbox;
import com.beatcraft.memory.MemoryPool;
import com.beatcraft.render.BeatCraftRenderer;
import com.beatcraft.render.effect.MirrorHandler;
import com.beatcraft.render.mesh.MeshLoader;
import com.beatcraft.render.mesh.QuadMesh;
import com.beatcraft.render.object.PhysicalGameplayObject;
import com.beatcraft.render.object.PhysicalScorableObject;
import com.beatcraft.utils.MathUtil;
import com.beatcraft.utils.NoteMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1091;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class PhysicalColorNote
extends PhysicalGameplayObject<ColorNote>
implements PhysicalScorableObject {
    public static final class_1091 colorNoteBlockModelID = new class_1091(class_2960.method_60655((String)"beatcraft", (String)"color_note"), "inventory");
    public static final class_1091 noteArrowModelID = new class_1091(class_2960.method_60655((String)"beatcraft", (String)"note_arrow"), "inventory");
    public static final class_1091 noteDotModelID = new class_1091(class_2960.method_60655((String)"beatcraft", (String)"note_dot"), "inventory");
    private static final int overlay = class_4608.method_23624((float)0.0f, (boolean)false);
    private float baseDegrees;
    public static final Hitbox NORMAL_GOOD_CUT_BOUNDS = new Hitbox(new Vector3f(-0.4f, -0.25f, -0.75f), new Vector3f(0.4f, 0.25f, 0.25f));
    private static final Hitbox DOT_GOOD_CUT_BOUNDS = new Hitbox(new Vector3f(-0.4f, -0.4f, -0.75f), new Vector3f(0.4f, 0.4f, 0.25f));
    public static final Hitbox BAD_CUT_BOUNDS = new Hitbox(new Vector3f(-0.175f, -0.175f, -0.175f), new Vector3f(0.175f, 0.175f, 0.175f));
    public static final Hitbox ACCURATE_HITBOX = new Hitbox(new Vector3f(-0.25f, -0.25f, -0.25f), new Vector3f(0.25f, 0.25f, 0.25f));

    public PhysicalColorNote(ColorNote data) {
        super(data);
        this.cutResult = GameLogicHandler.CutResult.noHit(this);
        this.baseDegrees = NoteMath.degreesFromCut(data.getCutDirection());
        this.baseDegrees = (this.baseDegrees + data.getAngleOffset()) % 360.0f;
    }

    public void checkWindowSnap(PhysicalColorNote other) {
        boolean bothAreDots;
        boolean bothAreDifferentArrows;
        boolean sameCuts = ((ColorNote)this.data).getCutDirection() == ((ColorNote)other.data).getCutDirection();
        boolean thisIsDot = ((ColorNote)this.data).getCutDirection() == CutDirection.DOT;
        boolean otherIsDot = ((ColorNote)other.data).getCutDirection() == CutDirection.DOT;
        boolean bl = bothAreDifferentArrows = !sameCuts && !thisIsDot && !otherIsDot;
        if (bothAreDifferentArrows) {
            return;
        }
        Vector2f thisPos = this.get2DPosition();
        Vector2f otherPos = other.get2DPosition();
        Vector2f toOther = otherPos.sub((Vector2fc)thisPos);
        float windowDegrees = MathUtil.getVectorAngleDegrees(toOther) + 90.0f;
        boolean bl2 = bothAreDots = thisIsDot && otherIsDot;
        if (bothAreDots) {
            this.baseDegrees = windowDegrees;
            other.baseDegrees = windowDegrees;
            return;
        }
        float degrees = thisIsDot ? other.baseDegrees : this.baseDegrees;
        float between = MathUtil.degreesBetween(degrees, windowDegrees);
        if (between <= 40.0f) {
            this.baseDegrees = windowDegrees;
            other.baseDegrees = windowDegrees;
        }
    }

    @Override
    protected boolean doNoteLook() {
        return !((ColorNote)this.data).isNoteLookDisabled();
    }

    @Override
    protected boolean doNoteGravity() {
        return !((ColorNote)this.data).isNoteGravityDisabled();
    }

    public void finalizeBaseRotation() {
        float radians = Math.toRadians((float)this.baseDegrees);
        this.baseRotation = new Quaternionf().rotateZ(radians);
    }

    public Vector3f worldToCameraSpace(Vector3f renderPos, Vector3f cameraPos, Quaternionf cameraRot) {
        Vector3f a = renderPos.sub((Vector3fc)cameraPos, new Vector3f());
        a.rotate((Quaternionfc)cameraRot);
        a.add((Vector3fc)cameraPos);
        return a;
    }

    @Override
    protected void objectRender(class_4587 matrices, class_4588 vertexConsumer, AnimationState animationState) {
        class_4587.class_4665 localPos = matrices.method_23760();
        if (!this.isBaseDissolved()) {
            Vector3f camPos = MemoryPool.newVector3f(class_310.method_1551().field_1773.method_19418().method_19326());
            Vector3f renderPos = localPos.method_23761().getTranslation(MemoryPool.newVector3f()).add((Vector3fc)camPos);
            MemoryPool.release(camPos);
            Quaternionf renderRotation = localPos.method_23761().getUnnormalizedRotation(MemoryPool.newQuaternionf());
            BeatCraftRenderer.recordNoteRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(tri, cam) -> {
                MeshLoader.COLOR_NOTE_RENDER_MESH.color = ((ColorNote)this.data).getColor().toARGB();
                MeshLoader.COLOR_NOTE_RENDER_MESH.drawToBuffer((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
            }));
            MirrorHandler.recordMirrorNoteDraw((tri, cam) -> {
                MeshLoader.COLOR_NOTE_RENDER_MESH.color = ((ColorNote)this.data).getColor().toARGB();
                MeshLoader.COLOR_NOTE_RENDER_MESH.drawToBufferMirrored((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
            });
        }
        if (!this.isArrowDissolved()) {
            Vector3f renderPos = localPos.method_23761().getTranslation(MemoryPool.newVector3f()).add((Vector3fc)class_310.method_1551().field_1773.method_19418().method_19326().method_46409());
            Quaternionf renderRotation = localPos.method_23761().getUnnormalizedRotation(MemoryPool.newQuaternionf());
            if (this.getData().getCutDirection() == CutDirection.DOT) {
                BeatCraftRenderer.recordArrowRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(tri, cam) -> {
                    MeshLoader.NOTE_DOT_RENDER_MESH.color = -1;
                    MeshLoader.NOTE_DOT_RENDER_MESH.drawToBuffer((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
                }));
                MirrorHandler.recordMirrorArrowDraw((tri, cam) -> {
                    MeshLoader.NOTE_DOT_RENDER_MESH.color = -1;
                    MeshLoader.NOTE_DOT_RENDER_MESH.drawToBufferMirrored((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
                });
                BeatCraftRenderer.bloomfog.recordArrowBloomCall((TriConsumer<class_287, Vector3f, Quaternionf>)((TriConsumer)(b, v, q) -> {
                    MeshLoader.NOTE_DOT_RENDER_MESH.color = ((ColorNote)this.data).getColor().toARGB();
                    MeshLoader.NOTE_DOT_RENDER_MESH.drawToBuffer((class_287)b, this.worldToCameraSpace(renderPos, (Vector3f)v, (Quaternionf)q), MemoryPool.newQuaternionf(q).mul((Quaternionfc)renderRotation), (Vector3f)v);
                }));
            } else {
                BeatCraftRenderer.recordArrowRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(tri, cam) -> {
                    MeshLoader.NOTE_ARROW_RENDER_MESH.color = -1;
                    MeshLoader.NOTE_ARROW_RENDER_MESH.drawToBuffer((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
                }));
                MirrorHandler.recordMirrorArrowDraw((tri, cam) -> {
                    MeshLoader.NOTE_ARROW_RENDER_MESH.color = -1;
                    MeshLoader.NOTE_ARROW_RENDER_MESH.drawToBufferMirrored((class_287)tri, renderPos, renderRotation, (Vector3f)cam);
                });
                BeatCraftRenderer.bloomfog.recordArrowBloomCall((TriConsumer<class_287, Vector3f, Quaternionf>)((TriConsumer)(b, v, q) -> {
                    MeshLoader.NOTE_ARROW_RENDER_MESH.color = ((ColorNote)this.data).getColor().toARGB();
                    MeshLoader.NOTE_ARROW_RENDER_MESH.drawToBuffer((class_287)b, this.worldToCameraSpace(renderPos, (Vector3f)v, (Quaternionf)q), MemoryPool.newQuaternionf(q).mul((Quaternionfc)renderRotation), (Vector3f)v);
                }));
            }
        }
    }

    @Override
    public float getCollisionDistance() {
        return 0.688f;
    }

    @Override
    public Hitbox getGoodCutBounds() {
        if (this.getData().getCutDirection() == CutDirection.DOT) {
            return DOT_GOOD_CUT_BOUNDS;
        }
        return NORMAL_GOOD_CUT_BOUNDS;
    }

    @Override
    public Hitbox getBadCutBounds() {
        return BAD_CUT_BOUNDS;
    }

    @Override
    public Hitbox getAccurateHitbox() {
        return ACCURATE_HITBOX;
    }

    @Override
    public ColorNote getData() {
        return (ColorNote)super.getData();
    }

    @Override
    public ScorableObject score$getData() {
        return this.getData();
    }

    @Override
    public void score$setContactColor(NoteType type) {
        this.setContactColor(type);
    }

    @Override
    public void score$setCutResult(GameLogicHandler.CutResult cut) {
        this.setCutResult(cut);
    }

    @Override
    public void score$cutNote() {
        this.cutNote();
    }

    @Override
    public GameLogicHandler.CutResult score$getCutResult() {
        return this.getCutResult();
    }

    @Override
    public int score$getMaxCutPositionScore() {
        return 15;
    }

    @Override
    public int score$getMaxFollowThroughScore() {
        return 30;
    }

    @Override
    public int score$getMaxFollowThroughAngle() {
        return 60;
    }

    @Override
    public int score$getMaxSwingInScore() {
        return 70;
    }

    @Override
    public int score$getMaxSwingInAngle() {
        return 100;
    }

    @Override
    public Quaternionf score$getLaneRotation() {
        return this.getLaneRotation();
    }

    @Override
    public QuadMesh getMesh() {
        return MeshLoader.COLOR_NOTE_MESH;
    }
}

