/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.render.particle;

import com.beatcraft.data.types.Color;
import com.beatcraft.render.particle.BeatcraftParticleRenderer;
import com.beatcraft.render.particle.Particle;
import com.beatcraft.utils.MathUtil;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class SparkParticle
implements Particle {
    public Vector3f position;
    public Vector3f velocity;
    public int color;
    public float size;
    public float lifetime;
    public double spawnTime;
    public float decay;

    public SparkParticle(Vector3f position, Vector3f velocity, int color, float size, float lifetime, float decay) {
        this.position = position;
        this.velocity = velocity;
        this.color = color;
        this.size = size;
        this.lifetime = lifetime;
        this.spawnTime = (double)System.nanoTime() / 1.0E9;
        this.decay = decay;
    }

    @Override
    public void update(float deltaTime, class_287 buffer, Vector3f cameraPos) {
        Vector3f normal = new Vector3f((Vector3fc)this.position).sub((Vector3fc)cameraPos).normalize();
        List<Vector3f[]> vertices = MathUtil.fillMesh(MathUtil.generateCircle(normal, this.size / 2.0f, 3, this.position.sub((Vector3fc)cameraPos, new Vector3f()), 270.0f, 0.0f));
        this.position.add((Vector3fc)this.velocity);
        this.velocity.mul(this.decay);
        this.velocity.y -= 2.0E-6f;
        this.velocity = BeatcraftParticleRenderer.applyVariance(this.velocity, 0.1f, 0.01f);
        float delta = (float)MathUtil.inverseLerp(this.spawnTime, this.spawnTime + (double)this.lifetime, (double)System.nanoTime() / 1.0E9);
        if (delta >= 1.0f) {
            return;
        }
        int col = MathUtil.lerpColor(new Color(this.color), new Color(0x1FFFFFF), delta).toARGB();
        for (Vector3f[] vert : vertices) {
            buffer.method_22912(vert[0].x, vert[0].y, vert[0].z).method_39415(col);
            buffer.method_22912(vert[1].x, vert[1].y, vert[1].z).method_39415(col);
            buffer.method_22912(vert[2].x, vert[2].y, vert[2].z).method_39415(col);
        }
    }

    @Override
    public boolean shouldRemove() {
        return this.spawnTime + (double)this.lifetime < (double)System.nanoTime() / 1.0E9;
    }
}

