/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.replay;

import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public record PlayFrame(float beat, Vector3f leftSaberPosition, Quaternionf leftSaberRotation, Vector3f rightSaberPosition, Quaternionf rightSaberRotation, Vector3f headPos, Quaternionf headRotation) {
    public void write(ByteBuffer buf) {
        buf.putFloat(this.beat);
        PlayFrame.putVector3f(buf, this.leftSaberPosition);
        PlayFrame.putQuaternionf(buf, this.leftSaberRotation);
        PlayFrame.putVector3f(buf, this.rightSaberPosition);
        PlayFrame.putQuaternionf(buf, this.rightSaberRotation);
        PlayFrame.putVector3f(buf, this.headPos);
        PlayFrame.putQuaternionf(buf, this.headRotation);
    }

    private static void putVector3f(ByteBuffer buf, Vector3f vec) {
        buf.putFloat(vec.x);
        buf.putFloat(vec.y);
        buf.putFloat(vec.z);
    }

    private static void putQuaternionf(ByteBuffer buf, Quaternionf quat) {
        buf.putFloat(quat.x);
        buf.putFloat(quat.y);
        buf.putFloat(quat.z);
        buf.putFloat(quat.w);
    }

    public static PlayFrame load(ByteBuffer buf) {
        float b = buf.getFloat();
        Vector3f lp = new Vector3f(buf.getFloat(), buf.getFloat(), buf.getFloat());
        Quaternionf lr = new Quaternionf(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
        Vector3f rp = new Vector3f(buf.getFloat(), buf.getFloat(), buf.getFloat());
        Quaternionf rr = new Quaternionf(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
        Vector3f hp = new Vector3f(buf.getFloat(), buf.getFloat(), buf.getFloat());
        Quaternionf hr = new Quaternionf(buf.getFloat(), buf.getFloat(), buf.getFloat(), buf.getFloat());
        return new PlayFrame(b, lp, lr, rp, rr, hp, hr);
    }
}

