/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.replay;

import com.beatcraft.BeatmapPlayer;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.replay.PlayFrame;
import com.beatcraft.replay.ReplayHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class PlayRecorder {
    public static String outputFile;
    public static String songID;
    public static String difficultySet;
    public static String difficulty;
    private static final ArrayList<PlayFrame> frames;

    public static void update(float beat) {
        if (outputFile != null && BeatmapPlayer.isPlaying()) {
            frames.add(new PlayFrame(beat, new Vector3f((Vector3fc)GameLogicHandler.leftSaberPos), new Quaternionf((Quaternionfc)GameLogicHandler.leftSaberRotation), new Vector3f((Vector3fc)GameLogicHandler.rightSaberPos), new Quaternionf((Quaternionfc)GameLogicHandler.rightSaberRotation), new Vector3f((Vector3fc)GameLogicHandler.headPos), new Quaternionf((Quaternionfc)GameLogicHandler.headRot)));
        }
    }

    public static void seek(float beat) {
        frames.removeIf(frame -> frame.beat() >= beat);
    }

    public static void save() throws IOException {
        if (outputFile == null) {
            return;
        }
        String path = class_310.method_1551().field_1697.getAbsolutePath() + "/beatcraft/replay/" + outputFile;
        byte[] idBytes = songID.getBytes(StandardCharsets.UTF_8);
        byte[] setBytes = difficultySet.getBytes(StandardCharsets.UTF_8);
        byte[] diffBytes = difficulty.getBytes(StandardCharsets.UTF_8);
        int sizeID = idBytes.length;
        int sizeSet = setBytes.length;
        int sizeDiff = diffBytes.length;
        ByteBuffer outputFrames = ByteBuffer.allocate(sizeID + sizeSet + sizeDiff + 88 * frames.size() + 20);
        outputFrames.putInt(1);
        outputFrames.putInt(sizeID);
        outputFrames.put(idBytes);
        outputFrames.putInt(sizeSet);
        outputFrames.put(setBytes);
        outputFrames.putInt(sizeDiff);
        outputFrames.put(diffBytes);
        outputFrames.putInt(frames.size());
        frames.forEach(frame -> frame.write(outputFrames));
        Files.write(Path.of(path, new String[0]), outputFrames.array(), new OpenOption[0]);
        ReplayHandler.loadReplays();
    }

    public static void reset() {
        frames.clear();
        outputFile = null;
        songID = null;
        difficultySet = null;
        difficulty = null;
    }

    static {
        frames = new ArrayList();
    }
}

