/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.replay;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatCraftClient;
import com.beatcraft.data.menu.SongData;
import com.beatcraft.data.menu.SongDownloader;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.replay.PlayRecorder;
import com.beatcraft.replay.ReplayInfo;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ReplayHandler {
    public static final int VERSION = 1;
    private static boolean recordPlayback = false;
    private static final ArrayList<ReplayInfo> replayData = new ArrayList();

    public static int getReplayCount() {
        return replayData.size();
    }

    public static List<ReplayInfo> getReplays(int startIndex, int length) {
        ArrayList<ReplayInfo> out = new ArrayList<ReplayInfo>();
        for (int i = startIndex; i < startIndex + length - 1; ++i) {
            if (i >= replayData.size()) continue;
            out.add(replayData.get(i));
        }
        return out;
    }

    public static void loadReplays() {
        ReplayHandler.loadReplays(true);
    }

    public static void loadReplays(boolean updateReplayScreen) {
        String replayFolder = String.valueOf(class_310.method_1551().field_1697.toPath()) + "/beatcraft/replay/";
        File folder = new File(replayFolder);
        if (!folder.exists() && !folder.mkdirs()) {
            BeatCraft.LOGGER.error("Failed to create replay folder");
            return;
        }
        File[] replayFiles = folder.listFiles(File::isFile);
        if (replayFiles == null) {
            BeatCraft.LOGGER.error("Failed to load replays");
            return;
        }
        replayData.clear();
        for (File replay : replayFiles) {
            ReplayInfo info;
            BeatCraft.LOGGER.info("Found potential replay file: '{}'", (Object)replay.getAbsolutePath());
            String fullPath = replay.getAbsolutePath();
            if (!fullPath.endsWith(".replay") || (info = ReplayHandler.loadReplay(fullPath)) == null) continue;
            replayData.add(info);
        }
        if (updateReplayScreen) {
            HUDRenderer.modifierMenuPanel.setupReplayPage();
        }
    }

    public static void recordNextMap() {
        recordPlayback = true;
        HUDRenderer.modifierMenuPanel.setReplayToggleState(true);
    }

    public static void cancelRecording() {
        recordPlayback = false;
        PlayRecorder.outputFile = null;
        HUDRenderer.modifierMenuPanel.setReplayToggleState(false);
    }

    public static boolean isRecording() {
        return recordPlayback;
    }

    private static String getCurrentTimestamp() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
        return LocalDateTime.now().format(formatter);
    }

    public static void setup(String mapID, String set, String diff) {
        if (mapID == null) {
            BeatCraft.LOGGER.warn("Map has no ID and therefore won't be able to be played back properly, so recording is canceled");
            return;
        }
        PlayRecorder.outputFile = String.format("beatcraft-%s-%s-%s-%s.replay", mapID, SongDownloader.filterString(set), SongDownloader.filterString(diff), ReplayHandler.getCurrentTimestamp());
        PlayRecorder.songID = mapID;
        PlayRecorder.difficultySet = set;
        PlayRecorder.difficulty = diff;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static ReplayInfo loadReplay(String path) {
        try (RandomAccessFile file = new RandomAccessFile(path, "r");){
            ReplayInfo replayInfo;
            block17: {
                FileChannel channel;
                block15: {
                    ReplayInfo replayInfo2;
                    block16: {
                        channel = file.getChannel();
                        try {
                            ByteBuffer buffer = ByteBuffer.allocate(512);
                            channel.read(buffer);
                            buffer.flip();
                            int replayVersion = buffer.getInt();
                            if (replayVersion != 1) break block15;
                            replayInfo2 = ReplayHandler.loadV1(buffer, path);
                            if (channel == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        channel.close();
                    }
                    return replayInfo2;
                }
                replayInfo = null;
                if (channel == null) break block17;
                channel.close();
            }
            return replayInfo;
        }
        catch (Exception e) {
            BeatCraft.LOGGER.error("Error loading replay file '{}'", (Object)path, (Object)e);
            return null;
        }
    }

    private static ReplayInfo loadV1(ByteBuffer buffer, String path) {
        int idSize = buffer.getInt();
        byte[] idBytes = new byte[idSize];
        buffer.get(idBytes);
        String mapID = new String(idBytes, StandardCharsets.UTF_8);
        int setSize = buffer.getInt();
        byte[] setBytes = new byte[setSize];
        buffer.get(setBytes);
        String set = new String(setBytes, StandardCharsets.UTF_8);
        int diffSize = buffer.getInt();
        byte[] diffBytes = new byte[diffSize];
        buffer.get(diffBytes);
        String diff = new String(diffBytes, StandardCharsets.UTF_8);
        String name = ReplayHandler.lookup(mapID);
        BeatCraft.LOGGER.info("Loaded replay: {}, {}, {}, {}", new Object[]{mapID, name, set, diff});
        return new ReplayInfo(mapID, name == null ? "MAP NOT FOUND" : name, set, diff, path, name != null);
    }

    private static String lookup(String id) {
        SongData song = BeatCraftClient.songs.getById(id);
        if (song == null) {
            return null;
        }
        return String.format("%s | %s", song.getTitle(), song.getMappers());
    }

    public static void delete(ReplayInfo info) {
        try {
            Files.deleteIfExists(Path.of(info.replayFilePath(), new String[0]));
            ReplayHandler.loadReplays(false);
        }
        catch (IOException e) {
            BeatCraft.LOGGER.error("Failed to delete replay file!", (Throwable)e);
        }
    }
}

