/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.replay;

import com.beatcraft.BeatCraft;
import com.beatcraft.BeatCraftClient;
import com.beatcraft.data.components.ModComponents;
import com.beatcraft.data.menu.SongData;
import com.beatcraft.items.ModItems;
import com.beatcraft.logic.GameLogicHandler;
import com.beatcraft.networking.c2s.BeatSyncC2SPayload;
import com.beatcraft.networking.c2s.SaberSyncC2SPayload;
import com.beatcraft.render.HUDRenderer;
import com.beatcraft.render.effect.SaberRenderer;
import com.beatcraft.replay.PlayFrame;
import com.beatcraft.replay.ReplayHandler;
import com.beatcraft.utils.MathUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_8623;
import net.minecraft.class_8710;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class Replayer {
    private static final ArrayList<PlayFrame> frames = new ArrayList();
    private static final class_8623<PlayFrame> upcoming = new class_8623();
    private static PlayFrame current = new PlayFrame(0.0f, new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf());
    public static boolean runReplay = false;
    private static final class_1799 leftSaber = new class_1799((class_1935)ModItems.SABER_ITEM, 1);
    private static final class_1799 rightSaber = new class_1799((class_1935)ModItems.SABER_ITEM, 1);

    public static void loadReplay(String replayFile) throws IOException {
        frames.clear();
        leftSaber.method_57379(ModComponents.AUTO_SYNC_COLOR, (Object)0);
        leftSaber.method_57379(ModComponents.SABER_COLOR_COMPONENT, (Object)0xC03030);
        rightSaber.method_57379(ModComponents.AUTO_SYNC_COLOR, (Object)1);
        rightSaber.method_57379(ModComponents.SABER_COLOR_COMPONENT, (Object)2122920);
        byte[] rawData = Files.readAllBytes(Path.of(replayFile, new String[0]));
        ByteBuffer buf = ByteBuffer.wrap(rawData);
        int replayVersion = buf.getInt();
        if (replayVersion == 1) {
            Replayer.loadV1(buf);
        }
    }

    private static void loadV1(ByteBuffer buf) {
        int idSize = buf.getInt();
        byte[] idBytes = new byte[idSize];
        buf.get(idBytes, 0, idSize);
        String id = new String(idBytes, StandardCharsets.UTF_8);
        int setSize = buf.getInt();
        byte[] setBytes = new byte[setSize];
        buf.get(setBytes, 0, setSize);
        String set = new String(setBytes, StandardCharsets.UTF_8);
        int diffSize = buf.getInt();
        byte[] diffBytes = new byte[diffSize];
        buf.get(diffBytes, 0, diffSize);
        String diff = new String(diffBytes, StandardCharsets.UTF_8);
        int frameCount = buf.getInt();
        frames.add(new PlayFrame(0.0f, new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf(), new Vector3f(), new Quaternionf()));
        for (int i = 0; i < frameCount; ++i) {
            frames.add(PlayFrame.load(buf));
        }
        upcoming.addAll(frames);
        current = (PlayFrame)upcoming.pollFirst();
        SongData data = BeatCraftClient.songs.getById(id);
        runReplay = true;
        SongData.BeatmapInfo info = data.getBeatMapInfo(set, diff);
        if (info == null) {
            BeatCraft.LOGGER.info("Failed to load {}:{} from song: {}", new Object[]{set, diff, data});
            return;
        }
        ReplayHandler.cancelRecording();
        HUDRenderer.songSelectMenuPanel.tryPlayMap(data, info, set, diff);
    }

    public static void reset() {
        frames.clear();
        upcoming.clear();
        runReplay = false;
    }

    public static void update(float beat) {
        PlayFrame next;
        block4: {
            if (!runReplay || beat < 0.0f) {
                return;
            }
            if (frames.isEmpty() || upcoming.isEmpty()) {
                return;
            }
            do {
                if ((next = (PlayFrame)upcoming.peekFirst()) == null) {
                    return;
                }
                if (!(next.beat() < beat)) break block4;
            } while ((current = (PlayFrame)upcoming.pollFirst()) != null);
            return;
        }
        float sb = current.beat();
        float eb = next.beat();
        float f = MathUtil.inverseLerp(sb, eb, beat);
        Vector3f leftSaberPos = MathUtil.lerpVector3(current.leftSaberPosition(), next.leftSaberPosition(), f);
        Vector3f rightSaberPos = MathUtil.lerpVector3(current.rightSaberPosition(), next.rightSaberPosition(), f);
        Vector3f headPos = MathUtil.lerpVector3(current.headPos(), next.headPos(), f);
        Quaternionf leftSaberRot = MathUtil.lerpQuaternion(current.leftSaberRotation(), next.leftSaberRotation(), f);
        Quaternionf rightSaberRot = MathUtil.lerpQuaternion(current.rightSaberRotation(), next.rightSaberRotation(), f);
        Quaternionf headRot = MathUtil.lerpQuaternion(current.headRotation(), next.headRotation(), f);
        GameLogicHandler.updateRightSaber(rightSaberPos, rightSaberRot);
        GameLogicHandler.updateLeftSaber(leftSaberPos, leftSaberRot);
        GameLogicHandler.headPos = headPos;
        GameLogicHandler.headRot = headRot;
        SaberRenderer.renderReplaySaber(leftSaber, leftSaberPos, leftSaberRot);
        SaberRenderer.renderReplaySaber(rightSaber, rightSaberPos, rightSaberRot);
        ClientPlayNetworking.send((class_8710)new SaberSyncC2SPayload(leftSaberPos, leftSaberRot, rightSaberPos, rightSaberRot, headPos, headRot));
        ClientPlayNetworking.send((class_8710)new BeatSyncC2SPayload(beat));
    }

    public static void seek(float beat) {
        upcoming.clear();
        upcoming.addAll(frames);
    }
}

