/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.screen;

import com.beatcraft.BeatCraftClient;
import com.beatcraft.audio.BeatmapAudioPlayer;
import com.beatcraft.data.types.Stash;
import com.beatcraft.render.DebugRenderer;
import com.beatcraft.screen.ContributorsScreen;
import com.beatcraft.screen.SongDownloaderScreen;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.SliderComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class SettingsScreen
extends BaseOwoScreen<FlowLayout> {
    private Page page = Page.GENERAL;
    private final class_437 parent;
    private FlowLayout settingPage;

    public SettingsScreen(class_437 parent) {
        this.parent = parent;
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::horizontalFlow);
    }

    protected void build(FlowLayout flowLayout) {
        int BUTTON_WIDTH = 75;
        flowLayout.surface(Surface.VANILLA_TRANSLUCENT);
        this.settingPage = Containers.verticalFlow((Sizing)Sizing.fill((int)75), (Sizing)Sizing.fill());
        this.setPage();
        flowLayout.child((Component)Components.spacer((int)15)).child((Component)Containers.verticalFlow((Sizing)Sizing.fill((int)20), (Sizing)Sizing.fill((int)95)).child((Component)Components.spacer((int)15)).child(Components.button((class_2561)class_2561.method_43471((String)"gui.beatcraft.button.general_settings"), this::gotoGeneralPage).sizing(Sizing.fixed((int)BUTTON_WIDTH), Sizing.content())).child((Component)Components.spacer((int)2)).child(Components.button((class_2561)class_2561.method_43471((String)"gui.beatcraft.button.quality_settings"), this::gotoQualityPage).sizing(Sizing.fixed((int)BUTTON_WIDTH), Sizing.content())).child((Component)Components.spacer((int)2)).child(Components.button((class_2561)class_2561.method_43471((String)"gui.beatcraft.button.audio_settings"), this::gotoAudioPage).sizing(Sizing.fixed((int)BUTTON_WIDTH), Sizing.content())).child((Component)Components.spacer((int)2)).child(Components.button((class_2561)class_2561.method_43471((String)"gui.beatcraft.button.debug_settings"), this::gotoDebugPage).sizing(Sizing.fixed((int)BUTTON_WIDTH), Sizing.content())).child((Component)Components.spacer((int)2)).child(Components.button((class_2561)class_2561.method_43471((String)"screen.beatcraft.song_downloader"), this::gotoSongDownloader).sizing(Sizing.fixed((int)BUTTON_WIDTH), Sizing.content())).child((Component)Components.spacer((int)2)).child(Components.button((class_2561)class_2561.method_43471((String)"screen.beatcraft.credits"), this::openCredits).sizing(Sizing.fixed((int)BUTTON_WIDTH), Sizing.content())).child((Component)Components.spacer((int)2)).child(Components.button((class_2561)class_2561.method_43471((String)"screen.beatcraft.close"), b -> this.method_25419()).sizing(Sizing.fixed((int)BUTTON_WIDTH), Sizing.content()))).child((Component)this.settingPage);
    }

    private void setPage() {
        this.settingPage.clearChildren();
        switch (this.page.ordinal()) {
            case 0: {
                this.setGeneralPage();
                break;
            }
            case 1: {
                this.setQualityPage();
                break;
            }
            case 2: {
                this.setAudioPage();
                break;
            }
            case 3: {
                this.setDebugPage();
            }
        }
    }

    private void setGeneralPage() {
        SliderComponent trailIntensitySlider = Components.discreteSlider((Sizing)Sizing.fill((int)50), (double)1.0, (double)20.0).value((double)((float)(Stash.getTrailSize() - 10) / 190.0f)).message(str -> class_2561.method_30163((String)(str + "0")));
        trailIntensitySlider.onChanged().subscribe(this::updateTrailIntensity);
        CheckboxComponent reducedDebrisToggle = Components.checkbox((class_2561)class_2561.method_43471((String)"setting.beatcraft.player_option.reduced_debris"));
        reducedDebrisToggle.checked(BeatCraftClient.playerConfig.isReducedDebris());
        reducedDebrisToggle.onChanged(BeatCraftClient.playerConfig::setReducedDebris);
        CheckboxComponent sparkParticlesToggle = Components.checkbox((class_2561)class_2561.method_43471((String)"setting.beatcraft.quality.particles"));
        sparkParticlesToggle.checked(BeatCraftClient.playerConfig.doSparkParticles());
        sparkParticlesToggle.onChanged(BeatCraftClient.playerConfig::setSparkParticles);
        this.settingPage.child((Component)Components.spacer((int)10)).child((Component)Containers.grid((Sizing)Sizing.fill((int)90), (Sizing)Sizing.content(), (int)1, (int)2).child((Component)Components.label((class_2561)class_2561.method_43471((String)"setting.beatcraft.quality.trail_intensity")).lineHeight(15), 0, 0).child((Component)trailIntensitySlider, 0, 1)).child((Component)Components.spacer((int)10)).child((Component)Containers.grid((Sizing)Sizing.fill((int)90), (Sizing)Sizing.content(), (int)1, (int)2).child((Component)reducedDebrisToggle, 0, 0).child((Component)sparkParticlesToggle, 0, 1));
    }

    private void setQualityPage() {
        CheckboxComponent bloomfogToggle = Components.checkbox((class_2561)class_2561.method_43471((String)"setting.beatcraft.quality.bloomfog"));
        bloomfogToggle.checked(BeatCraftClient.playerConfig.doBloomfog());
        bloomfogToggle.onChanged(BeatCraftClient.playerConfig::setBloomfogEnabled);
        CheckboxComponent bloomToggle = Components.checkbox((class_2561)class_2561.method_43471((String)"setting.beatcraft.quality.bloom"));
        bloomToggle.checked(BeatCraftClient.playerConfig.doBloom());
        bloomToggle.onChanged(BeatCraftClient.playerConfig::setBloomEnabled);
        CheckboxComponent mirrorToggle = Components.checkbox((class_2561)class_2561.method_43471((String)"setting.beatcraft.quality.mirror"));
        mirrorToggle.checked(BeatCraftClient.playerConfig.doMirror());
        mirrorToggle.onChanged(BeatCraftClient.playerConfig::setMirrorEnabled);
        CheckboxComponent skyFogToggle = Components.checkbox((class_2561)class_2561.method_43471((String)"setting.beatcraft.quality.sky_fog"));
        skyFogToggle.checked(BeatCraftClient.playerConfig.doSkyFog());
        skyFogToggle.onChanged(BeatCraftClient.playerConfig::setSkyFogEnabled);
        this.settingPage.child((Component)Components.spacer((int)10)).child((Component)Containers.grid((Sizing)Sizing.fill((int)90), (Sizing)Sizing.content(), (int)2, (int)2).child((Component)bloomfogToggle, 0, 0).child((Component)bloomToggle, 0, 1).child((Component)mirrorToggle, 1, 0).child((Component)skyFogToggle, 1, 1));
    }

    private void setAudioPage() {
        SliderComponent slider = Components.discreteSlider((Sizing)Sizing.fill((int)50), (double)0.0, (double)100.0).value((double)BeatCraftClient.playerConfig.getVolume()).message(str -> class_2561.method_30163((String)(str + "%")));
        slider.onChanged().subscribe(this::updateVolume);
        this.settingPage.child((Component)Components.spacer((int)10)).child((Component)Containers.grid((Sizing)Sizing.fill((int)90), (Sizing)Sizing.content(), (int)1, (int)2).child((Component)Components.label((class_2561)class_2561.method_43471((String)"setting.beatcraft.audio.volume")).lineHeight(15), 0, 0).child((Component)slider, 0, 1));
    }

    private void setDebugPage() {
        this.settingPage.child((Component)Components.spacer((int)10)).child((Component)this.toggleOption("setting.beatcraft.debug.main_renderer", DebugRenderer.doDebugRendering, this::toggleMainDebugRenderer)).child((Component)Components.spacer((int)2)).child((Component)this.toggleOption("setting.beatcraft.debug.saber_renderer", DebugRenderer.debugSaberRendering, this::toggleSaberDebugRenderer)).child((Component)Components.spacer((int)2)).child((Component)this.toggleOption("setting.beatcraft.debug.hitboxes", DebugRenderer.renderHitboxes, this::toggleHitboxRenderer)).child((Component)Components.spacer((int)2)).child((Component)this.toggleOption("setting.beatcraft.debug.arc_lines", DebugRenderer.renderArcDebugLines, this::toggleArcLineRenderer)).child((Component)Components.spacer((int)2)).child((Component)this.toggleOption("setting.beatcraft.debug.lightshow_events", BeatCraftClient.playerConfig.doLightshowEventRendering(), this::toggleLightshowEventRendering));
    }

    private GridLayout toggleOption(String translatable, boolean state, Consumer<ButtonComponent> onClick) {
        return Containers.grid((Sizing)Sizing.fill(), (Sizing)Sizing.content(), (int)1, (int)2).child((Component)Components.label((class_2561)class_2561.method_43471((String)translatable)).lineHeight(15), 0, 0).child(Components.button((class_2561)this.getToggleText(state), onClick).sizing(Sizing.fixed((int)30), Sizing.content()), 0, 1);
    }

    private void gotoGeneralPage(ButtonComponent button) {
        this.page = Page.GENERAL;
        this.setPage();
    }

    private void gotoQualityPage(ButtonComponent button) {
        this.page = Page.QUALITY;
        this.setPage();
    }

    private void gotoAudioPage(ButtonComponent button) {
        this.page = Page.AUDIO;
        this.setPage();
    }

    private void gotoDebugPage(ButtonComponent button) {
        this.page = Page.DEBUG;
        this.setPage();
    }

    private void gotoSongDownloader(ButtonComponent button) {
        SongDownloaderScreen screen = new SongDownloaderScreen((class_437)this);
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)screen);
    }

    private void updateTrailIntensity(double value) {
        int size = (int)(value * 10.0);
        Stash.updateTrailSize(size);
    }

    private void updateVolume(double value) {
        BeatCraftClient.playerConfig.setVolume((float)value / 100.0f);
        BeatmapAudioPlayer.beatmapAudio.setVolume((float)value / 100.0f);
    }

    private void toggleMainDebugRenderer(ButtonComponent button) {
        DebugRenderer.doDebugRendering = !DebugRenderer.doDebugRendering;
        button.method_25355(this.getToggleText(DebugRenderer.doDebugRendering));
    }

    private void toggleSaberDebugRenderer(ButtonComponent button) {
        DebugRenderer.debugSaberRendering = !DebugRenderer.debugSaberRendering;
        button.method_25355(this.getToggleText(DebugRenderer.debugSaberRendering));
    }

    private void toggleHitboxRenderer(ButtonComponent button) {
        DebugRenderer.renderHitboxes = !DebugRenderer.renderHitboxes;
        button.method_25355(this.getToggleText(DebugRenderer.renderHitboxes));
    }

    private void toggleArcLineRenderer(ButtonComponent button) {
        DebugRenderer.renderArcDebugLines = !DebugRenderer.renderArcDebugLines;
        button.method_25355(this.getToggleText(DebugRenderer.renderArcDebugLines));
    }

    private void toggleLightshowEventRendering(ButtonComponent button) {
        BeatCraftClient.playerConfig.setLightshowEventRendering(!BeatCraftClient.playerConfig.doLightshowEventRendering());
        button.method_25355(this.getToggleText(BeatCraftClient.playerConfig.doLightshowEventRendering()));
    }

    private class_2561 getToggleText(boolean state) {
        if (state) {
            return class_2561.method_43471((String)"gui.beatcraft.option.on");
        }
        return class_2561.method_43471((String)"gui.beatcraft.option.off");
    }

    private void openCredits(ButtonComponent button) {
        ContributorsScreen screen = new ContributorsScreen((class_437)this);
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)screen);
    }

    public void method_25419() {
        BeatCraftClient.playerConfig.writeToFile();
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    @Environment(value=EnvType.CLIENT)
    private static enum Page {
        GENERAL,
        QUALITY,
        AUDIO,
        DEBUG;

    }
}

