/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.utils;

import com.beatcraft.utils.MathUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class JsonUtil {
    public static Vector3f getVector3(JsonElement element) {
        JsonArray array = element.getAsJsonArray();
        return JsonUtil.getVector3(array);
    }

    public static Vector3f getVector3(JsonArray array) {
        float x = JsonUtil.getOrDefault(array, 0, JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        float y = JsonUtil.getOrDefault(array, 1, JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        float z = JsonUtil.getOrDefault(array, 2, JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        return new Vector3f(x, y, z);
    }

    public static Vector4f getVector4(JsonElement element) {
        JsonArray array = element.getAsJsonArray();
        return JsonUtil.getVector4(array);
    }

    public static Vector4f getVector4(JsonArray array) {
        float x = JsonUtil.getOrDefault(array, 0, JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        float y = JsonUtil.getOrDefault(array, 1, JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        float z = JsonUtil.getOrDefault(array, 2, JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        float w = JsonUtil.getOrDefault(array, 3, JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        return new Vector4f(x, y, z, w);
    }

    public static <T> T getOrDefault(JsonObject json, String key, Function<JsonElement, T> getter, T fallback) {
        if (json.has(key)) {
            return getter.apply(json.get(key));
        }
        return fallback;
    }

    public static <T> T getOrDefault(JsonArray array, int index, Function<JsonElement, T> getter, T fallback) {
        if (array.size() > index) {
            return getter.apply(array.get(index));
        }
        return fallback;
    }

    public static Quaternionf getQuaternion(JsonElement element) {
        Vector3f euler = JsonUtil.getVector3(element);
        return MathUtil.eulerToQuaternion(euler);
    }

    public static Quaternionf getQuaternion(JsonArray array) {
        Vector3f euler = JsonUtil.getVector3(array);
        return MathUtil.eulerToQuaternion(euler);
    }

    public static Quaternionf getQuaternion(JsonObject object, String property, Quaternionf defaultValue) {
        if (object.has(property)) {
            return JsonUtil.getQuaternion(object.get(property));
        }
        return defaultValue;
    }
}

