/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.utils;

import com.beatcraft.beatmap.data.CutDirection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class NoteMath {
    public static Jumps getJumps(float njs, float offset, float bpm) {
        float hjd = 4.0f;
        float num = 60.0f / bpm;
        while (njs * num * hjd > 17.999f) {
            hjd /= 2.0f;
        }
        if ((hjd += offset) < 0.25f) {
            hjd = 0.25f;
        }
        float jd = hjd * num * njs * 2.0f;
        return new Jumps(hjd, jd);
    }

    public static float degreesFromCut(CutDirection cutDirection) {
        return switch (cutDirection) {
            default -> throw new MatchException(null, null);
            case CutDirection.UP -> 180.0f;
            case CutDirection.DOWN, CutDirection.DOT -> 0.0f;
            case CutDirection.LEFT -> -90.0f;
            case CutDirection.RIGHT -> 90.0f;
            case CutDirection.UP_LEFT -> -135.0f;
            case CutDirection.UP_RIGHT -> 135.0f;
            case CutDirection.DOWN_LEFT -> -45.0f;
            case CutDirection.DOWN_RIGHT -> 45.0f;
        };
    }

    @Environment(value=EnvType.CLIENT)
    public record Jumps(float halfDuration, float jumpDistance) {
    }
}

