/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.event;

import com.beatcraft.client.animation.event.AnimatedPathEvent;
import com.beatcraft.client.animation.event.InterpolatedPath;
import com.beatcraft.client.animation.event.Path;
import com.beatcraft.client.animation.event.StaticPath;
import com.beatcraft.client.animation.pointdefinition.PointDefinition;
import com.beatcraft.common.event.EventHandler;
import java.util.ArrayList;

public class AnimatedPathEventHandler<T>
extends EventHandler<Path<T>, AnimatedPathEvent<T>> {
    private PointDefinition<T> previousProperty = null;

    public AnimatedPathEventHandler(ArrayList<AnimatedPathEvent<T>> events, Path<T> initialState) {
        super(events, initialState);
    }

    @Override
    public void reset() {
        super.reset();
        this.previousProperty = null;
    }

    @Override
    public void onEventInterrupted(AnimatedPathEvent<T> event, float normalTime) {
        this.previousProperty = event.getProperty();
    }

    @Override
    public void onInsideEvent(AnimatedPathEvent<T> event, float normalTime) {
        if (this.previousProperty != null) {
            normalTime = event.applyEasing(normalTime);
            this.state = new InterpolatedPath<T>(this.previousProperty, event.getProperty(), normalTime);
        } else {
            this.state = new StaticPath<T>(event.getProperty());
        }
    }

    @Override
    public void onEventPassed(AnimatedPathEvent<T> event) {
        this.state = new StaticPath<T>(event.getProperty());
        this.previousProperty = event.getProperty();
    }
}

