/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.animation.pointdefinition;

import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.animation.event.AnimatedPathEvent;
import com.beatcraft.client.animation.event.AnimatedPropertyEvent;
import com.beatcraft.client.animation.pointdefinition.Point;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.event.AnimateTrack;
import com.beatcraft.client.beatmap.data.event.AssignPathAnimation;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import net.minecraft.class_3518;

public abstract class PointDefinition<T> {
    protected ArrayList<Point<T>> points = new ArrayList();
    protected BeatmapController map;

    protected abstract T interpolatePoints(int var1, int var2, float var3);

    public static boolean isModifier(JsonElement json) {
        if (!json.isJsonArray() && json.isJsonPrimitive()) {
            JsonPrimitive p = json.getAsJsonPrimitive();
            return p.isString();
        }
        for (JsonElement v : json.getAsJsonArray()) {
            if (v.isJsonPrimitive() && v.getAsJsonPrimitive().isString()) {
                String s = v.getAsString();
                if (!s.startsWith("base") && !s.startsWith("op")) continue;
                return true;
            }
            if (!v.isJsonArray()) continue;
            for (JsonElement x : v.getAsJsonArray()) {
                if (!x.isJsonPrimitive() || !x.getAsJsonPrimitive().isString()) continue;
                String s = x.getAsString();
                if (s.startsWith("base") || s.startsWith("op")) {
                    return true;
                }
                if (!s.startsWith("ease")) continue;
                return false;
            }
        }
        return false;
    }

    public static boolean isSimple(JsonArray json) {
        if (json.get(0).isJsonArray()) {
            return false;
        }
        return !json.get(0).isJsonPrimitive() || !json.get(0).getAsJsonPrimitive().isString();
    }

    protected abstract int getValueLength(JsonArray var1);

    public int getTimeIndex(JsonArray inner) {
        return this.getValueLength(inner);
    }

    public boolean hasFlags(JsonArray json) {
        return json.size() > this.getTimeIndex(json) + 1;
    }

    public Integer getFlagIndex(JsonArray json, String flag) {
        if (!this.hasFlags(json)) {
            return null;
        }
        for (int i = this.getTimeIndex(json) + 1; i < json.size(); ++i) {
            JsonElement element = json.get(i);
            if (!class_3518.method_15286((JsonElement)element) || !element.getAsString().contains(flag)) continue;
            return i;
        }
        return null;
    }

    public Integer getEasingIndex(JsonArray json) {
        return this.getFlagIndex(json, "ease");
    }

    public Integer getSplineIndex(JsonArray json) {
        return this.getFlagIndex(json, "spline");
    }

    public PointDefinition(BeatmapController map, JsonArray json) throws RuntimeException {
        this.map = map;
        if (PointDefinition.isSimple(json)) {
            this.loadSimple(json);
        } else {
            this.loadComplex(json);
        }
    }

    private void loadSimple(JsonArray json) {
        Point point = new Point();
        this.loadValue(json, point, true);
        this.points.add(point);
    }

    private void loadComplex(JsonArray json) {
        if (PointDefinition.isModifier((JsonElement)json)) {
            Point point = new Point();
            this.loadValue(json, point, false);
            this.points.add(point);
        } else {
            json.forEach(x -> {
                Integer splineIndex;
                JsonArray inner = x.getAsJsonArray();
                Point point = new Point();
                float time = inner.get(this.getTimeIndex(inner)).getAsFloat();
                point.setTime(time);
                Integer easingIndex = this.getEasingIndex(inner);
                if (easingIndex != null) {
                    String easing = inner.get(easingIndex.intValue()).getAsString();
                    point.setEasing(Easing.getEasing(easing));
                }
                point.setSpline((splineIndex = this.getSplineIndex(inner)) != null);
                this.loadValue(inner, point, false);
                this.points.add(point);
            });
        }
    }

    protected abstract void loadValue(JsonArray var1, Point<T> var2, boolean var3);

    public T interpolate(float time) {
        if (this.points.isEmpty()) {
            return null;
        }
        Point<T> lastPoint = this.points.getLast();
        if (lastPoint.getTime() <= time) {
            return lastPoint.getValue();
        }
        Point<T> firstPoint = this.points.getFirst();
        if (firstPoint.getTime() >= time) {
            return firstPoint.getValue();
        }
        TimeIndexInfo indexInfo = this.searchIndexAtTime(time);
        Point<T> leftPoint = this.points.get(indexInfo.left);
        Point<T> rightPoint = this.points.get(indexInfo.right);
        float normalTime = 0.0f;
        float divisor = rightPoint.getTime() - leftPoint.getTime();
        if (divisor != 0.0f) {
            normalTime = (time - leftPoint.getTime()) / divisor;
        }
        if (rightPoint.getEasing() != null) {
            normalTime = rightPoint.getEasing().apply(Float.valueOf(normalTime)).floatValue();
        }
        return this.interpolatePoints(indexInfo.left, indexInfo.right, normalTime);
    }

    private TimeIndexInfo searchIndexAtTime(float time) {
        int left = 0;
        int right = this.points.size();
        while (left < right - 1) {
            int middle = (left + right) / 2;
            float pointTime = this.points.get(middle).getTime();
            if (pointTime < time) {
                left = middle;
                continue;
            }
            right = middle;
        }
        return new TimeIndexInfo(left, right);
    }

    public AnimatedPropertyEvent<T> toAnimatedPropertyEvent(AnimateTrack animateTrack) {
        return new AnimatedPropertyEvent(this, animateTrack);
    }

    public AnimatedPathEvent<T> toAnimatedPathEvent(AssignPathAnimation assignPathAnimation) {
        return new AnimatedPathEvent(this, assignPathAnimation);
    }

    private record TimeIndexInfo(int left, int right) {
    }
}

