/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.audio;

import com.beatcraft.client.audio.Audio;
import com.beatcraft.client.audio.BpmRegion;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.lwjgl.openal.AL10;

public class AudioInfo {
    public final float duration;
    public final int frequency;
    private final ArrayList<BpmRegion> regions = new ArrayList();

    private AudioInfo(int sampleCount, int frequency) {
        this.duration = (float)sampleCount / (float)frequency;
        this.frequency = frequency;
    }

    public static AudioInfo loadDefault(float bpm, String audioFileName) {
        Audio audio = Audio.loadFromFile(audioFileName, Audio.Mode.FULL);
        int size = AL10.alGetBufferi((int)audio.buffer[0], (int)8196);
        int frequency = AL10.alGetBufferi((int)audio.buffer[0], (int)8193);
        int channels = AL10.alGetBufferi((int)audio.buffer[0], (int)8195);
        int bits = AL10.alGetBufferi((int)audio.buffer[0], (int)8194);
        int sampleCount = size / (channels * (bits / 8));
        AudioInfo info = new AudioInfo(sampleCount, frequency);
        BpmRegion inf = new BpmRegion(info, bpm);
        info.regions.add(inf);
        return info;
    }

    public static AudioInfo loadV2(JsonObject json) {
        int sampleCount = json.get("_songSampleCount").getAsInt();
        int frequency = json.get("_songFrequency").getAsInt();
        AudioInfo info = new AudioInfo(sampleCount, frequency);
        JsonArray regions = json.getAsJsonArray("_regions");
        regions.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            BpmRegion bpmRegion = BpmRegion.loadV2(obj, info);
            info.regions.add(bpmRegion);
        });
        return info;
    }

    public static AudioInfo loadV4(JsonObject json) {
        int sampleCount = json.get("songSampleCount").getAsInt();
        int frequency = json.get("songFrequency").getAsInt();
        AudioInfo info = new AudioInfo(sampleCount, frequency);
        JsonArray regions = json.getAsJsonArray("bpmData");
        regions.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            BpmRegion bpmRegion = BpmRegion.loadV4(obj, info);
            info.regions.add(bpmRegion);
        });
        return info;
    }

    public float getBpm(float beat) {
        for (BpmRegion region : this.regions) {
            if (!region.containsBeat(beat)) continue;
            return region.bpm;
        }
        return 60.0f;
    }

    public float getBeat(float time) {
        float beat = 0.0f;
        for (BpmRegion region : this.regions) {
            float b = region.getBeat(time);
            if (b == 0.0f) {
                return beat;
            }
            beat = b;
        }
        return beat;
    }

    public float getTime(float beat) {
        float t = 0.0f;
        for (BpmRegion region : this.regions) {
            t += region.getTime(beat);
        }
        return t;
    }
}

