/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.animation.base_providers.BaseProviderHandler;
import com.beatcraft.client.audio.Audio;
import com.beatcraft.client.audio.AudioController;
import com.beatcraft.client.beatmap.BeatmapLogicController;
import com.beatcraft.client.beatmap.BeatmapRenderer;
import com.beatcraft.client.beatmap.data.ColorScheme;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.DifficultyV2;
import com.beatcraft.client.beatmap.data.DifficultyV3;
import com.beatcraft.client.beatmap.data.DifficultyV4;
import com.beatcraft.client.beatmap.data.Info;
import com.beatcraft.client.beatmap.object.data.GameplayObject;
import com.beatcraft.client.beatmap.object.physical.PhysicalGameplayObject;
import com.beatcraft.client.beatmap.object.physical.PhysicalObstacle;
import com.beatcraft.client.render.HUDRenderer;
import com.beatcraft.client.replay.PlayRecorder;
import com.beatcraft.client.replay.ReplayHandler;
import com.beatcraft.client.replay.Replayer;
import com.beatcraft.common.data.map.SongData;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.commons.compress.archivers.dump.UnrecognizedFormatException;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeatmapController {
    public Vector3f worldPosition;
    public float worldAngle;
    public final class_1937 level;
    public UUID trackedPlayer = null;
    public final UUID mapId;
    private long elapsedNanoTime = 0L;
    public float currentBeat;
    public float currentSeconds;
    public float firstBeat;
    public Audio audio;
    public Info info;
    public Difficulty difficulty;
    public HUDRenderer hudRenderer;
    public HUDRenderer.MenuScene scene;
    public PlayRecorder playRecorder;
    public ReplayHandler replayHandler;
    public Replayer replayer;
    private boolean playing = false;
    public float playbackSpeed = 1.0f;
    public boolean isInWall = false;
    public final ArrayList<String> activeModifiers = new ArrayList();
    public final BeatmapLogicController logic = new BeatmapLogicController(this);
    public final BaseProviderHandler baseProvider = new BaseProviderHandler(this);
    public final BeatmapRenderer renderer;
    private final Quaternionf ori = new Quaternionf();
    public boolean firstFrame = false;
    private long lastNanoTime = 0L;
    private final class_4587 matrices = new class_4587();

    public Vector3f getRenderOrigin() {
        return this.worldPosition;
    }

    public void recordObstacleRenderCall(TriConsumer<class_287, Vector3f, Integer> call) {
        this.renderer.recordObstacleRenderCall(call);
    }

    public void recordMirroredObstacleRenderCall(TriConsumer<class_287, Vector3f, Integer> call) {
        this.renderer.recordMirroredObstacleRenderCall(call);
    }

    public void recordRenderCall(Runnable call) {
        this.renderer.recordRenderCall(call);
    }

    public void recordArcRenderCall(BiConsumer<class_287, Vector3f> call) {
        this.renderer.recordArcRenderCall(call);
    }

    public void recordLaserRenderCall(BiConsumer<class_287, Vector3f> call) {
        this.renderer.recordLaserRenderCall(call);
    }

    public void recordLaserPreRenderCall(BiConsumer<class_287, Vector3f> call) {
        this.renderer.recordLaserPreRenderCall(call);
    }

    public void recordLightRenderCall(BiConsumer<class_287, Vector3f> call) {
        this.renderer.recordLightRenderCall(call);
    }

    public void recordBloomfogPosColCall(TriConsumer<Matrix4f, class_287, Vector3f> call) {
        this.renderer.recordBloomfogPosColCall(call);
    }

    public void recordPlainMirrorCall(BiConsumer<class_287, Vector3f> call) {
        this.renderer.recordPlainMirrorCall(call);
    }

    public BeatmapController(class_1937 level, Vector3f position, float rotation, BeatmapRenderer.RenderStyle style) {
        this(UUID.randomUUID(), level, position, rotation, style);
    }

    public BeatmapController(UUID uuid, class_1937 level, Vector3f position, float rotation, BeatmapRenderer.RenderStyle style) {
        this.mapId = uuid;
        this.worldPosition = position;
        this.worldAngle = rotation;
        this.scene = HUDRenderer.MenuScene.SongSelect;
        this.renderer = new BeatmapRenderer(this, style);
        this.playRecorder = new PlayRecorder(this);
        this.replayHandler = new ReplayHandler(this);
        this.replayer = new Replayer(this);
        this.hudRenderer = new HUDRenderer(this);
        this.level = level;
    }

    public void restart() {
        this.seek(0.0f);
        this.resume();
    }

    public void trackPlayer(UUID playerUuid) {
        this.trackedPlayer = playerUuid;
    }

    public void untrackPlayer() {
        this.trackedPlayer = null;
    }

    public void playSong(SongData.BeatmapInfo info) {
        try {
            this.baseProvider.setupDynamicProviders();
            this.setupDifficulty(info);
            this.scene = HUDRenderer.MenuScene.InGame;
            if (this.audio != null) {
                this.audio.close();
            }
            this.audio = AudioController.playMapSong(this.info.getSongFilename());
            this.setDifficultyFromFile(info.getBeatmapLocation().toString(), this.info);
            ColorScheme cs = this.difficulty.getSetDifficulty().getColorScheme();
            this.baseProvider.setupStaticProviders(cs);
            this.logic.reset();
            this.playing = true;
            this.elapsedNanoTime = 0L;
            this.firstFrame = true;
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to load map", (Throwable)e);
        }
    }

    private void setupDifficulty(SongData.BeatmapInfo beatmapInfo) throws IOException {
        Info info;
        Path p = beatmapInfo.getBeatmapLocation();
        String infoPath = p.getParent().toString() + "/Info.dat";
        try {
            info = BeatmapController.getInfoFromFile(infoPath);
        }
        catch (NoSuchFileException e) {
            infoPath = p.getParent().toString() + "/info.dat";
            info = BeatmapController.getInfoFromFile(infoPath);
        }
        this.info = info;
    }

    public float getBpm(float beat) {
        return this.info.getBpm(beat);
    }

    public void checkNote(PhysicalGameplayObject<? extends GameplayObject> obj) {
        this.logic.checkNote(obj);
    }

    public void checkObstacle(PhysicalObstacle obstacle, Vector3f localPos, Quaternionf rotation) {
        this.logic.checkObstacle(obstacle, localPos, rotation);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setModifier(String modifier, boolean state) {
        if (state && !this.activeModifiers.contains(modifier)) {
            this.activeModifiers.add(modifier);
        } else if (!state) {
            this.activeModifiers.remove(modifier);
        }
    }

    public boolean isModifierActive(String modifier) {
        return this.activeModifiers.contains(modifier);
    }

    public String getDisplayInfo() {
        return "Info for map " + String.valueOf(this.mapId) + ":\n  Position: " + String.valueOf(this.worldPosition) + " (world: " + String.valueOf(this.level) + ")\n  Rotation: " + this.worldAngle;
    }

    private long getNanoDeltaTime() {
        long n = System.nanoTime();
        if (this.firstFrame) {
            this.lastNanoTime = n;
            this.firstFrame = false;
            this.seek(0.0f);
        }
        long ndt = n - this.lastNanoTime;
        this.lastNanoTime = n;
        return ndt;
    }

    public void update() {
        long deltaNanoSeconds = this.getNanoDeltaTime();
        double dt = (double)deltaNanoSeconds / 1.0E9;
        boolean shouldPlay = this.isPlaying() && !class_310.method_1551().method_1493();
        boolean doDiffUpdate = this.logic.update(dt);
        if (shouldPlay) {
            this.elapsedNanoTime += (long)((float)deltaNanoSeconds * this.playbackSpeed);
            if (this.difficulty != null) {
                this.currentSeconds = (float)this.elapsedNanoTime / 1.0E9f;
                this.currentBeat = this.info.getBeat(this.currentSeconds);
                if (doDiffUpdate) {
                    this.difficulty.update(this.currentBeat, dt);
                    this.logic.lateUpdate(dt);
                }
                if (this.info == null || this.currentSeconds > this.info.getSongDuration()) {
                    this.reset();
                    Beatcraft.LOGGER.info("Song ended");
                }
            }
        }
        if (this.audio != null) {
            this.audio.update(this.currentBeat, dt, this);
        }
    }

    public void pre_render(class_4184 camera) {
        if (!camera.method_19331().method_37908().equals(this.level)) {
            return;
        }
        float dist = camera.method_19326().method_46409().distance((Vector3fc)this.worldPosition);
        this.matrices.method_22911();
        this.matrices.method_22903();
        this.matrices.method_46416(this.worldPosition.x, this.worldPosition.y, this.worldPosition.z);
        this.matrices.method_22907(this.ori.rotationY(this.worldAngle));
        this.matrices.method_22903();
        this.renderer.pre_render(this.matrices, this.difficulty, camera, dist);
        this.matrices.method_22909();
    }

    public void render(class_4184 camera) {
        if (!camera.method_19331().method_37908().equals(this.level)) {
            return;
        }
        float dist = camera.method_19326().method_46409().distance((Vector3fc)this.worldPosition);
        this.renderer.render(this.matrices, this.difficulty, camera, dist);
        this.matrices.method_22909();
    }

    public void seek(float beat) {
        if (this.difficulty != null) {
            this.difficulty.seek(beat);
            float t = this.info.getTime(beat);
            this.elapsedNanoTime = (long)(t * 1.0E9f);
            this.audio.seek(t);
        }
    }

    public void setSpeed(float speed) {
        this.playbackSpeed = speed;
        if (this.audio != null) {
            this.audio.setSpeed(speed);
        }
    }

    public void resume() {
        if (this.difficulty != null) {
            this.playing = true;
        }
    }

    public void pause() {
        if (this.difficulty != null) {
            this.playing = false;
        }
    }

    public static Info getInfoFromFile(String path) throws IOException {
        String jsonString = Files.readString(Paths.get(path, new String[0]));
        JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
        Info info = Info.from(json, path);
        if (json.has("difficultyBeatmaps")) {
            JsonArray styleSetsRaw = json.get("difficultyBeatmaps").getAsJsonArray();
            styleSetsRaw.forEach(styleSetRaw -> {
                JsonObject styleSetObject = styleSetRaw.getAsJsonObject();
                String styleKey = styleSetObject.get("characteristic").getAsString();
                if (!info.getStyleSets().containsKey(styleKey)) {
                    info.getStyleSets().put(styleKey, new Info.StyleSet());
                }
                Info.StyleSet styleSet = info.getStyleSets().get(styleKey);
                Info.SetDifficulty setDifficulty = Info.SetDifficulty.from(styleSetObject, info);
                String fileName = styleSetObject.get("beatmapDataFilename").getAsString();
                styleSet.difficulties.put(fileName, setDifficulty);
            });
        } else {
            JsonArray styleSetsRaw = json.get("_difficultyBeatmapSets").getAsJsonArray();
            styleSetsRaw.forEach(styleSetRaw -> {
                JsonObject styleSetObject = styleSetRaw.getAsJsonObject();
                Info.StyleSet styleSet = new Info.StyleSet();
                String styleKey = styleSetObject.get("_beatmapCharacteristicName").getAsString();
                info.getStyleSets().put(styleKey, styleSet);
                JsonArray difficultiesRaw = styleSetObject.get("_difficultyBeatmaps").getAsJsonArray();
                difficultiesRaw.forEach(difficultyRaw -> {
                    JsonObject difficultyObject = difficultyRaw.getAsJsonObject();
                    Info.SetDifficulty setDifficulty = Info.SetDifficulty.from(difficultyObject, info);
                    String fileName = difficultyObject.get("_beatmapFilename").getAsString();
                    styleSet.difficulties.put(fileName, setDifficulty);
                });
            });
        }
        return info;
    }

    public static String getPathFileName(String path) {
        return Paths.get(path, new String[0]).getFileName().toString();
    }

    public static Info.SetDifficulty getSetDifficulty(String fileName, Info info) {
        for (Info.StyleSet styleSet : info.getStyleSets().values()) {
            for (Map.Entry<String, Info.SetDifficulty> entry : styleSet.difficulties.entrySet()) {
                if (!Objects.equals(entry.getKey(), fileName)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private static int getMajorVersion(JsonObject json) {
        String version = json.has("version") ? json.get("version").getAsString() : json.get("_version").getAsString();
        return Integer.parseInt(version.substring(0, 1));
    }

    public void setDifficultyFromFile(String path, Info info) throws IOException {
        String fileName = BeatmapController.getPathFileName(path);
        Info.SetDifficulty setDifficulty = BeatmapController.getSetDifficulty(fileName, info);
        this.setDifficultyFromFile(path, setDifficulty, info);
    }

    public void setDifficultyFromFile(String path, Info.SetDifficulty setDifficulty, Info info) throws IOException {
        String jsonString = Files.readString(Paths.get(path, new String[0]));
        JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
        int majorVersion = BeatmapController.getMajorVersion(json);
        switch (majorVersion) {
            case 2: {
                this.difficulty = new DifficultyV2(this, info, setDifficulty);
                ((DifficultyV2)this.difficulty).load(json);
                break;
            }
            case 3: {
                this.difficulty = new DifficultyV3(this, info, setDifficulty);
                ((DifficultyV3)this.difficulty).load(json);
                break;
            }
            case 4: {
                this.difficulty = new DifficultyV4(this, info, setDifficulty);
                ((DifficultyV4)this.difficulty).load(json);
                break;
            }
            default: {
                throw new UnrecognizedFormatException();
            }
        }
    }

    public void reset() {
        this.info = null;
        this.difficulty = null;
        this.playing = false;
        this.elapsedNanoTime = 0L;
        this.lastNanoTime = 0L;
        this.currentBeat = 0.0f;
        this.currentSeconds = 0.0f;
        if (this.audio != null) {
            this.audio.close();
        }
        this.audio = null;
        this.scene = HUDRenderer.MenuScene.SongSelect;
    }
}

