/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.BeatmapRenderer;
import com.beatcraft.common.data.map.SongData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeatmapManager {
    public static final ArrayList<BeatmapController> beatmaps = new ArrayList();
    public static final ArrayList<SongData> songs = new ArrayList();
    private static final float[] DEFAULT_FOG_HEIGHTS = new float[]{-50.0f, -30.0f};

    public static void loadBeatmaps() {
        String folderPath = String.valueOf(class_310.method_1551().field_1697.toPath()) + "/beatmaps/";
        File folder = new File(folderPath);
        if (!folder.exists() && !folder.mkdirs()) {
            Beatcraft.LOGGER.error("Failed to create beatmaps folder");
            return;
        }
        File[] subFolders = folder.listFiles(File::isDirectory);
        if (subFolders == null) {
            Beatcraft.LOGGER.error("Failed to load beatmaps");
            return;
        }
        songs.clear();
        for (File songFolder : subFolders) {
            try {
                SongData data = new SongData(songFolder.getAbsolutePath());
                songs.add(data);
            }
            catch (IOException e) {
                Beatcraft.LOGGER.error("Failed to load beatmap", (Throwable)e);
            }
        }
    }

    public static float[] getAverageFogHeight(Vector3f position) {
        BeatmapController nearest = BeatmapManager.nearestActiveBeatmapToPlayer();
        float[] x = nearest != null ? nearest.difficulty.lightShowEnvironment.getFogHeights() : DEFAULT_FOG_HEIGHTS;
        return new float[]{x[0] + position.y, x[1] + position.y};
    }

    public static BeatmapController getByUuid(UUID uuid) {
        for (BeatmapController map : beatmaps) {
            if (!map.mapId.equals(uuid)) continue;
            return map;
        }
        return null;
    }

    public static BeatmapController place(class_1937 level, Vector3f pos, float angle, BeatmapRenderer.RenderStyle style) {
        BeatmapController map = new BeatmapController(level, pos, angle, style);
        beatmaps.add(map);
        return map;
    }

    public static BeatmapController nearestActiveBeatmapToPlayer() {
        Vector3f pos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        return BeatmapManager.nearestActiveBeatmap(pos);
    }

    public static BeatmapController nearestActiveBeatmap(Vector3f pos) {
        float nearestDist = Float.POSITIVE_INFINITY;
        BeatmapController nearest = null;
        for (BeatmapController map : beatmaps) {
            float dist;
            if (map.difficulty == null || map.difficulty.lightShowEnvironment == null || !((dist = map.getRenderOrigin().distance((Vector3fc)pos)) < nearestDist)) continue;
            nearestDist = dist;
            nearest = map;
        }
        return nearest;
    }

    public static boolean hasNearbyBeatmapToPlayer() {
        Vector3f playerCamera = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        float renderDist = class_310.method_1551().field_1773.method_3193();
        for (BeatmapController map : beatmaps) {
            Vector3f pos = map.getRenderOrigin();
            if (!(playerCamera.distance((Vector3fc)pos) <= renderDist + 64.0f)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNearbyActiveBeatmapToPlayer() {
        Vector3f playerCamera = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        return BeatmapManager.hasNearbyActiveBeatmap(playerCamera);
    }

    public static boolean hasNearbyActiveBeatmap(Vector3f position) {
        float renderDist = class_310.method_1551().field_1773.method_3193();
        for (BeatmapController map : beatmaps) {
            Vector3f pos = map.getRenderOrigin();
            if (!(position.distance((Vector3fc)pos) <= renderDist + 64.0f) || map.difficulty == null || map.difficulty.lightShowEnvironment == null) continue;
            return true;
        }
        return false;
    }

    public static String getMapsInfo() {
        if (beatmaps.isEmpty()) {
            return "No maps to display";
        }
        StringBuilder info = new StringBuilder();
        info.append(String.format("Info for %s map%s:\n", beatmaps.size(), beatmaps.size() == 1 ? "" : "s"));
        for (BeatmapController map : beatmaps) {
            info.append(map.getDisplayInfo()).append("\n");
        }
        return info.toString();
    }

    public static void updateMaps() {
        for (BeatmapController map : beatmaps) {
            map.update();
        }
    }

    public static void preRenderMaps() {
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        for (BeatmapController map : beatmaps) {
            map.pre_render(cam);
        }
    }

    public static void renderMaps() {
        class_4184 cam = class_310.method_1551().field_1773.method_19418();
        for (BeatmapController map : beatmaps) {
            map.render(cam);
        }
    }

    public static void renderHUDs(class_4597 imm) {
        for (BeatmapController map : beatmaps) {
            map.hudRenderer.render(imm);
        }
    }

    public static boolean isTracked(UUID playerUuid) {
        for (BeatmapController map : beatmaps) {
            if (!map.trackedPlayer.equals(playerUuid)) continue;
            return true;
        }
        return false;
    }

    public static BeatmapController getNearestFiltered(Vector3f pos, Function<BeatmapController, Boolean> filter) {
        BeatmapController nearest = null;
        float nearestDist = Float.POSITIVE_INFINITY;
        for (BeatmapController map : beatmaps) {
            float dist = map.getRenderOrigin().distance((Vector3fc)pos);
            if (!(dist < nearestDist) || !filter.apply(map).booleanValue()) continue;
            nearestDist = dist;
            nearest = map;
        }
        return nearest;
    }
}

