/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap;

import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.effect.MirrorHandler;
import com.beatcraft.client.render.effect.ObstacleGlowRenderer;
import com.beatcraft.client.render.instancing.debug.TransformationWidgetInstanceData;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.common.utils.MathUtil;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BeatmapRenderer {
    private final BeatmapController mapController;
    public RenderStyle renderStyle;
    public boolean doSkyEffects = true;
    public boolean skipWorldRender = false;
    public final ArrayList<TriConsumer<Matrix4f, class_287, Vector3f>> bloomfogPosColCalls = new ArrayList();
    public final ArrayList<Runnable> renderCalls = new ArrayList();
    public final ArrayList<TriConsumer<class_287, Vector3f, Integer>> obstacleRenderCalls = new ArrayList();
    public final ArrayList<BiConsumer<class_287, Vector3f>> laserRenderCalls = new ArrayList();
    public final ArrayList<BiConsumer<class_287, Vector3f>> laserPreRenderCalls = new ArrayList();
    public final ArrayList<BiConsumer<class_287, Vector3f>> lightRenderCalls = new ArrayList();
    public final ArrayList<BiConsumer<class_287, Vector3f>> arcRenderCalls = new ArrayList();

    public BeatmapRenderer(BeatmapController map, RenderStyle style) {
        this.mapController = map;
        this.renderStyle = style;
    }

    public void recordObstacleRenderCall(TriConsumer<class_287, Vector3f, Integer> call) {
        this.obstacleRenderCalls.add(call);
    }

    public void recordMirroredObstacleRenderCall(TriConsumer<class_287, Vector3f, Integer> call) {
    }

    public void recordRenderCall(Runnable call) {
        this.renderCalls.add(call);
    }

    public void recordArcRenderCall(BiConsumer<class_287, Vector3f> call) {
        this.arcRenderCalls.add(call);
    }

    public void recordLaserRenderCall(BiConsumer<class_287, Vector3f> call) {
        this.laserRenderCalls.add(call);
    }

    public void recordLaserPreRenderCall(BiConsumer<class_287, Vector3f> call) {
        this.laserPreRenderCalls.add(call);
    }

    public void recordLightRenderCall(BiConsumer<class_287, Vector3f> call) {
        this.lightRenderCalls.add(call);
    }

    public void recordBloomfogPosColCall(TriConsumer<Matrix4f, class_287, Vector3f> call) {
        this.bloomfogPosColCalls.add(call);
    }

    public void recordPlainMirrorCall(BiConsumer<class_287, Vector3f> call) {
    }

    private void renderLightDepth(class_289 tesselator, Vector3f cameraPos) {
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = Bloomfog.lightDepth;
        Bloomfog.lightDepth.method_1235(true);
        Bloomfog.lightDepth.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
        Bloomfog.lightDepth.method_1230(class_310.field_1703);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (BiConsumer<class_287, Vector3f> call : this.lightRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            class_286.method_43433((class_9801)buff);
        }
        Bloomfog.lightDepth.method_1240();
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        class_310.method_1551().method_1522().method_1235(true);
    }

    private void renderBloomfogPosCol(Matrix4f transform, class_289 tesselator, Vector3f cameraPos) {
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (TriConsumer<Matrix4f, class_287, Vector3f> call : this.bloomfogPosColCalls) {
            call.accept((Object)transform, (Object)buffer, (Object)cameraPos);
        }
        this.bloomfogPosColCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShader(() -> Bloomfog.bloomfogPositionColor);
            BeatcraftRenderer.bloomfog.loadTex();
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
        }
    }

    private void renderEnvironmentLights(class_289 tesselator, Vector3f cameraPos) {
        Matrix4f worldTransform = new Matrix4f();
        worldTransform.translate((Vector3fc)cameraPos);
        worldTransform.rotate((Quaternionfc)MirrorHandler.invCameraRotation.conjugate(new Quaternionf()));
        this.renderLightDepth(tesselator, cameraPos);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(() -> Bloomfog.backlightsPositionColorShader);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)false);
        for (BiConsumer<class_287, Vector3f> call : this.lightRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        this.lightRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            Bloomfog.backlightsPositionColorShader.method_34583("Sampler0", (Object)Bloomfog.lightDepth.method_30278());
            RenderSystem.setShaderTexture((int)0, (int)Bloomfog.lightDepth.method_30278());
            Bloomfog.backlightsPositionColorShader.method_35785("WorldTransform").method_1250(worldTransform);
            Bloomfog.backlightsPositionColorShader.method_35785("u_fog").method_1253(Bloomfog.getFogHeights(this.mapController.worldPosition));
            class_286.method_43433((class_9801)buff);
        }
        LightMesh.renderAllSolid();
        RenderSystem.defaultBlendFunc();
    }

    private void renderFloorLightsPhase1(class_289 tesselator, Vector3f cameraPos) {
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<class_287, Vector3f> call : this.laserPreRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        this.laserPreRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
        class_286.method_43433((class_9801)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private void renderFloorLights(class_289 tesselator, Vector3f cameraPos) {
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<class_287, Vector3f> call : this.laserRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos);
        }
        this.laserRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
        class_286.method_43433((class_9801)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private void renderObstacles(class_289 tesselator, Vector3f cameraPos) {
        if (this.mapController.difficulty == null) {
            this.obstacleRenderCalls.clear();
            return;
        }
        int color = this.mapController.difficulty.getSetDifficulty().getColorScheme().getObstacleColor().toARGB(0.15f);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        for (TriConsumer<class_287, Vector3f, Integer> call : this.obstacleRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)color);
        }
        this.obstacleRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            ObstacleGlowRenderer.grabScreen();
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.depthMask((boolean)true);
            class_6367 scene = ObstacleGlowRenderer.framebuffer;
            RenderSystem.setShader(() -> ObstacleGlowRenderer.distortionShader);
            RenderSystem.setShaderTexture((int)0, (int)scene.method_30277());
            ObstacleGlowRenderer.distortionShader.method_35785("Time").method_1251((float)System.nanoTime() / 1.0E9f);
            buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
            class_286.method_43433((class_9801)buff);
            RenderSystem.disableDepthTest();
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
        }
    }

    public void pre_render(class_4587 matrices, Difficulty difficulty, class_4184 camera, float distance) {
        class_289 tesselator = class_289.method_1348();
        Vector3f cameraPos = camera.method_19326().method_46409();
        Matrix4f m = matrices.method_23760().method_23761();
        this.renderBloomfogPosCol(m, tesselator, cameraPos);
        this.renderEnvironmentLights(tesselator, cameraPos);
        float alpha = 0.0f;
        switch (this.renderStyle.ordinal()) {
            case 1: {
                if (distance <= 10.0f) {
                    alpha = 1.0f;
                    break;
                }
                alpha = Math.clamp(MathUtil.inverseLerp(300.0f, 0.0f, distance - 10.0f), 0.0f, 1.0f);
                break;
            }
            case 0: {
                float f = alpha = BeatcraftClient.wearingHeadset ? 1.0f : 0.0f;
            }
        }
        if (difficulty != null) {
            difficulty.render(matrices, camera, alpha);
        }
        this.renderFloorLightsPhase1(tesselator, cameraPos);
        this.renderFloorLights(tesselator, cameraPos);
        if (BeatcraftClient.playerConfig.debug.beatmap.renderBeatmapPosition()) {
            MeshLoader.MATRIX_LOCATOR_MESH.draw(TransformationWidgetInstanceData.create(m));
        }
    }

    public void render(class_4587 matrices, Difficulty difficulty, class_4184 camera, float distance) {
        class_289 tesselator = class_289.method_1348();
        Vector3f cameraPos = camera.method_19326().method_46409();
        this.renderObstacles(tesselator, cameraPos);
    }

    public static enum RenderStyle {
        HEADSET,
        DISTANCE;

    }
}

