/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.data;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.EventGroup;
import com.beatcraft.client.beatmap.data.Info;
import com.beatcraft.client.beatmap.data.event.AnimateTrack;
import com.beatcraft.client.beatmap.data.event.AssignPathAnimation;
import com.beatcraft.client.beatmap.data.event.AssignTrackParent;
import com.beatcraft.client.beatmap.data.event.RotationEvent;
import com.beatcraft.client.beatmap.object.data.Arc;
import com.beatcraft.client.beatmap.object.data.BombNote;
import com.beatcraft.client.beatmap.object.data.ColorNote;
import com.beatcraft.client.beatmap.object.data.Obstacle;
import com.beatcraft.client.beatmap.object.physical.PhysicalArc;
import com.beatcraft.client.beatmap.object.physical.PhysicalBombNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalColorNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalObstacle;
import com.beatcraft.client.lightshow.environment.EnvironmentUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import net.minecraft.class_3518;

public class DifficultyV2
extends Difficulty {
    public DifficultyV2(BeatmapController controller, Info info, Info.SetDifficulty setDifficulty) {
        super(controller, info, setDifficulty);
    }

    public DifficultyV2 load(JsonObject json) {
        this.loadLightshow(json);
        this.mapController.baseProvider.setupStaticProviders(this.getSetDifficulty().getColorScheme());
        this.loadNotesAndBombs(json);
        this.loadObstacles(json);
        this.loadArcs(json);
        this.loadEvents(json);
        this.loadPointDefinitions(json);
        this.loadCustomEvents(json);
        this.doPostLoad();
        return this;
    }

    private void loadNotesAndBombs(JsonObject json) {
        JsonArray rawNotes = json.getAsJsonArray("_notes");
        rawNotes.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            int type = obj.get("_type").getAsInt();
            if (type == 3) {
                BombNote note = new BombNote(this.mapController).loadV2(obj, this);
                this.bombNotes.add(new PhysicalBombNote(this.mapController, note));
            } else {
                ColorNote note = new ColorNote(this.mapController).loadV2(obj, this);
                this.colorNotes.add(new PhysicalColorNote(this.mapController, note));
            }
        });
    }

    void loadObstacles(JsonObject json) {
        JsonArray rawObstacles = json.getAsJsonArray("_obstacles");
        rawObstacles.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Obstacle obstacle = new Obstacle(this.mapController).loadV2(obj, this);
            this.obstacles.add(new PhysicalObstacle(this.mapController, obstacle));
        });
    }

    void loadArcs(JsonObject json) {
        if (json.has("_sliders")) {
            JsonArray rawArcs = json.getAsJsonArray("_sliders");
            rawArcs.forEach(o -> {
                JsonObject obj = o.getAsJsonObject();
                Arc arc = new Arc(this.mapController).loadV2(obj, this);
                this.arcs.add(new PhysicalArc(this.mapController, arc));
            });
        }
    }

    private void loadEvents(JsonObject json) {
        JsonArray events = json.getAsJsonArray("_events");
        events.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            EventGroup group = EventGroup.fromType(obj.get("_type").getAsInt());
            if (group == EventGroup.EARLY_ROTATION) {
                this.rotationEvents.add(new RotationEvent(true).loadV2(obj, this));
            } else if (group == EventGroup.LATE_ROTATION) {
                this.rotationEvents.add(new RotationEvent(false).loadV2(obj, this));
            }
        });
    }

    private void loadPointDefinitions(JsonObject json) {
        JsonObject customData;
        if (json.has("_customData") && (customData = json.getAsJsonObject("_customData")).has("_pointDefinitions")) {
            JsonArray pointDefinitions = customData.getAsJsonArray("_pointDefinitions");
            pointDefinitions.forEach(x -> {
                JsonObject pointDefinition = x.getAsJsonObject();
                String name = class_3518.method_15265((JsonObject)pointDefinition, (String)"_name");
                JsonArray points = pointDefinition.getAsJsonArray("_points");
                this.pointDefinitions.put(name, points);
            });
        }
    }

    private void loadCustomEvents(JsonObject json) {
        JsonObject customData;
        if (json.has("_customData") && (customData = json.getAsJsonObject("_customData")).has("_customEvents")) {
            JsonArray customEvents = customData.getAsJsonArray("_customEvents");
            customEvents.forEach(o -> this.loadCustomEvent(o.getAsJsonObject()));
        }
    }

    private void loadCustomEvent(JsonObject json) {
        String type;
        switch (type = json.get("_type").getAsString()) {
            case "AnimateTrack": {
                this.animateTracks.add(new AnimateTrack(this.mapController).loadV2(json, this));
                break;
            }
            case "AssignPathAnimation": {
                this.assignPathAnimations.add(new AssignPathAnimation(this.mapController).loadV2(json, this));
                break;
            }
            case "AssignTrackParent": {
                this.assignTrackParents.add(new AssignTrackParent().loadV2(json, this));
            }
        }
    }

    private void loadLightshow(JsonObject json) {
        this.lightShowEnvironment = EnvironmentUtils.load(this.mapController, json);
    }
}

