/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.data;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.EventGroup;
import com.beatcraft.client.beatmap.data.Info;
import com.beatcraft.client.beatmap.data.event.AnimateTrack;
import com.beatcraft.client.beatmap.data.event.AssignPathAnimation;
import com.beatcraft.client.beatmap.data.event.AssignTrackParent;
import com.beatcraft.client.beatmap.data.event.RotationEvent;
import com.beatcraft.client.beatmap.object.data.Arc;
import com.beatcraft.client.beatmap.object.data.BombNote;
import com.beatcraft.client.beatmap.object.data.ChainNoteHead;
import com.beatcraft.client.beatmap.object.data.ChainNoteLink;
import com.beatcraft.client.beatmap.object.data.ColorNote;
import com.beatcraft.client.beatmap.object.data.Obstacle;
import com.beatcraft.client.beatmap.object.physical.PhysicalArc;
import com.beatcraft.client.beatmap.object.physical.PhysicalBombNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalChainNoteHead;
import com.beatcraft.client.beatmap.object.physical.PhysicalChainNoteLink;
import com.beatcraft.client.beatmap.object.physical.PhysicalColorNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalObstacle;
import com.beatcraft.client.lightshow.environment.EnvironmentUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import oshi.util.tuples.Pair;

public class DifficultyV3
extends Difficulty {
    public DifficultyV3(BeatmapController controller, Info info, Info.SetDifficulty setDifficulty) {
        super(controller, info, setDifficulty);
    }

    public DifficultyV3 load(JsonObject json) {
        this.loadLightshow(json);
        this.mapController.baseProvider.setupStaticProviders(this.getSetDifficulty().getColorScheme());
        this.loadChains(json);
        this.loadNotes(json);
        this.loadBombs(json);
        this.loadArcs(json);
        this.loadObstacles(json);
        this.loadBasicEvents(json);
        this.loadRotationEvents(json);
        this.loadPointDefinitions(json);
        this.loadCustomEvents(json);
        this.doPostLoad();
        return this;
    }

    void loadNotes(JsonObject json) {
        JsonObject customData;
        JsonArray rawColorNotes = json.getAsJsonArray("colorNotes");
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("fakeColorNotes")) {
            rawColorNotes.addAll(customData.getAsJsonArray("fakeColorNotes"));
        }
        rawColorNotes.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            ColorNote note = new ColorNote(this.mapController).loadV3(obj, this);
            AtomicBoolean canAdd = new AtomicBoolean(true);
            this.chainHeadNotes.forEach(c -> {
                if (note.getBeat() == ((ChainNoteHead)c.getData()).getBeat() && note.getX() == ((ChainNoteHead)c.getData()).getX() && note.getY() == ((ChainNoteHead)c.getData()).getY()) {
                    canAdd.set(false);
                }
            });
            if (canAdd.get()) {
                this.colorNotes.add(new PhysicalColorNote(this.mapController, note));
            }
        });
    }

    void loadBombs(JsonObject json) {
        JsonObject customData;
        JsonArray rawBombNotes = json.getAsJsonArray("bombNotes");
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("fakeBombNotes")) {
            rawBombNotes.addAll(customData.getAsJsonArray("fakeBombNotes"));
        }
        rawBombNotes.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            BombNote note = new BombNote(this.mapController).loadV3(obj, this);
            this.bombNotes.add(new PhysicalBombNote(this.mapController, note));
        });
    }

    void loadChains(JsonObject json) {
        JsonArray rawChainsData = json.getAsJsonArray("burstSliders");
        rawChainsData.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Pair<ChainNoteHead, List<ChainNoteLink>> chain = ChainNoteHead.buildV3(this.mapController, obj, this);
            this.chainHeadNotes.add(new PhysicalChainNoteHead(this.mapController, (ChainNoteHead)chain.getA()));
            ((List)chain.getB()).forEach(c -> this.chainLinkNotes.add(new PhysicalChainNoteLink(this.mapController, (ChainNoteLink)c)));
        });
    }

    void loadArcs(JsonObject json) {
        JsonArray rawArcs = json.getAsJsonArray("sliders");
        rawArcs.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Arc arc = new Arc(this.mapController).loadV3(obj, this);
            this.arcs.add(new PhysicalArc(this.mapController, arc));
        });
    }

    void loadObstacles(JsonObject json) {
        JsonArray rawObstacles = json.getAsJsonArray("obstacles");
        rawObstacles.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Obstacle obstacle = new Obstacle(this.mapController).loadV3(obj, this);
            this.obstacles.add(new PhysicalObstacle(this.mapController, obstacle));
        });
    }

    void loadBasicEvents(JsonObject json) {
        JsonArray events = json.getAsJsonArray("basicBeatmapEvents");
        events.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            EventGroup group = EventGroup.fromType(obj.get("et").getAsInt());
            if (group == EventGroup.EARLY_ROTATION) {
                this.rotationEvents.add(new RotationEvent(true).fromBasicEventV3(obj, this));
            } else if (group == EventGroup.LATE_ROTATION) {
                this.rotationEvents.add(new RotationEvent(false).fromBasicEventV3(obj, this));
            }
        });
    }

    void loadRotationEvents(JsonObject json) {
        JsonArray events = json.getAsJsonArray("rotationEvents");
        events.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            boolean early = obj.get("e").getAsInt() == 1;
            this.rotationEvents.add(new RotationEvent(early).loadV3(obj, this));
        });
    }

    private void loadPointDefinitions(JsonObject json) {
        JsonObject customData;
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("pointDefinitions")) {
            JsonObject pointDefinitions = customData.getAsJsonObject("pointDefinitions");
            pointDefinitions.asMap().forEach((name, points) -> this.pointDefinitions.put(name, points.getAsJsonArray()));
        }
    }

    private void loadCustomEvents(JsonObject json) {
        JsonObject customData;
        if (json.has("customData") && (customData = json.getAsJsonObject("customData")).has("customEvents")) {
            JsonArray customEvents = customData.getAsJsonArray("customEvents");
            customEvents.forEach(o -> this.loadCustomEvent(o.getAsJsonObject()));
        }
    }

    private void loadCustomEvent(JsonObject json) {
        String type;
        switch (type = json.get("t").getAsString()) {
            case "AnimateTrack": {
                this.animateTracks.add(new AnimateTrack(this.mapController).loadV3(json, this));
                break;
            }
            case "AssignPathAnimation": {
                this.assignPathAnimations.add(new AssignPathAnimation(this.mapController).loadV3(json, this));
                break;
            }
            case "AssignTrackParent": {
                this.assignTrackParents.add(new AssignTrackParent().loadV3(json, this));
            }
        }
    }

    private void loadLightshow(JsonObject json) {
        this.lightShowEnvironment = EnvironmentUtils.load(this.mapController, json);
    }
}

