/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.data;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.Info;
import com.beatcraft.client.beatmap.object.data.Arc;
import com.beatcraft.client.beatmap.object.data.BombNote;
import com.beatcraft.client.beatmap.object.data.ChainNoteHead;
import com.beatcraft.client.beatmap.object.data.ChainNoteLink;
import com.beatcraft.client.beatmap.object.data.ColorNote;
import com.beatcraft.client.beatmap.object.data.Obstacle;
import com.beatcraft.client.beatmap.object.physical.PhysicalArc;
import com.beatcraft.client.beatmap.object.physical.PhysicalBombNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalChainNoteHead;
import com.beatcraft.client.beatmap.object.physical.PhysicalChainNoteLink;
import com.beatcraft.client.beatmap.object.physical.PhysicalColorNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalObstacle;
import com.beatcraft.client.lightshow.environment.EnvironmentUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import oshi.util.tuples.Pair;

public class DifficultyV4
extends Difficulty {
    public DifficultyV4(BeatmapController controller, Info info, Info.SetDifficulty setDifficulty) {
        super(controller, info, setDifficulty);
    }

    public DifficultyV4 load(JsonObject json) {
        this.loadLightshow();
        this.mapController.baseProvider.setupStaticProviders(this.getSetDifficulty().getColorScheme());
        this.loadChains(json);
        this.loadNotes(json);
        this.loadBombs(json);
        this.loadObstacles(json);
        this.loadArcs(json);
        this.doPostLoad();
        return this;
    }

    void loadNotes(JsonObject json) {
        JsonArray noteMetaData = json.getAsJsonArray("colorNotesData");
        JsonArray noteData = json.getAsJsonArray("colorNotes");
        noteData.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            ColorNote note = new ColorNote(this.mapController).loadV4(obj, noteMetaData, this);
            AtomicBoolean canAdd = new AtomicBoolean(true);
            this.chainHeadNotes.forEach(c -> {
                if (note.getBeat() == ((ChainNoteHead)c.getData()).getBeat() && note.getX() == ((ChainNoteHead)c.getData()).getX() && note.getY() == ((ChainNoteHead)c.getData()).getY()) {
                    canAdd.set(false);
                }
            });
            if (canAdd.get()) {
                this.colorNotes.add(new PhysicalColorNote(this.mapController, note));
            }
        });
    }

    void loadBombs(JsonObject json) {
        JsonArray bombMetaData = json.getAsJsonArray("bombNotesData");
        JsonArray bombData = json.getAsJsonArray("bombNotes");
        bombData.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            BombNote bomb = new BombNote(this.mapController).loadV4(obj, bombMetaData, this);
            this.bombNotes.add(new PhysicalBombNote(this.mapController, bomb));
        });
    }

    void loadObstacles(JsonObject json) {
        JsonArray obstacleMetaData = json.getAsJsonArray("obstaclesData");
        JsonArray obstacles = json.getAsJsonArray("obstacles");
        obstacles.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Obstacle obstacle = new Obstacle(this.mapController).loadV4(obj, obstacleMetaData, this);
            this.obstacles.add(new PhysicalObstacle(this.mapController, obstacle));
        });
    }

    void loadChains(JsonObject json) {
        JsonArray noteMetaData = json.getAsJsonArray("colorNotesData");
        JsonArray chainMetaData = json.getAsJsonArray("chainsData");
        JsonArray chainData = json.getAsJsonArray("chains");
        chainData.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Pair<ChainNoteHead, List<ChainNoteLink>> chain = ChainNoteHead.buildV4(this.mapController, obj, noteMetaData, chainMetaData, this);
            this.chainHeadNotes.add(new PhysicalChainNoteHead(this.mapController, (ChainNoteHead)chain.getA()));
            ((List)chain.getB()).forEach(c -> this.chainLinkNotes.add(new PhysicalChainNoteLink(this.mapController, (ChainNoteLink)c)));
        });
    }

    void loadArcs(JsonObject json) {
        JsonArray arcMetaData = json.getAsJsonArray("arcsData");
        JsonArray colorNotesData = json.getAsJsonArray("colorNotesData");
        JsonArray rawArcs = json.getAsJsonArray("arcs");
        rawArcs.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            Arc arc = new Arc(this.mapController).loadV4(obj, arcMetaData, colorNotesData, this);
            this.arcs.add(new PhysicalArc(this.mapController, arc));
        });
    }

    private void loadLightshow() {
        String path = this.getSetDifficulty().getLightshowFile();
        if (path == null) {
            return;
        }
        path = (this.getInfo().getMapDirectory() + "/" + path).replace("\\", "/");
        try {
            String jsonString = Files.readString(Paths.get(path, new String[0]));
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            this.lightShowEnvironment = EnvironmentUtils.load(this.mapController, json);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

