/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.object.data;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.CutDirection;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.Info;
import com.beatcraft.client.beatmap.data.NoteType;
import com.beatcraft.client.beatmap.object.data.GameplayObject;
import com.beatcraft.client.beatmap.object.data.ScorableObject;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_3518;

public class ColorNote
extends GameplayObject
implements ScorableObject {
    private float angleOffset;
    private CutDirection cutDirection;
    private NoteType noteType;
    private Color color;
    private boolean disableNoteLook = false;
    private boolean disableNoteGravity = false;

    public ColorNote(BeatmapController map) {
        super(map);
    }

    private void applyColorScheme(Info.SetDifficulty setDifficulty) {
        this.color = this.getNoteType() == NoteType.RED ? setDifficulty.getColorScheme().getNoteLeftColor() : setDifficulty.getColorScheme().getNoteRightColor();
    }

    @Override
    public ColorNote loadV2(JsonObject json, Difficulty difficulty) {
        super.loadV2(json, difficulty);
        this.angleOffset = 0.0f;
        this.cutDirection = CutDirection.values()[json.get("_cutDirection").getAsInt()];
        this.noteType = NoteType.values()[json.get("_type").getAsInt()];
        this.applyColorScheme(difficulty.getSetDifficulty());
        if (json.has("_customData")) {
            JsonObject customData = json.get("_customData").getAsJsonObject();
            if (customData.has("_color")) {
                this.color = Color.fromJsonArray(customData.get("_color").getAsJsonArray());
            }
            this.disableNoteLook = class_3518.method_15258((JsonObject)customData, (String)"_disableNoteLook", (boolean)false);
            this.disableNoteGravity = class_3518.method_15258((JsonObject)customData, (String)"_disableNoteGravity", (boolean)false);
        }
        return this;
    }

    @Override
    public ColorNote loadV3(JsonObject json, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        this.angleOffset = JsonUtil.getOrDefault(json, "a", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.cutDirection = CutDirection.values()[JsonUtil.getOrDefault(json, "d", JsonElement::getAsInt, Integer.valueOf(0))];
        this.noteType = NoteType.values()[JsonUtil.getOrDefault(json, "c", JsonElement::getAsInt, Integer.valueOf(0))];
        this.applyColorScheme(difficulty.getSetDifficulty());
        if (json.has("customData")) {
            JsonObject customData = json.getAsJsonObject("customData");
            if (customData.has("color")) {
                this.color = Color.fromJsonArray(customData.get("color").getAsJsonArray());
            }
            this.disableNoteLook = class_3518.method_15258((JsonObject)customData, (String)"disableNoteLook", (boolean)false);
            this.disableNoteGravity = class_3518.method_15258((JsonObject)customData, (String)"disableNoteGravity", (boolean)false);
        }
        return this;
    }

    @Override
    public ColorNote loadV4(JsonObject json, JsonArray colorNoteData, Difficulty difficulty) {
        super.loadV4(json, colorNoteData, difficulty);
        int i = JsonUtil.getOrDefault(json, "i", JsonElement::getAsInt, Integer.valueOf(0));
        JsonObject noteData = colorNoteData.get(i).getAsJsonObject();
        this.angleOffset = JsonUtil.getOrDefault(noteData, "a", JsonElement::getAsInt, Integer.valueOf(0)).intValue();
        this.cutDirection = CutDirection.values()[JsonUtil.getOrDefault(noteData, "d", JsonElement::getAsInt, Integer.valueOf(0))];
        this.noteType = NoteType.values()[JsonUtil.getOrDefault(noteData, "c", JsonElement::getAsInt, Integer.valueOf(0))];
        this.applyColorScheme(difficulty.getSetDifficulty());
        return this;
    }

    public float getAngleOffset() {
        return this.angleOffset;
    }

    public CutDirection getCutDirection() {
        return this.cutDirection;
    }

    public NoteType getNoteType() {
        return this.noteType;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isNoteLookDisabled() {
        return this.disableNoteLook;
    }

    public boolean isNoteGravityDisabled() {
        return this.disableNoteGravity;
    }

    @Override
    public Color score$getColor() {
        return this.color;
    }

    @Override
    public NoteType score$getNoteType() {
        return this.noteType;
    }

    @Override
    public CutDirection score$getCutDirection() {
        return this.getCutDirection();
    }
}

