/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.object.data;

import com.beatcraft.client.animation.Animation;
import com.beatcraft.client.animation.track.ObjectTrackContainer;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.Info;
import com.beatcraft.client.beatmap.data.Jumps;
import com.beatcraft.client.beatmap.object.data.BeatmapObject;
import com.beatcraft.common.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_3518;
import org.joml.Quaternionf;

public abstract class GameplayObject
extends BeatmapObject {
    protected float njs;
    protected float offset;
    protected float x;
    protected float y;
    protected int mapIndex;
    private Quaternionf localRotation;
    private Quaternionf worldRotation;
    private final ObjectTrackContainer trackContainer = new ObjectTrackContainer();
    private final Animation pathAnimation;
    private Jumps jumps;

    public GameplayObject(BeatmapController map) {
        this.pathAnimation = new Animation(map);
    }

    public void loadCustomDataV2(JsonObject json, Difficulty difficulty) {
        if (json.has("_customData")) {
            JsonArray coordinates;
            JsonObject customData = json.getAsJsonObject("_customData");
            this.offset = class_3518.method_15277((JsonObject)customData, (String)"_noteJumpStartBeatOffset", (float)this.offset);
            this.njs = class_3518.method_15277((JsonObject)customData, (String)"_noteJumpMovementSpeed", (float)this.njs);
            this.worldRotation = JsonUtil.getQuaternion(customData, "_rotation", null);
            this.localRotation = JsonUtil.getQuaternion(customData, "_localRotation", null);
            if (customData.has("_coordinates")) {
                coordinates = customData.getAsJsonArray("_coordinates");
                this.x = coordinates.get(0).getAsFloat() + 2.0f;
                this.y = coordinates.get(1).getAsFloat();
            }
            if (customData.has("_position")) {
                coordinates = customData.getAsJsonArray("_position");
                this.x = coordinates.get(0).getAsFloat() + 2.0f;
                this.y = coordinates.get(1).getAsFloat();
            }
            if (customData.has("_track")) {
                this.trackContainer.loadTracks(customData.get("_track"), difficulty.getTrackLibrary());
            }
            if (customData.has("_animation")) {
                this.pathAnimation.loadV2(customData.get("_animation").getAsJsonObject(), difficulty);
            }
        }
    }

    public void loadCustomDataV3(JsonObject json, Difficulty difficulty) {
        if (json.has("customData")) {
            JsonArray coordinates;
            JsonObject customData = json.getAsJsonObject("customData");
            this.offset = class_3518.method_15277((JsonObject)customData, (String)"noteJumpStartBeatOffset", (float)this.offset);
            this.njs = class_3518.method_15277((JsonObject)customData, (String)"noteJumpMovementSpeed", (float)this.njs);
            this.worldRotation = JsonUtil.getQuaternion(customData, "worldRotation", null);
            this.localRotation = JsonUtil.getQuaternion(customData, "localRotation", null);
            if (customData.has("coordinates")) {
                coordinates = customData.getAsJsonArray("coordinates");
                this.x = coordinates.get(0).isJsonPrimitive() && coordinates.get(0).getAsJsonPrimitive().isNumber() ? coordinates.get(0).getAsFloat() + 2.0f : 0.0f;
                this.y = coordinates.get(1).isJsonPrimitive() && coordinates.get(1).getAsJsonPrimitive().isNumber() ? coordinates.get(1).getAsFloat() : 0.0f;
            }
            if (customData.has("position")) {
                coordinates = customData.getAsJsonArray("position");
                this.x = coordinates.get(0).isJsonPrimitive() && coordinates.get(0).getAsJsonPrimitive().isNumber() ? coordinates.get(0).getAsFloat() + 2.0f : 0.0f;
                this.y = coordinates.get(1).isJsonPrimitive() && coordinates.get(1).getAsJsonPrimitive().isNumber() ? coordinates.get(1).getAsFloat() : 0.0f;
            }
            if (customData.has("track")) {
                this.trackContainer.loadTracks(customData.get("track"), difficulty.getTrackLibrary());
            }
            if (customData.has("animation")) {
                this.pathAnimation.loadV3(customData.get("animation").getAsJsonObject(), difficulty);
            }
        }
    }

    public void setIndex(int index) {
        this.mapIndex = index;
    }

    public int getMapIndex() {
        return this.mapIndex;
    }

    @Override
    public GameplayObject loadV2(JsonObject json, Difficulty difficulty) {
        super.loadV2(json, difficulty);
        this.x = json.get("_lineIndex").getAsFloat();
        this.y = json.get("_lineLayer").getAsFloat();
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.njs = difficulty.getSetDifficulty().getNjs(this.beat);
        this.loadCustomDataV2(json, difficulty);
        this.loadJumps(difficulty.getInfo());
        return this;
    }

    @Override
    public GameplayObject loadV3(JsonObject json, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        this.x = JsonUtil.getOrDefault(json, "x", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.y = JsonUtil.getOrDefault(json, "y", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.njs = difficulty.getSetDifficulty().getNjs(this.beat);
        this.loadCustomDataV3(json, difficulty);
        this.loadJumps(difficulty.getInfo());
        return this;
    }

    public GameplayObject loadV4(JsonObject json, JsonArray colorNoteData, Difficulty difficulty) {
        super.loadV3(json, difficulty);
        int index = JsonUtil.getOrDefault(json, "i", JsonElement::getAsInt, Integer.valueOf(0));
        this.offset = difficulty.getSetDifficulty().getOffset();
        this.njs = difficulty.getSetDifficulty().getNjs(this.beat);
        this.loadJumps(difficulty.getInfo());
        if (index >= colorNoteData.size()) {
            return this;
        }
        JsonObject noteData = colorNoteData.get(index).getAsJsonObject();
        this.x = JsonUtil.getOrDefault(noteData, "x", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        this.y = JsonUtil.getOrDefault(noteData, "y", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
        return this;
    }

    protected void loadJumps(Info info) {
        this.jumps = Jumps.getJumps(this.njs, this.offset, info.getBpm(this.beat));
    }

    public float getNjs() {
        return this.njs;
    }

    public float getOffset() {
        return this.offset;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Quaternionf getLocalRotation() {
        return this.localRotation;
    }

    public Quaternionf getWorldRotation() {
        return this.worldRotation;
    }

    public ObjectTrackContainer getTrackContainer() {
        return this.trackContainer;
    }

    public Animation getPathAnimation() {
        return this.pathAnimation;
    }

    public Jumps getJumps() {
        return this.jumps;
    }
}

