/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.object.physical;

import com.beatcraft.client.animation.AnimationState;
import com.beatcraft.client.animation.Easing;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.object.data.Arc;
import com.beatcraft.client.beatmap.object.physical.PhysicalGameplayObject;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.DebugRenderer;
import com.beatcraft.common.data.types.BezierPath;
import com.beatcraft.common.data.types.ISplinePath;
import com.beatcraft.common.memory.MemoryPool;
import com.beatcraft.common.utils.MathUtil;
import java.util.ArrayList;
import net.minecraft.class_287;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhysicalArc
extends PhysicalGameplayObject<Arc> {
    BezierPath basePath;
    private int segments = 50;

    public PhysicalArc(BeatmapController map, Arc data) {
        super(map, data);
        this.buildBasePath(new Vector3f(1.0f, 1.0f, 1.0f));
    }

    public void buildBasePath(Vector3f modifier) {
        ArrayList<Vector3f> points = new ArrayList<Vector3f>();
        float startX = -((Arc)this.data).getX() * 0.6f + 0.9f;
        float startY = ((Arc)this.data).getY() * 0.6f + 0.8f;
        Vector3f start = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f startC = Arc.cutDirectionToControlPoint(((Arc)this.data).getHeadCutDirection()).mul(((Arc)this.data).getHeadMagnitude()).mul(2.0f).add((Vector3fc)start);
        Vector3f end = new Vector3f(-((Arc)this.data).getTailX() * 0.6f + 0.9f - startX, ((Arc)this.data).getTailY() * 0.6f + 0.8f - startY, -(((Arc)this.data).getTailBeat() - ((Arc)this.data).getBeat()));
        Vector3f endC = Arc.cutDirectionToControlPoint(((Arc)this.data).getTailCutDirection()).mul(((Arc)this.data).getTailMagnitude()).mul(-2.0f, -2.0f, -2.0f).add((Vector3fc)end);
        Vector3f midpoint = MathUtil.lerpVector3(startC, endC, 0.5f);
        boolean inline = ((Arc)this.data).getX() == ((Arc)this.data).getTailX() && ((Arc)this.data).getY() == ((Arc)this.data).getTailY() && (((Arc)this.data).getHeadCutDirection() == ((Arc)this.data).getTailCutDirection() || ((Arc)this.data).getHeadCutDirection() == ((Arc)this.data).getTailCutDirection().opposite());
        float radians = 0.0f;
        if (inline) {
            if (((Arc)this.data).getMidAnchorMode() == Arc.MidAnchorMode.CLOCKWISE) {
                radians = -1.5707964f;
            } else if (((Arc)this.data).getMidAnchorMode() == Arc.MidAnchorMode.COUNTER_CLOCKWISE) {
                radians = 1.5707964f;
            }
        }
        float deg = -((Arc)this.data).getHeadCutDirection().baseAngleDegrees;
        Vector3f midpointRotation = new Vector3f(0.0f, -1.0f, 0.0f).rotateZ(deg * ((float)java.lang.Math.PI / 180) + radians);
        midpoint.add((Vector3fc)midpointRotation.mul(1.2f));
        start.mul((Vector3fc)modifier);
        startC.mul((Vector3fc)modifier);
        midpoint.mul((Vector3fc)modifier);
        endC.mul((Vector3fc)modifier);
        end.mul((Vector3fc)modifier);
        points.add(start);
        points.add(startC);
        points.add(midpoint);
        points.add(endC);
        points.add(end);
        this.basePath = new BezierPath(points);
        this.segments = (int)(start.distance((Vector3fc)end) * 5.0f);
    }

    protected void updateCurve() {
        float beatSpacing = ((Arc)this.data).getNjs() * (60.0f / this.mapController.info.getBpm(((Arc)this.data).getBeat()));
        this.buildBasePath(new Vector3f(1.0f, 1.0f, -beatSpacing));
    }

    @Override
    protected boolean doNoteLook() {
        return false;
    }

    @Override
    protected boolean doNoteGravity() {
        return false;
    }

    @Override
    protected Quaternionf getJumpsRotation(float spawnLifetime) {
        return new Quaternionf();
    }

    @Override
    protected void objectRender(class_4587 matrices, class_4184 camera, AnimationState animationState, float alpha) {
        this.updateCurve();
        Vector3f localPos = matrices.method_23760().method_23761().transformPosition(new Vector3f(0.5f, 0.5f, 0.5f));
        Vector3f camPos = MemoryPool.newVector3f(PhysicalArc.mc.field_1773.method_19418().method_19326());
        localPos.sub((Vector3fc)camPos);
        MemoryPool.release(localPos, camPos);
        this.render(matrices, this.basePath, localPos, ((Arc)this.data).getColor().toARGB());
        if (DebugRenderer.doDebugRendering && DebugRenderer.renderArcDebugLines) {
            DebugRenderer.renderPath(this.basePath, this.segments, ((Arc)this.data).getColor().copy().withAlpha(alpha).toARGB());
        }
    }

    @Override
    protected Vector2f getJumpsXY(float lifetime) {
        float reverseSpawnTime = 1.0f - Math.abs((float)(lifetime - 0.5f)) * 2.0f;
        float jumpTime = Easing.easeOutQuad(reverseSpawnTime);
        Vector2f grid = this.get2DPosition();
        grid.y = Math.lerp((float)(this.doNoteGravity() ? -0.3f : grid.y), (float)grid.y, (float)jumpTime);
        return grid;
    }

    @Override
    public float getJumpOutPosition() {
        float length = ((Arc)this.data).getNjs() * (60.0f / this.mapController.info.getBpm(((Arc)this.data).getBeat()));
        return -(length * (((Arc)this.data).getTailBeat() - ((Arc)this.data).getBeat()));
    }

    @Override
    public float getJumpOutBeat() {
        return ((Arc)this.data).getTailBeat();
    }

    @Override
    public float getDespawnBeat() {
        return ((Arc)this.data).getTailBeat() + ((Arc)this.data).getJumps().halfDuration();
    }

    public void render(class_4587 matrices, ISplinePath path, Vector3f origin, int color) {
        Vector3f o = MemoryPool.newVector3f(origin);
        Vector3f o2 = MemoryPool.newVector3f(origin);
        Quaternionf q = MemoryPool.newQuaternionf();
        Matrix4f m = new Matrix4f((Matrix4fc)matrices.method_23760().method_23761());
        this.mapController.recordArcRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(b, c) -> this._render(m, (class_287)b, path, o, color, q)));
        BeatcraftRenderer.bloomfog.recordBloomCall((TriConsumer<class_287, Vector3f, Quaternionf>)((TriConsumer)(b, c, r) -> this._render(m, (class_287)b, path, o2, color, MemoryPool.newQuaternionf(r))));
    }

    public void _render(Matrix4f transform, class_287 buffer, ISplinePath path, Vector3f origin, int color, Quaternionf cameraRotation) {
        int segments = 35;
        for (int i = 0; i < segments; ++i) {
            float f = (float)i / (float)segments;
            float f2 = (float)(i + 1) / (float)segments;
            Quaternionf q = transform.getUnnormalizedRotation(new Quaternionf());
            Vector3f p = path.evaluate(f).rotate((Quaternionfc)q).add((Vector3fc)origin).rotate((Quaternionfc)cameraRotation);
            Vector3f p2 = path.evaluate(f2).rotate((Quaternionfc)q).add((Vector3fc)origin).rotate((Quaternionfc)cameraRotation);
            Vector3f t = path.getTangent(f).rotate((Quaternionfc)q).rotate((Quaternionfc)cameraRotation);
            Vector3f t2 = path.getTangent(f2).rotate((Quaternionfc)q).rotate((Quaternionfc)cameraRotation);
            Vector3f[] h1 = MathUtil.generateCircle(t, 0.075f, 6, p);
            Vector3f[] h2 = MathUtil.generateCircle(t2, 0.075f, 6, p2);
            Vector3f[] q1 = new Vector3f[]{h1[0], h1[3], h2[3], h2[0]};
            Vector3f[] q2 = new Vector3f[]{h1[1], h1[4], h2[4], h2[1]};
            Vector3f[] q3 = new Vector3f[]{h1[2], h1[5], h2[5], h2[2]};
            float dist = p.length();
            int fade = (int)(java.lang.Math.clamp((12.0f - dist) / 9.0f, 0.0f, 1.0f) * 127.0f) << 24;
            if (fade == 0) continue;
            int col = color + fade;
            buffer.method_60830(q1[0]).method_39415(col);
            buffer.method_60830(q1[1]).method_39415(col);
            buffer.method_60830(q1[2]).method_39415(col);
            buffer.method_60830(q1[0]).method_39415(col);
            buffer.method_60830(q1[2]).method_39415(col);
            buffer.method_60830(q1[3]).method_39415(col);
            buffer.method_60830(q2[0]).method_39415(col);
            buffer.method_60830(q2[1]).method_39415(col);
            buffer.method_60830(q2[2]).method_39415(col);
            buffer.method_60830(q2[0]).method_39415(col);
            buffer.method_60830(q2[2]).method_39415(col);
            buffer.method_60830(q2[3]).method_39415(col);
            buffer.method_60830(q3[0]).method_39415(col);
            buffer.method_60830(q3[1]).method_39415(col);
            buffer.method_60830(q3[2]).method_39415(col);
            buffer.method_60830(q3[0]).method_39415(col);
            buffer.method_60830(q3[2]).method_39415(col);
            buffer.method_60830(q3[3]).method_39415(col);
            MemoryPool.releaseSafe(h1);
            MemoryPool.releaseSafe(h2);
        }
        MemoryPool.releaseSafe(origin);
        MemoryPool.releaseSafe(cameraRotation);
    }

    @Override
    public void seek(float beat) {
        super.seek(beat);
    }
}

