/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.object.physical;

import com.beatcraft.client.animation.AnimationState;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.object.data.BombNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalGameplayObject;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.instancing.BombNoteInstanceData;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.common.memory.MemoryPool;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhysicalBombNote
extends PhysicalGameplayObject<BombNote> {
    private static final Hitbox DOT_GOOD_CUT_BOUNDS = new Hitbox(new Vector3f(-0.4f, -0.4f, -0.75f), new Vector3f(0.4f, 0.4f, 0.25f));
    private static final Hitbox BAD_CUT_BOUNDS = new Hitbox(new Vector3f(-0.175f, -0.175f, -0.175f), new Vector3f(0.175f, 0.175f, 0.175f));

    public PhysicalBombNote(BeatmapController map, BombNote data) {
        super(map, data);
    }

    @Override
    protected void objectRender(class_4587 matrices, class_4184 camera, AnimationState animationState, float alpha) {
        class_4587.class_4665 localPos = matrices.method_23760();
        Vector3f renderPos = localPos.method_23761().getTranslation(MemoryPool.newVector3f());
        Quaternionf renderRotation = localPos.method_23761().getUnnormalizedRotation(MemoryPool.newQuaternionf());
        Vector3f renderScale = localPos.method_23761().getScale(MemoryPool.newVector3f());
        Vector3f c = camera.method_19326().method_46409();
        Matrix4f flipped = new Matrix4f().scale(1.0f, -1.0f, 1.0f);
        flipped.translate(0.0f, c.y * 2.0f, 0.0f);
        flipped.translate((Vector3fc)renderPos);
        flipped.rotate((Quaternionfc)renderRotation);
        flipped.scale((Vector3fc)renderScale);
        MemoryPool.release(renderPos, renderScale);
        MemoryPool.release(renderRotation);
        float dissolve = Math.max((float)this.mapController.logic.globalDissolve, (float)this.getBaseDissolve());
        MeshLoader.BOMB_NOTE_INSTANCED_MESH.draw(BombNoteInstanceData.create(localPos.method_23761(), ((BombNote)this.data).getColor().copy().withAlpha(alpha), dissolve, ((BombNote)this.data).getMapIndex()));
        MeshLoader.MIRROR_BOMB_NOTE_INSTANCED_MESH.draw(BombNoteInstanceData.create(flipped, ((BombNote)this.data).getColor().copy().withAlpha(alpha), dissolve, ((BombNote)this.data).getMapIndex()));
    }

    @Override
    public float getCollisionDistance() {
        return 0.607f;
    }

    @Override
    public Hitbox getBadCutBounds() {
        return BAD_CUT_BOUNDS;
    }

    @Override
    public Hitbox getGoodCutBounds() {
        return DOT_GOOD_CUT_BOUNDS;
    }
}

