/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.beatmap.object.physical;

import com.beatcraft.client.animation.AnimationState;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.CutDirection;
import com.beatcraft.client.beatmap.data.NoteType;
import com.beatcraft.client.beatmap.object.data.ChainNoteHead;
import com.beatcraft.client.beatmap.object.data.ScorableObject;
import com.beatcraft.client.beatmap.object.data.ScoreState;
import com.beatcraft.client.beatmap.object.physical.PhysicalColorNote;
import com.beatcraft.client.beatmap.object.physical.PhysicalGameplayObject;
import com.beatcraft.client.beatmap.object.physical.PhysicalScorableObject;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.instancing.ArrowInstanceData;
import com.beatcraft.client.render.instancing.ColorNoteInstanceData;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.memory.MemoryPool;
import com.beatcraft.common.utils.MathUtil;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PhysicalChainNoteHead
extends PhysicalGameplayObject<ChainNoteHead>
implements PhysicalScorableObject {
    private float baseDegrees;
    public static final Hitbox ACCURATE_HITBOX = new Hitbox(new Vector3f(-0.25f, 0.0f, -0.25f), new Vector3f(0.25f, 0.25f, 0.25f));
    private static final Color WHITE = new Color(-1);

    public PhysicalChainNoteHead(BeatmapController map, ChainNoteHead data) {
        super(map, data);
        this.scoreState = ScoreState.unChecked();
        this.baseDegrees = data.getCutDirection().baseAngleDegrees;
        this.baseDegrees = (this.baseDegrees + data.getAngleOffset()) % 360.0f;
    }

    @Override
    protected void objectRender(class_4587 matrices, class_4184 camera, AnimationState animationState, float alpha) {
        float dissolve;
        class_4587.class_4665 localPos = matrices.method_23760();
        Vector3f renderPos = localPos.method_23761().getTranslation(MemoryPool.newVector3f());
        Quaternionf renderRotation = localPos.method_23761().getUnnormalizedRotation(MemoryPool.newQuaternionf());
        Vector3f renderScale = localPos.method_23761().getScale(MemoryPool.newVector3f());
        Vector3f c = camera.method_19326().method_46409();
        Matrix4f flipped = new Matrix4f().scale(1.0f, -1.0f, 1.0f);
        flipped.translate(0.0f, c.y * 2.0f, 0.0f);
        flipped.translate((Vector3fc)renderPos);
        flipped.rotate((Quaternionfc)renderRotation);
        flipped.scale((Vector3fc)renderScale);
        MemoryPool.release(renderPos, renderScale);
        MemoryPool.release(renderRotation);
        float localDissolve = this.getBaseDissolve();
        if (this.mapController.isModifierActive("Ghost Notes")) {
            if (this.mapController.firstBeat < ((ChainNoteHead)this.data).getBeat()) {
                localDissolve = 1.0f;
            } else {
                float s = this.getJumpInBeat();
                float e = this.getDisappearBeat();
                float t = this.mapController.currentBeat;
                localDissolve = Math.clamp((float)MathUtil.inverseLerp(s, e, t), (float)0.0f, (float)1.0f);
            }
        }
        float localArrowDissolve = this.getArrowDissolve();
        if (this.mapController.isModifierActive("Disappearing Arrows")) {
            float s = this.getSpawnBeat();
            float e = this.getDisappearBeat();
            float t = this.mapController.currentBeat;
            localArrowDissolve = Math.clamp((float)MathUtil.inverseLerp(s, e, t), (float)0.0f, (float)1.0f);
        }
        if (!this.isBaseDissolved()) {
            dissolve = Math.max((float)this.mapController.logic.globalDissolve, (float)localDissolve);
            MeshLoader.CHAIN_HEAD_NOTE_INSTANCED_MESH.draw(ColorNoteInstanceData.create(localPos.method_23761(), ((ChainNoteHead)this.data).getColor().copy().withAlpha(alpha), dissolve, ((ChainNoteHead)this.data).getMapIndex()));
            MeshLoader.MIRROR_CHAIN_HEAD_NOTE_INSTANCED_MESH.draw(ColorNoteInstanceData.create(flipped, ((ChainNoteHead)this.data).getColor().copy().withAlpha(alpha), dissolve, ((ChainNoteHead)this.data).getMapIndex()));
        }
        if (!this.isArrowDissolved()) {
            dissolve = Math.max((float)this.mapController.logic.globalArrowDissolve, (float)localArrowDissolve);
            MeshLoader.NOTE_ARROW_INSTANCED_MESH.draw(ArrowInstanceData.create(localPos.method_23761(), WHITE.copy().withAlpha(alpha), dissolve, ((ChainNoteHead)this.data).getMapIndex()));
            MeshLoader.MIRROR_NOTE_ARROW_INSTANCED_MESH.draw(ArrowInstanceData.create(flipped, WHITE.copy().withAlpha(alpha), dissolve, ((ChainNoteHead)this.data).getMapIndex()));
            MeshLoader.NOTE_ARROW_INSTANCED_MESH.copyDrawToBloom(((ChainNoteHead)this.data).getColor().copy().withAlpha(alpha));
        }
    }

    @Override
    protected boolean doNoteLook() {
        return !((ChainNoteHead)this.data).isNoteLookDisabled();
    }

    @Override
    protected boolean doNoteGravity() {
        return !((ChainNoteHead)this.data).isNoteGravityDisabled();
    }

    public void finalizeBaseRotation() {
        float radians = Math.toRadians((float)this.baseDegrees);
        this.baseRotation = new Quaternionf().rotateZ(radians);
    }

    @Override
    public float getCollisionDistance() {
        return 0.688f;
    }

    @Override
    public Hitbox getGoodCutBounds() {
        return PhysicalColorNote.NORMAL_GOOD_CUT_BOUNDS;
    }

    @Override
    public Hitbox getBadCutBounds() {
        return PhysicalColorNote.BAD_CUT_BOUNDS;
    }

    @Override
    public Hitbox getAccurateHitbox() {
        return ACCURATE_HITBOX;
    }

    @Override
    public ScorableObject score$getData() {
        return (ScorableObject)this.getData();
    }

    @Override
    public void score$setContactColor(NoteType type) {
        this.setContactColor(type);
    }

    @Override
    public void score$setScoreState(ScoreState state) {
        this.setScoreState(state);
    }

    @Override
    public void score$cutNote() {
        this.cutNote();
    }

    @Override
    public ScoreState score$getScoreState() {
        return this.getScoreState();
    }

    @Override
    public int score$getMaxCutPositionScore() {
        return 15;
    }

    @Override
    public int score$getMaxFollowThroughScore() {
        return 30;
    }

    @Override
    public int score$getMaxFollowThroughAngle() {
        return 60;
    }

    @Override
    public int score$getMaxSwingInScore() {
        return 70;
    }

    @Override
    public int score$getMaxSwingInAngle() {
        return 100;
    }

    @Override
    public CutDirection score$getCutDirection() {
        return ((ChainNoteHead)this.data).getCutDirection();
    }

    @Override
    public void score$spawnDebris(Vector3f point, Vector3f normal) {
        this.spawnDebris(point, normal);
    }

    @Override
    public Quaternionf score$getLaneRotation() {
        return this.getLaneRotation();
    }

    @Override
    public InstancedMesh<ColorNoteInstanceData> getMesh() {
        return MeshLoader.CHAIN_HEAD_NOTE_INSTANCED_MESH;
    }
}

