/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.Difficulty;
import com.beatcraft.client.beatmap.data.EventGroup;
import com.beatcraft.client.lightshow.environment.Environment;
import com.beatcraft.client.lightshow.environment.lightgroup.ActionLightGroupV2;
import com.beatcraft.client.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.client.lightshow.event.events.ColorBoostEvent;
import com.beatcraft.client.lightshow.event.events.LightEventV2;
import com.beatcraft.client.lightshow.event.events.ValueEvent;
import com.beatcraft.client.lightshow.event.handlers.ActionEventHandlerV2;
import com.beatcraft.client.lightshow.event.handlers.ColorBoostEventHandler;
import com.beatcraft.client.lightshow.event.handlers.LightGroupEventHandlerV2;
import com.beatcraft.common.utils.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

public abstract class EnvironmentV2
extends Environment {
    private ColorBoostEventHandler colorBoostEventHandler = null;
    private LightGroupEventHandlerV2 leftRotatingLaserLightHandler = null;
    private LightGroupEventHandlerV2 rightRotatingLaserLightHandler = null;
    private ActionEventHandlerV2 leftRotatingLaserValueHandler = null;
    private ActionEventHandlerV2 rightRotatingLaserValueHandler = null;
    private LightGroupEventHandlerV2 backLaserLightHandler = null;
    private LightGroupEventHandlerV2 centerLaserLightHandler = null;
    private LightGroupEventHandlerV2 ringLightHandler = null;
    private ActionEventHandlerV2 ringZoomHandler = null;
    private ActionEventHandlerV2 ringSpinHandler = null;
    private HashMap<EventGroup, LightGroupV2> lightGroups;
    private ArrayList<LightGroupV2> uniqueGroups;

    public EnvironmentV2(BeatmapController map) {
        super(map);
    }

    @Override
    public float getVersion() {
        return 2.0f;
    }

    public void bindLightGroup(EventGroup eventGroup, LightGroupV2 lightGroup) {
        this.lightGroups.put(eventGroup, lightGroup);
        if (!this.uniqueGroups.contains(lightGroup)) {
            this.uniqueGroups.add(lightGroup);
        }
    }

    @Override
    public void setup() {
        this.lightGroups = new HashMap();
        this.uniqueGroups = new ArrayList();
        LightGroupV2 leftLasers = this.setupLeftLasers();
        this.bindLightGroup(EventGroup.LEFT_LASERS, leftLasers);
        this.bindLightGroup(EventGroup.LEFT_ROTATING_LASERS, leftLasers);
        LightGroupV2 rightLasers = this.setupRightLasers();
        this.bindLightGroup(EventGroup.RIGHT_LASERS, rightLasers);
        this.bindLightGroup(EventGroup.RIGHT_ROTATING_LASERS, rightLasers);
        LightGroupV2 backLasers = this.setupBackLasers();
        this.bindLightGroup(EventGroup.BACK_LASERS, backLasers);
        LightGroupV2 centerLasers = this.setupCenterLasers();
        this.bindLightGroup(EventGroup.CENTER_LASERS, centerLasers);
        LightGroupV2 ringLights = this.setupRingLights();
        this.bindLightGroup(EventGroup.RING_LIGHTS, ringLights);
        this.bindLightGroup(EventGroup.RING_SPIN, ringLights);
        this.bindLightGroup(EventGroup.RING_ZOOM, ringLights);
    }

    protected abstract LightGroupV2 setupLeftLasers();

    protected abstract LightGroupV2 setupRightLasers();

    protected abstract LightGroupV2 setupBackLasers();

    protected abstract LightGroupV2 setupCenterLasers();

    protected abstract LightGroupV2 setupRingLights();

    @Override
    public void loadLightshow(Difficulty difficulty, JsonObject json) {
        if (json.has("_events")) {
            this.loadV2(difficulty, json);
        } else if (json.has("basicBeatmapEvents")) {
            this.loadV3(difficulty, json);
        } else if (json.has("basicEvents")) {
            this.loadV4(difficulty, json);
        }
    }

    private void loadV2(Difficulty difficulty, JsonObject json) {
        JsonArray events = json.getAsJsonArray("_events");
        ArrayList<LightEventV2> lrlEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> rrlEvents = new ArrayList<LightEventV2>();
        ArrayList<ValueEvent> lrrEvents = new ArrayList<ValueEvent>();
        ArrayList<ValueEvent> rrrEvents = new ArrayList<ValueEvent>();
        ArrayList<LightEventV2> backEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> centerEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> rlEvents = new ArrayList<LightEventV2>();
        ArrayList<ValueEvent> rlsEvents = new ArrayList<ValueEvent>();
        ArrayList<ValueEvent> rlzEvents = new ArrayList<ValueEvent>();
        ArrayList<ColorBoostEvent> boostEvents = new ArrayList<ColorBoostEvent>();
        boostEvents.add(new ColorBoostEvent(0.0f, false));
        events.forEach(o -> {
            EventGroup group;
            JsonObject obj = o.getAsJsonObject();
            int eventType = obj.get("_type").getAsInt();
            if (eventType == 5) {
                boostEvents.add(new ColorBoostEvent().loadV2(obj, difficulty));
                return;
            }
            EventGroup selector0$temp = group = EventGroup.fromType(eventType);
            int index$1 = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LEFT_LASERS", "RIGHT_LASERS", "LEFT_ROTATING_LASERS", "RIGHT_ROTATING_LASERS", "BACK_LASERS", "CENTER_LASERS", "RING_LIGHTS", "RING_SPIN", "RING_ZOOM"}, (EventGroup)selector0$temp, index$1)) {
                case 0: {
                    lrlEvents.add(new LightEventV2().loadV2(obj, difficulty));
                    break;
                }
                case 1: {
                    rrlEvents.add(new LightEventV2().loadV2(obj, difficulty));
                    break;
                }
                case 2: {
                    lrrEvents.add(new ValueEvent().loadV2(obj, difficulty));
                    break;
                }
                case 3: {
                    rrrEvents.add(new ValueEvent().loadV2(obj, difficulty));
                    break;
                }
                case 4: {
                    backEvents.add(new LightEventV2().loadV2(obj, difficulty));
                    break;
                }
                case 5: {
                    centerEvents.add(new LightEventV2().loadV2(obj, difficulty));
                    break;
                }
                case 6: {
                    rlEvents.add(new LightEventV2().loadV2(obj, difficulty));
                    break;
                }
                case 7: {
                    rlsEvents.add(new ValueEvent().loadV2(obj, difficulty));
                    break;
                }
                case 8: {
                    rlzEvents.add(new ValueEvent().loadV2(obj, difficulty));
                    break;
                }
            }
        });
        boostEvents.sort(Difficulty::compareObjects);
        lrlEvents.sort(Difficulty::compareObjects);
        rrlEvents.sort(Difficulty::compareObjects);
        lrrEvents.sort(Difficulty::compareObjects);
        rrrEvents.sort(Difficulty::compareObjects);
        backEvents.sort(Difficulty::compareObjects);
        centerEvents.sort(Difficulty::compareObjects);
        rlEvents.sort(Difficulty::compareObjects);
        rlsEvents.sort(Difficulty::compareObjects);
        rlzEvents.sort(Difficulty::compareObjects);
        this.leftRotatingLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.LEFT_LASERS), lrlEvents);
        this.rightRotatingLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.RIGHT_LASERS), rrlEvents);
        this.leftRotatingLaserValueHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.LEFT_ROTATING_LASERS), lrrEvents, EventGroup.LEFT_ROTATING_LASERS);
        this.rightRotatingLaserValueHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RIGHT_ROTATING_LASERS), rrrEvents, EventGroup.RIGHT_ROTATING_LASERS);
        this.backLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.BACK_LASERS), backEvents);
        this.centerLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.CENTER_LASERS), centerEvents);
        this.ringLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.RING_LIGHTS), rlEvents);
        this.ringSpinHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RING_SPIN), rlsEvents, EventGroup.RING_SPIN);
        this.ringZoomHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RING_ZOOM), rlzEvents, EventGroup.RING_ZOOM);
        this.colorBoostEventHandler = new ColorBoostEventHandler(this.mapController, boostEvents);
    }

    private void loadV3(Difficulty difficulty, JsonObject json) {
        JsonArray events = json.getAsJsonArray("basicBeatmapEvents");
        JsonArray rawBoostEvents = json.getAsJsonArray("colorBoostBeatmapEvents");
        ArrayList<LightEventV2> lrlEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> rrlEvents = new ArrayList<LightEventV2>();
        ArrayList<ValueEvent> lrrEvents = new ArrayList<ValueEvent>();
        ArrayList<ValueEvent> rrrEvents = new ArrayList<ValueEvent>();
        ArrayList<LightEventV2> backEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> centerEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> rlEvents = new ArrayList<LightEventV2>();
        ArrayList<ValueEvent> rlsEvents = new ArrayList<ValueEvent>();
        ArrayList<ValueEvent> rlzEvents = new ArrayList<ValueEvent>();
        ArrayList<ColorBoostEvent> boostEvents = new ArrayList<ColorBoostEvent>();
        boostEvents.add(new ColorBoostEvent(0.0f, false));
        rawBoostEvents.forEach(rawEvent -> {
            JsonObject eventData = rawEvent.getAsJsonObject();
            boostEvents.add(new ColorBoostEvent().loadV3(eventData, difficulty));
        });
        events.forEach(o -> {
            EventGroup group;
            JsonObject obj = o.getAsJsonObject();
            EventGroup selector0$temp = group = EventGroup.fromType(obj.get("et").getAsInt());
            int index$1 = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LEFT_LASERS", "RIGHT_LASERS", "LEFT_ROTATING_LASERS", "RIGHT_ROTATING_LASERS", "BACK_LASERS", "CENTER_LASERS", "RING_LIGHTS", "RING_SPIN", "RING_ZOOM"}, (EventGroup)selector0$temp, index$1)) {
                case 0: {
                    lrlEvents.add(new LightEventV2().loadV3(obj, difficulty));
                    break;
                }
                case 1: {
                    rrlEvents.add(new LightEventV2().loadV3(obj, difficulty));
                    break;
                }
                case 2: {
                    lrrEvents.add(new ValueEvent().loadV3(obj, difficulty));
                    break;
                }
                case 3: {
                    rrrEvents.add(new ValueEvent().loadV3(obj, difficulty));
                    break;
                }
                case 4: {
                    backEvents.add(new LightEventV2().loadV3(obj, difficulty));
                    break;
                }
                case 5: {
                    centerEvents.add(new LightEventV2().loadV3(obj, difficulty));
                    break;
                }
                case 6: {
                    rlEvents.add(new LightEventV2().loadV3(obj, difficulty));
                    break;
                }
                case 7: {
                    rlsEvents.add(new ValueEvent().loadV3(obj, difficulty));
                    break;
                }
                case 8: {
                    rlzEvents.add(new ValueEvent().loadV3(obj, difficulty));
                    break;
                }
            }
        });
        lrlEvents.sort(Difficulty::compareObjects);
        rrlEvents.sort(Difficulty::compareObjects);
        lrrEvents.sort(Difficulty::compareObjects);
        rrrEvents.sort(Difficulty::compareObjects);
        backEvents.sort(Difficulty::compareObjects);
        centerEvents.sort(Difficulty::compareObjects);
        rlEvents.sort(Difficulty::compareObjects);
        rlsEvents.sort(Difficulty::compareObjects);
        rlzEvents.sort(Difficulty::compareObjects);
        boostEvents.sort(Difficulty::compareObjects);
        this.leftRotatingLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.LEFT_LASERS), lrlEvents);
        this.rightRotatingLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.RIGHT_LASERS), rrlEvents);
        this.leftRotatingLaserValueHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.LEFT_ROTATING_LASERS), lrrEvents, EventGroup.LEFT_ROTATING_LASERS);
        this.rightRotatingLaserValueHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RIGHT_ROTATING_LASERS), rrrEvents, EventGroup.RIGHT_ROTATING_LASERS);
        this.backLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.BACK_LASERS), backEvents);
        this.centerLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.CENTER_LASERS), centerEvents);
        this.ringLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.RING_LIGHTS), rlEvents);
        this.ringSpinHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RING_SPIN), rlsEvents, EventGroup.RING_SPIN);
        this.ringZoomHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RING_ZOOM), rlzEvents, EventGroup.RING_ZOOM);
        this.colorBoostEventHandler = new ColorBoostEventHandler(this.mapController, boostEvents);
    }

    private void loadV4(Difficulty difficulty, JsonObject json) {
        JsonArray events = json.getAsJsonArray("basicEvents");
        JsonArray eventsData = json.getAsJsonArray("basicEventsData");
        JsonArray rawBoostEvents = json.getAsJsonArray("colorBoostEvents");
        JsonArray rawBoostEventsData = json.getAsJsonArray("colorBoostEventsData");
        ArrayList<LightEventV2> lrlEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> rrlEvents = new ArrayList<LightEventV2>();
        ArrayList<ValueEvent> lrrEvents = new ArrayList<ValueEvent>();
        ArrayList<ValueEvent> rrrEvents = new ArrayList<ValueEvent>();
        ArrayList<LightEventV2> backEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> centerEvents = new ArrayList<LightEventV2>();
        ArrayList<LightEventV2> rlEvents = new ArrayList<LightEventV2>();
        ArrayList<ValueEvent> rlsEvents = new ArrayList<ValueEvent>();
        ArrayList<ValueEvent> rlzEvents = new ArrayList<ValueEvent>();
        ArrayList<ColorBoostEvent> boostEvents = new ArrayList<ColorBoostEvent>();
        boostEvents.add(new ColorBoostEvent(0.0f, false));
        rawBoostEvents.forEach(rawEvent -> {
            JsonObject obj = rawEvent.getAsJsonObject();
            boostEvents.add(new ColorBoostEvent().loadV4(obj, rawBoostEventsData, difficulty));
        });
        events.forEach(o -> {
            EventGroup group;
            JsonObject obj = o.getAsJsonObject();
            int index = JsonUtil.getOrDefault(obj, "i", JsonElement::getAsInt, Integer.valueOf(0));
            JsonObject data = eventsData.get(index).getAsJsonObject();
            EventGroup selector0$temp = group = EventGroup.fromType(JsonUtil.getOrDefault(data, "t", JsonElement::getAsInt, Integer.valueOf(0)));
            int index$1 = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LEFT_LASERS", "RIGHT_LASERS", "LEFT_ROTATING_LASERS", "RIGHT_ROTATING_LASERS", "BACK_LASERS", "CENTER_LASERS", "RING_LIGHTS", "RING_SPIN", "RING_ZOOM"}, (EventGroup)selector0$temp, index$1)) {
                case 0: {
                    lrlEvents.add(new LightEventV2().loadV4(obj, data, difficulty));
                    break;
                }
                case 1: {
                    rrlEvents.add(new LightEventV2().loadV4(obj, data, difficulty));
                    break;
                }
                case 2: {
                    lrrEvents.add(new ValueEvent().loadV4(obj, data, difficulty));
                    break;
                }
                case 3: {
                    rrrEvents.add(new ValueEvent().loadV4(obj, data, difficulty));
                    break;
                }
                case 4: {
                    backEvents.add(new LightEventV2().loadV4(obj, data, difficulty));
                    break;
                }
                case 5: {
                    centerEvents.add(new LightEventV2().loadV4(obj, data, difficulty));
                    break;
                }
                case 6: {
                    rlEvents.add(new LightEventV2().loadV4(obj, data, difficulty));
                    break;
                }
                case 7: {
                    rlsEvents.add(new ValueEvent().loadV4(obj, data, difficulty));
                    break;
                }
                case 8: {
                    rlzEvents.add(new ValueEvent().loadV4(obj, data, difficulty));
                    break;
                }
            }
        });
        lrlEvents.sort(Difficulty::compareObjects);
        rrlEvents.sort(Difficulty::compareObjects);
        lrrEvents.sort(Difficulty::compareObjects);
        rrrEvents.sort(Difficulty::compareObjects);
        backEvents.sort(Difficulty::compareObjects);
        centerEvents.sort(Difficulty::compareObjects);
        rlEvents.sort(Difficulty::compareObjects);
        rlsEvents.sort(Difficulty::compareObjects);
        rlzEvents.sort(Difficulty::compareObjects);
        boostEvents.sort(Difficulty::compareObjects);
        this.leftRotatingLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.LEFT_LASERS), lrlEvents);
        this.rightRotatingLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.RIGHT_LASERS), rrlEvents);
        this.leftRotatingLaserValueHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.LEFT_ROTATING_LASERS), lrrEvents, EventGroup.LEFT_ROTATING_LASERS);
        this.rightRotatingLaserValueHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RIGHT_ROTATING_LASERS), rrrEvents, EventGroup.RIGHT_ROTATING_LASERS);
        this.backLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.BACK_LASERS), backEvents);
        this.centerLaserLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.CENTER_LASERS), centerEvents);
        this.ringLightHandler = new LightGroupEventHandlerV2(this.lightGroups.get((Object)EventGroup.RING_LIGHTS), rlEvents);
        this.ringSpinHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RING_SPIN), rlsEvents, EventGroup.RING_SPIN);
        this.ringZoomHandler = new ActionEventHandlerV2((ActionLightGroupV2)this.lightGroups.get((Object)EventGroup.RING_ZOOM), rlzEvents, EventGroup.RING_ZOOM);
        this.colorBoostEventHandler = new ColorBoostEventHandler(this.mapController, boostEvents);
    }

    @Override
    public void seek(float beat) {
        if (this.leftRotatingLaserLightHandler == null) {
            return;
        }
        this.leftRotatingLaserLightHandler.seek(beat);
        this.rightRotatingLaserLightHandler.seek(beat);
        this.leftRotatingLaserValueHandler.seek(beat);
        this.rightRotatingLaserValueHandler.seek(beat);
        this.backLaserLightHandler.seek(beat);
        this.centerLaserLightHandler.seek(beat);
        this.ringLightHandler.seek(beat);
        this.ringSpinHandler.seek(beat);
        this.ringZoomHandler.seek(beat);
        this.colorBoostEventHandler.seek(beat);
    }

    @Override
    public void update(float beat, double deltaTime) {
        super.update(beat, deltaTime);
        this.leftRotatingLaserLightHandler.update(beat);
        this.rightRotatingLaserLightHandler.update(beat);
        this.leftRotatingLaserValueHandler.update(beat);
        this.rightRotatingLaserValueHandler.update(beat);
        this.backLaserLightHandler.update(beat);
        this.centerLaserLightHandler.update(beat);
        this.ringLightHandler.update(beat);
        this.ringSpinHandler.update(beat);
        this.ringZoomHandler.update(beat);
        this.colorBoostEventHandler.update(beat);
        for (LightGroupV2 group : this.uniqueGroups) {
            group.update(beat, deltaTime);
        }
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera, float alpha) {
        super.render(matrices, camera, alpha);
        this.uniqueGroups.forEach(v -> v.render(matrices, camera, alpha));
    }

    @Override
    public Environment reset() {
        if (this.leftRotatingLaserLightHandler == null) {
            return this;
        }
        this.leftRotatingLaserLightHandler.reset();
        this.rightRotatingLaserLightHandler.reset();
        this.leftRotatingLaserValueHandler.reset();
        this.rightRotatingLaserValueHandler.reset();
        this.backLaserLightHandler.reset();
        this.centerLaserLightHandler.reset();
        this.ringLightHandler.reset();
        this.ringSpinHandler.reset();
        this.ringZoomHandler.reset();
        this.colorBoostEventHandler.reset();
        return this;
    }
}

