/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.kaleidoscope;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.lightshow.environment.EnvironmentV2;
import com.beatcraft.client.lightshow.environment.kaleidoscope.KaleidoscopeRingLights;
import com.beatcraft.client.lightshow.environment.kaleidoscope.RingSpike;
import com.beatcraft.client.lightshow.environment.lightgroup.LightGroupV2;
import com.beatcraft.client.lightshow.environment.lightgroup.RotatingLightsGroup;
import com.beatcraft.client.lightshow.environment.lightgroup.StaticLightsGroup;
import com.beatcraft.client.lightshow.lights.LightObject;
import java.util.HashMap;

public class KaleidoscopeEnvironment
extends EnvironmentV2 {
    private KaleidoscopeRingLights ringLights;
    HashMap<Integer, LightObject> middle;
    HashMap<Integer, LightObject> left;
    HashMap<Integer, LightObject> right;
    HashMap<Integer, LightObject> back;
    private static final float[] FOG_HEIGHTS = new float[]{-28.0f, -8.0f};

    public KaleidoscopeEnvironment(BeatmapController map) {
        super(map);
    }

    @Override
    public String getID() {
        return "KaleidoscopeEnvironment";
    }

    @Override
    public void setup() {
        this.ringLights = new KaleidoscopeRingLights(this.mapController);
        this.middle = new HashMap();
        this.left = new HashMap();
        this.right = new HashMap();
        this.back = new HashMap();
        int mi = 1;
        int li = 1;
        int ri = 1;
        int bi = 1;
        for (int i = 1; i < 40; i += 2) {
            RingSpike baseLight = (RingSpike)this.ringLights.lights.get(i);
            LightObject[] controllers = baseLight.getControllers();
            this.ringLights.lights.put(i + 1, controllers[0]);
            this.middle.put(mi++, controllers[1]);
            this.middle.put(mi++, controllers[2]);
            this.left.put(li++, controllers[3]);
            this.right.put(ri++, controllers[4]);
            this.back.put(bi++, controllers[5]);
            this.back.put(bi++, controllers[6]);
        }
        super.setup();
    }

    @Override
    protected LightGroupV2 setupLeftLasers() {
        return new RotatingLightsGroup(this.mapController, new HashMap<Integer, LightObject>(), this.left);
    }

    @Override
    protected LightGroupV2 setupRightLasers() {
        return new RotatingLightsGroup(this.mapController, new HashMap<Integer, LightObject>(), this.right);
    }

    @Override
    protected LightGroupV2 setupBackLasers() {
        return new StaticLightsGroup(this.mapController, this.back);
    }

    @Override
    protected LightGroupV2 setupCenterLasers() {
        return new StaticLightsGroup(this.mapController, this.middle);
    }

    @Override
    protected LightGroupV2 setupRingLights() {
        return this.ringLights;
    }

    @Override
    public float[] getFogHeights() {
        return FOG_HEIGHTS;
    }
}

