/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.environment.kaleidoscope;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.beatmap.data.EventGroup;
import com.beatcraft.client.lightshow.environment.kaleidoscope.DistantLight;
import com.beatcraft.client.lightshow.environment.kaleidoscope.RingSpike;
import com.beatcraft.client.lightshow.environment.lightgroup.ActionLightGroupV2;
import com.beatcraft.client.lightshow.event.events.ValueEvent;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.ring_lights.RingLightHandler;
import com.beatcraft.client.render.BeatcraftRenderer;
import java.util.HashMap;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.commons.lang3.function.TriFunction;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class KaleidoscopeRingLights
extends ActionLightGroupV2 {
    private static final float DISTANT_Z = 50.0f;
    private static final float DISTANT_Y = 0.0f;
    private static final float SPIKES_Z = 9.0f;
    private static final float SPIKES_Y = 1.0f;
    private final RingLightHandler innerRing;
    private final RingLightHandler outerRing;
    private int linkInnerIndex = 1;
    private int fetchIndex = 1;

    protected static HashMap<Integer, LightObject> buildRingLights(BeatmapController beatmap) {
        HashMap<Integer, LightObject> map = new HashMap<Integer, LightObject>();
        Vector3f pos = new Vector3f(0.0f, 0.0f, 8.0f);
        RingSpike.clearInstances();
        for (int i = 1; i < 40; i += 2) {
            try {
                map.put(i, new RingSpike(beatmap, new Vector3f((Vector3fc)pos), new Quaternionf()));
                pos.add(0.0f, 0.0f, 5.0f);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    public KaleidoscopeRingLights(BeatmapController map) {
        super(map, KaleidoscopeRingLights.buildRingLights(map));
        this.innerRing = new RingLightHandler(map, this::createInner, (TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>)((TriFunction)this::linkInner), 20, new Vector3f(0.0f, 0.0f, 12.0f), 5.0f);
        this.outerRing = new RingLightHandler(map, this::createOuter, (TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject>)((TriFunction)this::linkOuter), 10, new Vector3f(), 0.0f);
        float rpd = (float)Math.PI / 180;
        this.innerRing.jumpOffsets = new float[]{-90.0f * rpd, 90.0f * rpd};
        this.innerRing.rotationOffsets = new float[]{0.0f, 1.0f * rpd, -1.0f * rpd, 2.0f * rpd, -2.0f * rpd, 5.0f * rpd, -5.0f * rpd, 10.0f * rpd, -10.0f * rpd, 12.5f * rpd, -12.5f * rpd, 15.0f * rpd, -15.0f * rpd, 20.0f * rpd, -20.0f * rpd, 22.5f * rpd, -22.5f * rpd, 25.0f * rpd, -25.0f * rpd};
        this.outerRing.jumpOffsets = new float[]{-90.0f * rpd, 90.0f * rpd};
        this.outerRing.rotationOffsets = new float[]{0.0f, 1.0f * rpd, 2.0f * rpd, 3.0f * rpd, 4.0f * rpd, 5.0f * rpd, -1.0f * rpd, -2.0f * rpd, -3.0f * rpd, -4.0f * rpd, -5.0f * rpd};
        this.innerRing.spinTo(0.0f, 22.5f * rpd, 0.0f, 0.0f);
    }

    private LightObject linkInner(BeatmapController map, Vector3f pos, Quaternionf ori) {
        LightObject light = (LightObject)this.lights.get(this.linkInnerIndex);
        this.linkInnerIndex += 2;
        light.setPosition(pos);
        light.setRotation(ori);
        return light;
    }

    private LightObject linkOuter(BeatmapController map, Vector3f pos, Quaternionf ori) {
        return new DistantLight(this.mapController, pos, ori);
    }

    private LightObject createInner(TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject> f) {
        LightObject light = (LightObject)this.lights.get(this.fetchIndex);
        this.fetchIndex += 2;
        return light;
    }

    private LightObject createOuter(TriFunction<BeatmapController, Vector3f, Quaternionf, LightObject> f) {
        return (LightObject)f.apply((Object)this.mapController, (Object)new Vector3f(0.0f, 0.0f, 50.0f), (Object)new Quaternionf());
    }

    @Override
    public void handleEvent(ValueEvent event, EventGroup eventGroup) {
        switch (eventGroup) {
            case RING_SPIN: {
                this.handleRingSpin();
                break;
            }
            case RING_ZOOM: {
                this.handleRingZoom();
            }
        }
    }

    private void handleRingSpin() {
        this.innerRing.spinRandom();
        this.outerRing.spinRandom();
    }

    private void handleRingZoom() {
        this.innerRing.setZoom((double)this.innerRing.getZoom() >= 0.99 ? 0.3f : 1.0f);
    }

    @Override
    public void update(float beat, double deltaTime) {
        float t = this.mapController.currentSeconds;
        this.innerRing.update(t);
        this.outerRing.update(t);
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera, float alpha) {
        this.innerRing.render(matrices, camera, alpha, BeatcraftRenderer.bloomfog);
        this.outerRing.render(matrices, camera, alpha, BeatcraftRenderer.bloomfog);
    }
}

