/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.lightshow.lights;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.lightshow.lights.CompoundTransformState;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.lightshow.lights.TransformState;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.common.data.types.Color;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.commons.lang3.function.TriFunction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class LightObject {
    protected final BeatmapController mapController;
    protected Vector3f position = new Vector3f();
    protected Quaternionf orientation = new Quaternionf();
    protected Vector3f offset = new Vector3f();
    protected Quaternionf rotation = new Quaternionf();
    protected Quaternionf rotation2 = new Quaternionf();
    protected Quaternionf worldRotation = new Quaternionf();
    protected LightState lightState = new LightState(new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f);
    protected CompoundTransformState transformState = new CompoundTransformState();
    protected CompoundTransformState.Swizzle translationSwizzle = CompoundTransformState.Swizzle.XYZ;
    protected CompoundTransformState.Swizzle rotationSwizzle = CompoundTransformState.Swizzle.XYZ;
    protected TriFunction<Float, Float, Float, Quaternionf> quaternionBuilder = (x, y, z) -> new Quaternionf().rotationYXZ(y.floatValue(), x.floatValue(), z.floatValue());
    protected CompoundTransformState.Polarity translationPolarity = CompoundTransformState.Polarity.PPP;
    protected CompoundTransformState.Polarity rotationPolarity = CompoundTransformState.Polarity.PPP;

    public LightObject(BeatmapController map) {
        this.mapController = map;
    }

    public LightObject withTranslationSwizzle(CompoundTransformState.Swizzle swizzle, CompoundTransformState.Polarity polarity) {
        this.translationSwizzle = swizzle;
        this.translationPolarity = polarity;
        return this;
    }

    public LightObject withRotationSwizzle(CompoundTransformState.Swizzle swizzle, CompoundTransformState.Polarity polarity, TriFunction<Float, Float, Float, Quaternionf> quaternionBuilder) {
        this.rotationSwizzle = swizzle;
        this.rotationPolarity = polarity;
        this.quaternionBuilder = quaternionBuilder;
        return this;
    }

    public LightObject withRotationSwizzle(CompoundTransformState.Swizzle swizzle, CompoundTransformState.Polarity polarity) {
        this.rotationSwizzle = swizzle;
        this.rotationPolarity = polarity;
        return this;
    }

    protected Quaternionf mirrorQuaternion(boolean mirror, Quaternionf quat) {
        return mirror ? new Quaternionf(-quat.x, quat.y, -quat.z, quat.w) : quat;
    }

    public Matrix4f createTransformMatrix(Matrix4f worldPos, boolean mirrorDraw, Quaternionf orientation, Quaternionf rotation, CompoundTransformState transformState, Vector3f position, Quaternionf worldRotation, Vector3f offset, Vector3f cameraPos) {
        Matrix4f matrix = new Matrix4f().identity();
        matrix.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        matrix.mul((Matrix4fc)worldPos);
        Vector3f transformTranslation = new Vector3f();
        transformState.getTranslation(this.translationSwizzle, this.translationPolarity, transformTranslation);
        matrix.translate(transformTranslation.x, mirrorDraw ? -transformTranslation.y : transformTranslation.y, transformTranslation.z);
        matrix.translate(offset.x, mirrorDraw ? -offset.y : offset.y, offset.z);
        matrix.rotate((Quaternionfc)this.mirrorQuaternion(mirrorDraw, worldRotation));
        matrix.translate(position.x, mirrorDraw ? -position.y : position.y, position.z);
        matrix.rotate((Quaternionfc)this.mirrorQuaternion(mirrorDraw, this.rotation2));
        matrix.rotate((Quaternionfc)this.mirrorQuaternion(mirrorDraw, rotation));
        matrix.rotate((Quaternionfc)this.mirrorQuaternion(mirrorDraw, transformState.getOrientation(this.rotationSwizzle, this.rotationPolarity, this.quaternionBuilder)));
        matrix.rotate((Quaternionfc)this.mirrorQuaternion(mirrorDraw, orientation));
        return matrix;
    }

    public abstract LightObject cloneOffset(Vector3f var1);

    public abstract void render(class_4587 var1, class_4184 var2, float var3, Bloomfog var4);

    public abstract void setBrightness(float var1);

    public abstract void setColor(int var1);

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public void setOrientation(Quaternionf orientation) {
        this.orientation = orientation;
    }

    public void setOffset(Vector3f offset) {
        this.offset = offset;
    }

    public void setRotation(Quaternionf rotation) {
        this.rotation = rotation;
    }

    public void setRotation2(Quaternionf rotation) {
        this.rotation2 = rotation;
    }

    public void setWorldRotation(Quaternionf rotation) {
        this.worldRotation = rotation;
    }

    public Quaternionf getWorldRotation() {
        return this.worldRotation;
    }

    public void addRotation(Quaternionf rotation) {
        this.rotation.mul((Quaternionfc)rotation);
    }

    public void setLightState(LightState state) {
        this.lightState.setColor(new Color(state.getColor()));
        this.lightState.setBrightness(state.getBrightness());
    }

    public void setTransformState(TransformState state) {
        this.transformState.updateState(state);
    }

    public LightState getLightState() {
        return this.lightState;
    }

    public Vector3f getPos() {
        Vector3f v = new Vector3f();
        this.transformState.getTranslation(this.translationSwizzle, this.translationPolarity, v);
        return new Vector3f((Vector3fc)this.position).rotate((Quaternionfc)this.rotation).rotate((Quaternionfc)this.transformState.getOrientation(this.rotationSwizzle, this.rotationPolarity, this.quaternionBuilder)).add((Vector3fc)this.offset).add((Vector3fc)v);
    }

    public void resetState() {
        this.lightState.reset();
        this.transformState.reset();
    }
}

