/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.menu;

import com.beatcraft.Beatcraft;
import com.beatcraft.common.data.map.SongData;
import com.beatcraft.common.data.map.SongDownloader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;

public class SongList {
    private final ArrayList<SongData> songs = new ArrayList();

    public List<SongData> getSongs() {
        return this.songs;
    }

    public List<SongData> getFiltered(String searchFilter) {
        ArrayList<SongData> list = new ArrayList<SongData>();
        for (SongData data : this.songs) {
            if (!data.getTitle().contains(searchFilter) && !data.getSubtitle().contains(searchFilter) && !data.getAuthor().contains(searchFilter)) continue;
            list.add(data);
        }
        return list;
    }

    public SongData getById(String id) {
        for (SongData data : this.songs) {
            if (!id.equals(data.getId())) continue;
            return data;
        }
        return null;
    }

    public void loadSongs() {
        String beatmapFolder = String.valueOf(class_310.method_1551().field_1697.toPath()) + "/beatmaps/";
        File folder = new File(beatmapFolder);
        if (!folder.exists() && !folder.mkdirs()) {
            Beatcraft.LOGGER.error("Failed to create beatmaps folder");
            return;
        }
        File[] subfolders = folder.listFiles(File::isDirectory);
        if (subfolders == null) {
            Beatcraft.LOGGER.error("Failed to load beatmaps");
            return;
        }
        this.songs.clear();
        for (File songFolder : subfolders) {
            try {
                SongData data = new SongData(songFolder.getAbsolutePath());
                this.songs.add(data);
                SongDownloader.convertAllToPng(songFolder.getAbsolutePath());
            }
            catch (IOException e) {
                Beatcraft.LOGGER.error("Failed to load beatmap ", (Throwable)e);
            }
        }
    }
}

