/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render;

import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.render.DebugRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.effect.SaberRenderer;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.client.render.particle.BeatcraftParticleRenderer;
import com.beatcraft.common.memory.MemoryPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.vivecraft.client_vr.ClientDataHolderVR;

public class BeatcraftRenderer {
    public static Bloomfog bloomfog;
    public static class_5944 noteShader;
    public static class_5944 arrowShader;
    public static class_5944 heartHealthShader;
    public static class_5944 BCPosTexColShader;
    private static final ArrayList<Runnable> saberRenderCalls;

    public static void init() {
        bloomfog = Bloomfog.create();
        try {
            noteShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "note_shader", class_290.field_1575);
            arrowShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "arrow_shader", class_290.field_1575);
            heartHealthShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "health_hearts", class_290.field_1575);
            BCPosTexColShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "bc_tex_col", class_290.field_1575);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void renderSky(class_4184 camera, float tickDelta) {
        if (ClientDataHolderVR.getInstance().isFirstPass || ClientDataHolderVR.getInstance().vr == null || !ClientDataHolderVR.getInstance().vr.isActive()) {
            BeatcraftClient.updatePlayerSabers(tickDelta);
            BeatmapManager.updateMaps();
        }
    }

    public static void renderBloomfog(float tickDelta) {
        bloomfog.render(false, tickDelta);
    }

    public static void renderMirror() {
    }

    public static void renderHUD(class_4597 imm) {
        BeatmapManager.renderHUDs(imm);
    }

    public static void renderBeatmap(class_4184 camera) {
        BeatmapManager.preRenderMaps();
        Vector3f cameraPos = camera.method_19326().method_46409();
        MeshLoader.COLOR_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.CHAIN_HEAD_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.CHAIN_LINK_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.BOMB_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.NOTE_ARROW_INSTANCED_MESH.render(cameraPos);
        MeshLoader.NOTE_DOT_INSTANCED_MESH.render(cameraPos);
        MeshLoader.CHAIN_DOT_INSTANCED_MESH.render(cameraPos);
        MeshLoader.HEADSET_INSTANCED_MESH.render(cameraPos);
        BeatmapManager.renderMaps();
    }

    public static void renderParticles() {
        BeatcraftParticleRenderer.renderParticles();
    }

    public static void renderDebug(Vector3f cameraPos) {
        if (BeatcraftClient.playerConfig.debug.beatmap.renderBeatmapPosition()) {
            MeshLoader.MATRIX_LOCATOR_MESH.render(cameraPos);
        } else {
            MeshLoader.MATRIX_LOCATOR_MESH.cancelDraws();
        }
        DebugRenderer.render();
    }

    public static void recordSaberRenderCall(Runnable call) {
        saberRenderCalls.add(call);
    }

    public static void renderSabers() {
        for (Runnable call : saberRenderCalls) {
            call.run();
        }
        saberRenderCalls.clear();
        SaberRenderer.renderAll();
    }

    public static void renderSmoke() {
    }

    public static void renderBloom() {
        bloomfog.renderBloom();
    }

    public static List<Vector3f[]> getGlowingQuadAsTris(Vector2f quadSize, float glowSpread) {
        ArrayList<Vector3f[]> tris = new ArrayList<Vector3f[]>();
        float halfWidth = quadSize.x / 2.0f;
        float halfHeight = quadSize.y / 2.0f;
        float outerHalfWidth = halfWidth + glowSpread;
        float outerHalfHeight = halfHeight + glowSpread;
        Vector3f topLeftOuter = new Vector3f(-outerHalfWidth, outerHalfHeight, 0.0f);
        Vector3f topRightOuter = new Vector3f(outerHalfWidth, outerHalfHeight, 0.0f);
        Vector3f bottomLeftOuter = new Vector3f(-outerHalfWidth, -outerHalfHeight, 0.0f);
        Vector3f bottomRightOuter = new Vector3f(outerHalfWidth, -outerHalfHeight, 0.0f);
        Vector3f topLeftInner = new Vector3f(-halfWidth, halfHeight, 1.0f);
        Vector3f topRightInner = new Vector3f(halfWidth, halfHeight, 1.0f);
        Vector3f bottomLeftInner = new Vector3f(-halfWidth, -halfHeight, 1.0f);
        Vector3f bottomRightInner = new Vector3f(halfWidth, -halfHeight, 1.0f);
        tris.add(new Vector3f[]{topLeftInner, bottomLeftInner, bottomRightInner});
        tris.add(new Vector3f[]{topLeftInner, bottomRightInner, topRightInner});
        tris.add(new Vector3f[]{topLeftOuter, topLeftInner, topRightInner});
        tris.add(new Vector3f[]{topLeftOuter, topRightInner, topRightOuter});
        tris.add(new Vector3f[]{bottomLeftInner, bottomLeftOuter, bottomRightOuter});
        tris.add(new Vector3f[]{bottomLeftInner, bottomRightOuter, bottomRightInner});
        tris.add(new Vector3f[]{topLeftInner, topLeftOuter, bottomLeftOuter});
        tris.add(new Vector3f[]{topLeftInner, bottomLeftOuter, bottomLeftInner});
        tris.add(new Vector3f[]{bottomRightInner, bottomRightOuter, topRightOuter});
        tris.add(new Vector3f[]{bottomRightInner, topRightOuter, topRightInner});
        return tris;
    }

    public static List<Vector3f[]> getCubeFaces(Vector3f vxyz, Vector3f vxyZ, Vector3f vXyZ, Vector3f vXyz, Vector3f vxYz, Vector3f vxYZ, Vector3f vXYZ, Vector3f vXYz, boolean includeBottomFace) {
        ArrayList<Vector3f[]> faces = new ArrayList<Vector3f[]>();
        faces.add(new Vector3f[]{vXYz, vXYZ, vxYZ, vxYz});
        faces.add(new Vector3f[]{vxyZ, vXyZ, vXYZ, vxYZ});
        faces.add(new Vector3f[]{vXyz, vxyz, vxYz, vXYz});
        faces.add(new Vector3f[]{vxyz, vxyZ, vxYZ, vxYz});
        faces.add(new Vector3f[]{vXyZ, vXyz, vXYz, vXYZ});
        if (includeBottomFace) {
            faces.add(new Vector3f[]{vxyz, vXyz, vXyZ, vxyZ});
        }
        return faces;
    }

    public static List<Vector3f[]> getCubeEdges(Vector3f minPos, Vector3f maxPos) {
        int[][] edgeIndices;
        ArrayList<Vector3f[]> edges = new ArrayList<Vector3f[]>();
        Vector3f[] corners = new Vector3f[]{MemoryPool.newVector3f(minPos.x, minPos.y, minPos.z), MemoryPool.newVector3f(maxPos.x, minPos.y, minPos.z), MemoryPool.newVector3f(maxPos.x, maxPos.y, minPos.z), MemoryPool.newVector3f(minPos.x, maxPos.y, minPos.z), MemoryPool.newVector3f(minPos.x, minPos.y, maxPos.z), MemoryPool.newVector3f(maxPos.x, minPos.y, maxPos.z), MemoryPool.newVector3f(maxPos.x, maxPos.y, maxPos.z), MemoryPool.newVector3f(minPos.x, maxPos.y, maxPos.z)};
        for (int[] pair : edgeIndices = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}}) {
            edges.add(new Vector3f[]{corners[pair[0]], corners[pair[1]]});
        }
        return edges;
    }

    public static List<Vector3f[]> getCubeFaces(Vector3f minPos, Vector3f maxPos) {
        int[][] faceIndices;
        ArrayList<Vector3f[]> faces = new ArrayList<Vector3f[]>();
        Vector3f[] corners = new Vector3f[]{new Vector3f(minPos.x, minPos.y, minPos.z), new Vector3f(maxPos.x, minPos.y, minPos.z), new Vector3f(maxPos.x, maxPos.y, minPos.z), new Vector3f(minPos.x, maxPos.y, minPos.z), new Vector3f(minPos.x, minPos.y, maxPos.z), new Vector3f(maxPos.x, minPos.y, maxPos.z), new Vector3f(maxPos.x, maxPos.y, maxPos.z), new Vector3f(minPos.x, maxPos.y, maxPos.z)};
        for (int[] pair : faceIndices = new int[][]{{3, 2, 1, 0}, {4, 5, 6, 7}, {4, 7, 3, 0}, {2, 6, 5, 1}, {7, 6, 2, 3}, {1, 5, 4, 0}}) {
            faces.add(new Vector3f[]{corners[pair[0]], corners[pair[1]], corners[pair[2]], corners[pair[3]]});
        }
        return faces;
    }

    static {
        saberRenderCalls = new ArrayList();
    }
}

