/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.RenderUtil;
import com.beatcraft.client.render.dynamic_loader.DynamicTexture;
import com.beatcraft.common.data.types.ISplinePath;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DebugRenderer {
    private static final ArrayList<Runnable> renderCalls = new ArrayList();
    public static final class_2394 RED_DUST = new class_2390(new Vector3f(1.0f, 0.0f, 0.0f), 0.5f);
    public static final class_2394 ORANGE_DUST = new class_2390(new Vector3f(1.0f, 0.5f, 0.0f), 0.5f);
    public static final class_2394 YELLOW_DUST = new class_2390(new Vector3f(1.0f, 1.0f, 0.0f), 0.5f);
    public static final class_2394 GREEN_DUST = new class_2390(new Vector3f(0.0f, 1.0f, 0.0f), 0.5f);
    public static final class_2394 BLUE_DUST = new class_2390(new Vector3f(0.0f, 0.0f, 1.0f), 0.5f);
    public static final class_2394 MAGENTA_DUST = new class_2390(new Vector3f(1.0f, 0.0f, 1.0f), 0.5f);
    public static DynamicTexture dynamicTexture;
    public static boolean doDebugRendering;
    public static boolean debugSaberRendering;
    public static boolean renderHitboxes;
    public static boolean renderArcDebugLines;

    public static void renderLine(Vector3f origin, Vector3f end, int colorA, int colorB) {
        renderCalls.add(() -> DebugRenderer._renderLine(origin, end, colorA, colorB));
    }

    public static void renderParticle(Vector3f point, class_2394 particle) {
        class_310.method_1551().field_1687.method_8406(particle, (double)point.x, (double)point.y, (double)point.z, 0.0, 0.0, 0.0);
    }

    public static void renderHitbox(Hitbox hitbox, Vector3f position, Quaternionf orientation, int color, boolean doDepthTest) {
        renderCalls.add(() -> DebugRenderer._renderHitbox(hitbox, position, orientation, color, doDepthTest, 2));
    }

    public static void renderHitbox(Hitbox hitbox, Vector3f position, Quaternionf orientation, int color, boolean doDepthTest, int lineWidth) {
        renderCalls.add(() -> DebugRenderer._renderHitbox(hitbox, position, orientation, color, doDepthTest, lineWidth));
    }

    public static void renderPath(ISplinePath path, int segments, int color) {
        renderCalls.add(() -> DebugRenderer._renderPath(path, segments, color));
    }

    public static void _renderLine(Vector3f origin, Vector3f endPoint, int colorA, int colorB) {
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        Vector3f cam = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        Vector3f normal = endPoint.sub((Vector3fc)origin, new Vector3f());
        origin = origin.sub((Vector3fc)cam, new Vector3f());
        endPoint = endPoint.sub((Vector3fc)cam, new Vector3f());
        buffer.method_22912(origin.x, origin.y, origin.z).method_39415(colorA).method_22914(normal.x, normal.y, normal.z);
        buffer.method_22912(endPoint.x, endPoint.y, endPoint.z).method_39415(colorB).method_22914(normal.x, normal.y, normal.z);
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34535);
        float oldLineWidth = RenderSystem.getShaderLineWidth();
        RenderSystem.lineWidth((float)2.0f);
        class_286.method_43433((class_9801)buff);
        RenderSystem.disableDepthTest();
        RenderSystem.lineWidth((float)oldLineWidth);
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    public static void _renderPath(ISplinePath path, int segments, int color) {
        class_9801 buff;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        Vector3f cam = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        for (int i = 0; i < segments; ++i) {
            float f = (float)i / (float)segments;
            float f2 = (float)(i + 1) / (float)segments;
            Vector3f p = path.evaluate(f).sub((Vector3fc)cam);
            Vector3f p2 = path.evaluate(f2).sub((Vector3fc)cam);
            Vector3f normal = p2.sub((Vector3fc)p, new Vector3f()).normalize();
            buffer.method_22912(p.x, p.y, p.z).method_39415(color).method_22914(normal.x, normal.y, normal.z);
            buffer.method_22912(p2.x, p2.y, p2.z).method_39415(color).method_22914(normal.x, normal.y, normal.z);
        }
        List<Vector3f> controlPoints = path.getControlPoints();
        if (controlPoints.size() >= 2) {
            for (int i = 0; i < controlPoints.size() - 1; ++i) {
                Vector3f p = controlPoints.get(i).sub((Vector3fc)cam);
                Vector3f p2 = controlPoints.get(i + 1).sub((Vector3fc)cam);
                Vector3f normal = p2.sub((Vector3fc)p, new Vector3f()).normalize();
                buffer.method_22912(p.x, p.y, p.z).method_39415(0xFF0000).method_22914(normal.x, normal.y, normal.z);
                buffer.method_22912(p2.x, p2.y, p2.z).method_39415(0xFF0000).method_22914(normal.x, normal.y, normal.z);
            }
        }
        if ((buff = buffer.method_60794()) == null) {
            return;
        }
        class_5944 oldShader = RenderSystem.getShader();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34535);
        float oldLineWidth = RenderSystem.getShaderLineWidth();
        RenderSystem.lineWidth((float)2.0f);
        class_286.method_43433((class_9801)buff);
        RenderSystem.lineWidth((float)oldLineWidth);
        RenderSystem.setShader(() -> oldShader);
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
    }

    public static void renderHitbox(Hitbox hitbox, Vector3f position, Quaternionf orientation, int color) {
        DebugRenderer.renderHitbox(hitbox, position, orientation, color, false);
    }

    private static void _renderHitbox(Hitbox hitbox, Vector3f position, Quaternionf orientation, int color, boolean doDepthTest, int lineWidth) {
        List<Vector3f[]> edges = BeatcraftRenderer.getCubeEdges(hitbox.min, hitbox.max);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        class_5944 oldShader = RenderSystem.getShader();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)doDepthTest);
        if (doDepthTest) {
            RenderSystem.enableDepthTest();
        }
        RenderSystem.setShader(class_757::method_34535);
        float oldLineWidth = RenderSystem.getShaderLineWidth();
        RenderSystem.lineWidth((float)lineWidth);
        for (Vector3f[] edge : edges) {
            Vector3f c1 = edge[0].rotate((Quaternionfc)orientation, new Vector3f());
            Vector3f c2 = edge[1].rotate((Quaternionfc)orientation, new Vector3f());
            c1.add((Vector3fc)position);
            c2.add((Vector3fc)position);
            Vector3f normal = c2.sub((Vector3fc)c1, new Vector3f()).normalize();
            for (Vector3f[] segments : RenderUtil.chopEdge(c1, c2)) {
                buffer.method_22912((float)((double)segments[0].x - cam.field_1352), (float)((double)segments[0].y - cam.field_1351), (float)((double)segments[0].z - cam.field_1350)).method_39415(color).method_22914(normal.x, normal.y, normal.z);
                buffer.method_22912((float)((double)segments[1].x - cam.field_1352), (float)((double)segments[1].y - cam.field_1351), (float)((double)segments[1].z - cam.field_1350)).method_39415(color).method_22914(normal.x, normal.y, normal.z);
            }
        }
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        class_286.method_43433((class_9801)buff);
        RenderSystem.disableDepthTest();
        RenderSystem.lineWidth((float)oldLineWidth);
        RenderSystem.setShader(() -> oldShader);
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
    }

    public static void render() {
        for (Runnable renderCall : renderCalls) {
            try {
                renderCall.run();
            }
            catch (Exception e) {
                Beatcraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        renderCalls.clear();
    }

    static {
        doDebugRendering = false;
        debugSaberRendering = false;
        renderHitboxes = false;
        renderArcDebugLines = false;
    }
}

