/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2350;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import oshi.util.tuples.Pair;

public class RenderUtil {
    public static Quaternionf getBlockRenderOrientation(class_2350 face) {
        Quaternionf q = new Quaternionf();
        switch (face) {
            case field_11033: {
                q.identity();
                break;
            }
            case field_11036: {
                q.rotationX((float)Math.PI);
                break;
            }
            case field_11043: {
                q.rotationX(1.5707964f);
                break;
            }
            case field_11035: {
                q.rotationX(-1.5707964f);
                break;
            }
            case field_11034: {
                q.rotationZ(1.5707964f);
                break;
            }
            case field_11039: {
                q.rotationZ(-1.5707964f);
            }
        }
        return q;
    }

    public static Quaternionf getBlockRenderOrientation(class_2350 face, class_2350 rotation) {
        Quaternionf q = new Quaternionf();
        switch (face) {
            case field_11033: {
                q.identity();
                break;
            }
            case field_11036: {
                q.rotationX((float)Math.PI);
                break;
            }
            case field_11043: {
                q.rotationX(1.5707964f);
                break;
            }
            case field_11035: {
                q.rotationX(-1.5707964f);
                break;
            }
            case field_11034: {
                q.rotationZ(1.5707964f);
                break;
            }
            case field_11039: {
                q.rotationZ(-1.5707964f);
            }
        }
        Vector3f local = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f target = rotation.method_23955().rotate((Quaternionfc)q.conjugate(new Quaternionf()));
        return q.mul((Quaternionfc)RenderUtil.rotationBetween(local, target));
    }

    public static Quaternionf rotationBetween(Vector3f local, Vector3f target) {
        Vector3f axis = new Vector3f();
        local.cross((Vector3fc)target, axis);
        float dot = local.dot((Vector3fc)target);
        float angle = (float)Math.acos(Math.max(-1.0f, Math.min(1.0f, dot)));
        if (axis.lengthSquared() < 1.0E-4f) {
            if (dot > 0.0f) {
                return new Quaternionf().identity();
            }
            axis = RenderUtil.findPerpendicular(local).normalize();
            return new Quaternionf().rotationAxis((float)Math.PI, (Vector3fc)axis);
        }
        return new Quaternionf().rotationAxis(angle, (Vector3fc)axis.normalize());
    }

    private static Vector3f findPerpendicular(Vector3f v) {
        return Math.abs(v.x) > Math.abs(v.z) ? new Vector3f(-v.y, v.x, 0.0f) : new Vector3f(0.0f, -v.z, v.y);
    }

    public static List<Vector3f[]> chopEdge(Vector3f a, Vector3f b) {
        return RenderUtil.chopEdge(a, b, 5.0f);
    }

    public static List<Vector3f[]> chopEdge(Vector3f a, Vector3f b, float subsection_size) {
        ArrayList<Vector3f[]> segments = new ArrayList<Vector3f[]>();
        Vector3f direction = b.sub((Vector3fc)a, new Vector3f());
        direction.normalize();
        direction.mul(subsection_size);
        Vector3f c = a;
        while (a.distance((Vector3fc)b) > subsection_size) {
            c = new Vector3f((Vector3fc)a).add((Vector3fc)direction);
            segments.add(new Vector3f[]{a, c});
            a = c;
        }
        segments.add(new Vector3f[]{c, b});
        return segments;
    }

    public static List<Pair<Vector3f, Float>[]> chopEdgeLerp(Vector3f a, Vector3f b, float subsection_size, float fa, float fb) {
        ArrayList<Pair<Vector3f, Float>[]> segments = new ArrayList<Pair<Vector3f, Float>[]>();
        float totalDistance = a.distance((Vector3fc)b);
        Vector3f direction = b.sub((Vector3fc)a, new Vector3f()).normalize().mul(subsection_size);
        Vector3f current = new Vector3f((Vector3fc)a);
        float currentDistance = 0.0f;
        while (current.distance((Vector3fc)b) > subsection_size) {
            Vector3f next = new Vector3f((Vector3fc)current).add((Vector3fc)direction);
            float t1 = (currentDistance += subsection_size) / totalDistance;
            float t0 = (currentDistance - subsection_size) / totalDistance;
            float interpolatedA = fa + (fb - fa) * t0;
            float interpolatedB = fa + (fb - fa) * t1;
            segments.add(new Pair[]{new Pair((Object)new Vector3f((Vector3fc)current), (Object)Float.valueOf(interpolatedA)), new Pair((Object)new Vector3f((Vector3fc)next), (Object)Float.valueOf(interpolatedB))});
            current.set((Vector3fc)next);
        }
        float tLast = current.distance((Vector3fc)a) / totalDistance;
        float interpolatedLast = fa + (fb - fa) * tLast;
        segments.add(new Pair[]{new Pair((Object)new Vector3f((Vector3fc)current), (Object)Float.valueOf(interpolatedLast)), new Pair((Object)new Vector3f((Vector3fc)b), (Object)Float.valueOf(fb))});
        return segments;
    }

    public static List<Vector3f[]> sliceQuad(Vector3f v0, Vector3f v1, Vector3f v2, Vector3f v3, float subsection_size) {
        ArrayList<Vector3f[]> slicedQuads = new ArrayList<Vector3f[]>();
        List<Vector3f[]> leftSegments = RenderUtil.chopEdge(v0, v3, subsection_size);
        List<Vector3f[]> rightSegments = RenderUtil.chopEdge(v1, v2, subsection_size);
        int numRows = Math.min(leftSegments.size(), rightSegments.size());
        if (numRows < 1) {
            return slicedQuads;
        }
        for (int i = 0; i < numRows; ++i) {
            Vector3f leftTop = leftSegments.get(i)[0];
            Vector3f leftBottom = leftSegments.get(i)[1];
            Vector3f rightTop = rightSegments.get(i)[0];
            Vector3f rightBottom = rightSegments.get(i)[1];
            List<Vector3f[]> topSegments = RenderUtil.chopEdge(leftTop, rightTop, subsection_size);
            List<Vector3f[]> bottomSegments = RenderUtil.chopEdge(leftBottom, rightBottom, subsection_size);
            int numCols = Math.min(topSegments.size(), bottomSegments.size());
            if (numCols < 1) continue;
            for (int j = 0; j < numCols; ++j) {
                Vector3f tL = topSegments.get(j)[1];
                Vector3f tR = topSegments.get(j)[0];
                Vector3f bL = bottomSegments.get(j)[1];
                Vector3f bR = bottomSegments.get(j)[0];
                slicedQuads.add(new Vector3f[]{tL, tR, bR, bL});
            }
        }
        return slicedQuads;
    }
}

