/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.dynamic_loader;

import com.beatcraft.Beatcraft;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class DynamicTexture {
    private static final HashMap<class_2960, DynamicTexture> loadedTextures = new HashMap();
    private final class_2960 textureID;
    private final int width;
    private final int height;
    private final String path;
    private class_1011 img;
    private class_1043 tex;

    private String filterString(String in) {
        return in.replaceAll("[^a-z0-9/._-]", "_").replaceAll("(?i)\\.jpe?g$", ".png");
    }

    public DynamicTexture(String path) throws IOException {
        this.path = path.replaceAll("(?i)\\.jpe?g$", ".png");
        this.img = class_1011.method_4309((InputStream)new FileInputStream(this.path.replace("\\", "/")));
        this.tex = new class_1043(this.img);
        this.width = this.img.method_4307();
        this.height = this.img.method_4323();
        this.textureID = Beatcraft.id("dynamic/" + this.filterString(this.path.toLowerCase()));
        DynamicTexture.unloadTextureFromId(this.textureID);
        class_310.method_1551().method_1531().method_4616(this.textureID, (class_1044)this.tex);
        loadedTextures.put(this.textureID, this);
    }

    public void reload() {
        class_310.method_1551().method_1531().method_4615(this.textureID);
        try {
            this.img = class_1011.method_4309((InputStream)new FileInputStream(this.path.replace("\\", "/")));
            this.tex = new class_1043(this.img);
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to reload texture '{}'", (Object)this.path, (Object)e);
        }
        class_310.method_1551().method_1531().method_4616(this.textureID, (class_1044)this.tex);
        if (!loadedTextures.containsKey(this.textureID)) {
            loadedTextures.put(this.textureID, this);
        }
    }

    public boolean isLoaded() {
        return loadedTextures.containsKey(this.textureID);
    }

    public DynamicTexture getFromId(class_2960 id) {
        return loadedTextures.get(id);
    }

    public class_2960 id() {
        return this.textureID;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public static void unloadAllTextures() {
        loadedTextures.clear();
    }

    public void unloadTexture() {
        if (!this.isLoaded()) {
            return;
        }
        class_310.method_1551().method_1531().method_4615(this.textureID);
        loadedTextures.remove(this.textureID);
    }

    public static void unloadTextureFromId(class_2960 id) {
        if (loadedTextures.containsKey(id)) {
            class_310.method_1551().method_1531().method_4615(id);
            loadedTextures.remove(id);
        }
    }
}

