/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.effect;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.MirrorHandler;
import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.class_1041;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4184;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL31;
import org.vivecraft.api.client.data.RenderPass;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.render.helpers.RenderHelper;

public class Bloomfog {
    public boolean overrideBuffer = false;
    public class_276 overrideFramebuffer = null;
    public class_6367 framebuffer;
    private final ArrayList<QuadConsumer<class_287, Vector3f, Quaternionf, Boolean>> renderCalls = new ArrayList();
    private final ArrayList<QuadConsumer<class_287, Vector3f, Quaternionf, Boolean>> renderCalls2 = new ArrayList();
    private final class_2960 textureId = Beatcraft.id("bloomfog/main");
    private final BloomfogTex tex;
    public final class_6367 extraBuffer;
    public final class_6367 blurredBuffer;
    private final class_2960 blurredTexId = Beatcraft.id("bloomfog/blurred");
    private BloomfogTex blurredTex;
    public static class_5944 blurShaderUp;
    public static class_5944 blurShaderDown;
    public static class_5944 gaussianV;
    public static class_5944 gaussianH;
    public static class_5944 bloomfogLineShader;
    public static class_5944 bloomfogPositionColor;
    public static class_5944 bloomfogColorFix;
    public static class_5944 blueNoise;
    public static class_5944 backlightsPositionColorShader;
    public static class_5944 blitShader;
    public static class_5944 compositeShader;
    public static class_5944 bloomMaskLightShader;
    public static class_5944 bloomMaskLightTextureShader;
    private static final class_2960 blueNoiseTexture;
    public ArrayList<TriConsumer<class_287, Vector3f, Quaternionf>> bloomCalls = new ArrayList();
    public ArrayList<TriConsumer<class_287, Vector3f, Quaternionf>> noteBloomCalls = new ArrayList();
    public ArrayList<TriConsumer<class_287, Vector3f, Quaternionf>> arrowBloomCalls = new ArrayList();
    public ArrayList<TriConsumer<Vector3f, Quaternionf, Integer>> miscBloomCalls = new ArrayList();
    public static class_6367 bloomInput;
    private static class_6367 bloomSwap;
    public static class_6367 bloomOutput;
    public static class_6367 lightDepth;
    private static float radius;
    private static final int LAYERS = 10;
    private class_2960[] pyramidTexIds = new class_2960[10];
    private class_6367[] pyramidBuffers = new class_6367[10];
    private class_6367[] pyramidBuffers2 = new class_6367[10];
    private BloomfogTex[] pyramidTextures = new BloomfogTex[10];
    private static int arrowShaderProgram;
    private static Bloomfog INSTANCE;
    public static boolean bloomfog_resize;
    private float layers = 1.0f;
    private Quaternionf invCameraRotation = new Quaternionf();
    private int[] lastSize = new int[]{1, 1};
    private int secondaryBindTex = 0;
    public static int sceneDepthBuffer;

    public static void initShaders() {
        try {
            blurShaderUp = new class_5944((class_5912)class_310.method_1551().method_1478(), "bloomfog_upsample", class_290.field_1575);
            blurShaderDown = new class_5944((class_5912)class_310.method_1551().method_1478(), "bloomfog_downsample", class_290.field_1575);
            gaussianV = new class_5944((class_5912)class_310.method_1551().method_1478(), "gaussian_v", class_290.field_1575);
            gaussianH = new class_5944((class_5912)class_310.method_1551().method_1478(), "gaussian_h", class_290.field_1575);
            blueNoise = new class_5944((class_5912)class_310.method_1551().method_1478(), "blue_noise", class_290.field_1575);
            blitShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "beatcraft_blit", class_290.field_1575);
            compositeShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "composite", class_290.field_1575);
            bloomfogPositionColor = new class_5944((class_5912)class_310.method_1551().method_1478(), "col_bloomfog", class_290.field_1576);
            backlightsPositionColorShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "backlights_position_color", class_290.field_1576);
            bloomfogLineShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "bloomfog_lines", class_290.field_29337);
            bloomfogColorFix = new class_5944((class_5912)class_310.method_1551().method_1478(), "bloomfog_colorfix", class_290.field_1577);
            bloomMaskLightShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "position_color_bloom_mask", class_290.field_1576);
            bloomMaskLightTextureShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "position_color_texture_bloom_mask", class_290.field_1575);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static float[] getFogHeights(Vector3f position) {
        return BeatmapManager.getAverageFogHeight(position);
    }

    public Bloomfog(boolean initMirror) {
        if (initMirror) {
            MirrorHandler.init();
        }
        if (!initMirror) {
            Bloomfog.initShaders();
        }
        this.framebuffer = new class_6367(1920, 1080, true, class_310.field_1703);
        this.blurredBuffer = new class_6367(1920, 1080, true, class_310.field_1703);
        this.extraBuffer = new class_6367(1920, 1080, true, class_310.field_1703);
        bloomInput = new class_6367(1920, 1080, true, class_310.field_1703);
        bloomSwap = new class_6367(1920, 1080, true, class_310.field_1703);
        bloomOutput = new class_6367(1920, 1080, true, class_310.field_1703);
        lightDepth = new class_6367(1920, 1080, true, class_310.field_1703);
        this.tex = new BloomfogTex(this.framebuffer);
        this.blurredTex = new BloomfogTex(this.blurredBuffer);
        class_1060 texManager = class_310.method_1551().method_1531();
        texManager.method_4616(this.textureId, (class_1044)this.tex);
        texManager.method_4616(this.blurredTexId, (class_1044)this.blurredTex);
        for (int i = 0; i < 10; ++i) {
            this.pyramidBuffers[i] = new class_6367(512, 512, false, class_310.field_1703);
            this.pyramidBuffers2[i] = new class_6367(512, 512, false, class_310.field_1703);
        }
        LightMesh.buildMeshes();
    }

    public static Bloomfog create() {
        if (INSTANCE == null) {
            INSTANCE = new Bloomfog(true);
        }
        return INSTANCE;
    }

    public void resize(int width, int height, boolean resizeMirror) {
        bloomfog_resize = true;
        this.framebuffer.method_1234(width * 2, height * 2, class_310.field_1703);
        this.blurredBuffer.method_1234(width * 2, height * 2, class_310.field_1703);
        this.extraBuffer.method_1234(width * 2, height * 2, class_310.field_1703);
        bloomInput.method_1234(width, height, class_310.field_1703);
        bloomSwap.method_1234(width, height, class_310.field_1703);
        bloomOutput.method_1234(width, height, class_310.field_1703);
        lightDepth.method_1234(width, height, class_310.field_1703);
        this.layers = 7.0f;
        float mod = 2.0f;
        int l = 0;
        while ((float)l < this.layers) {
            if ((int)((float)width / mod) > 0 && (int)((float)height / mod) > 0) {
                this.pyramidBuffers[l].method_1234((int)((float)(width * 2) / mod), (int)((float)(height * 2) / mod), class_310.field_1703);
                this.pyramidBuffers2[l].method_1234((int)((float)(width * 2) / mod), (int)((float)(height * 2) / mod), class_310.field_1703);
            }
            mod *= 2.0f;
            ++l;
        }
        if (resizeMirror) {
            MirrorHandler.resize();
        }
        bloomfog_resize = false;
    }

    public void unload() {
        class_310.method_1551().method_1531().method_4615(this.textureId);
        this.framebuffer.method_1238();
    }

    public int getTexture() {
        return this.framebuffer.method_30277();
    }

    public class_2960 getId() {
        return this.blurredTexId;
    }

    public void record(QuadConsumer<class_287, Vector3f, Quaternionf, Boolean> call) {
        this.renderCalls.add(call);
    }

    public static float calculateRoll(Vector3f up, Vector3f left) {
        return (float)Math.atan2(left.y, up.y);
    }

    public void render(boolean isMirror, float tickDelta) {
        float f;
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        int width = window.method_4489();
        int height = window.method_4506();
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Vector3f cameraPos = camera.method_19326().method_46409();
        if (ClientDataHolderVR.getInstance().vr != null) {
            Matrix4f rotationMatrix = RenderHelper.getVRModelView((RenderPass)ClientDataHolderVR.getInstance().currentPass);
            this.invCameraRotation = rotationMatrix.getUnnormalizedRotation(new Quaternionf());
        } else {
            this.invCameraRotation = camera.method_23767().conjugate(new Quaternionf());
            float pitch = camera.method_19329();
            Vector3f up = camera.method_19336();
            Vector3f left = camera.method_35689();
            f = Math.abs(pitch) >= 90.0f ? 0.0f : Bloomfog.calculateRoll(up, left);
            Quaternionf rollQuat = new Quaternionf().rotationAxis(f, (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f));
            rollQuat.mul((Quaternionfc)this.invCameraRotation, this.invCameraRotation);
        }
        if (!BeatcraftClient.playerConfig.quality.doBloomfog()) {
            return;
        }
        this.framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.framebuffer.method_1230(class_310.field_1703);
        if (width != this.lastSize[0] || height != this.lastSize[1]) {
            this.lastSize = new int[]{Math.max(1, width), Math.max(1, height)};
            this.resize(Math.max(1, width), Math.max(1, height), true);
        }
        class_310.method_1551().method_1522().method_1240();
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = this.framebuffer;
        this.framebuffer.method_1235(true);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27377, class_290.field_29337);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (QuadConsumer quadConsumer : this.renderCalls) {
            quadConsumer.accept(buffer, cameraPos, this.invCameraRotation, false);
        }
        this.renderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.setShader(() -> bloomfogLineShader);
            RenderSystem.lineWidth((float)((float)window.method_4489() / 225.0f));
            class_286.method_43433((class_9801)buff);
        }
        LightMesh.renderAllBloomfog();
        this.framebuffer.method_1240();
        BeatcraftRenderer.bloomfog.overrideBuffer = isMirror;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = isMirror ? this.overrideFramebuffer : null;
        MirrorHandler.invCameraRotation = this.invCameraRotation;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        this.applyPyramidBlur(isMirror);
        class_310.method_1551().method_1522().method_1235(true);
        RenderSystem.depthMask((boolean)false);
        buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        f = 0.0f;
        buffer.method_22912(-2.0f, -2.0f, f).method_22913(0.0f, 0.0f);
        buffer.method_22912(2.0f, -2.0f, f).method_22913(1.0f, 0.0f);
        buffer.method_22912(2.0f, 2.0f, f).method_22913(1.0f, 1.0f);
        buffer.method_22912(-2.0f, 2.0f, f).method_22913(0.0f, 1.0f);
        Matrix4f oldProjMat = RenderSystem.getProjectionMatrix();
        class_8251 oldVertexSort = RenderSystem.getVertexSorting();
        Matrix4f orthoMatrix = new Matrix4f().ortho(0.0f, (float)width, (float)height, 0.0f, -1000.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)orthoMatrix, (class_8251)class_8251.field_43360);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.blurredTexId);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.setProjectionMatrix((Matrix4f)oldProjMat, (class_8251)oldVertexSort);
        RenderSystem.enableCull();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
    }

    public void loadTex() {
        RenderSystem.setShaderTexture((int)0, (int)this.blurredBuffer.method_30277());
    }

    public void loadTexSecondary() {
        RenderSystem.setShaderTexture((int)1, (int)this.blurredBuffer.method_30277());
    }

    public int getBloomfogColorAttachment() {
        return this.blurredBuffer.method_30277();
    }

    private void applyPyramidBlur(boolean isMirror) {
        class_6367 current = this.framebuffer;
        int l = 0;
        while ((float)l < this.layers) {
            this.applyEffectPass(isMirror, (class_276)current, (class_276)this.pyramidBuffers[l], PassType.DOWNSAMPLE, true);
            current = this.pyramidBuffers[l];
            ++l;
        }
        this.applyEffectPass(isMirror, (class_276)current, (class_276)this.extraBuffer, PassType.UPSAMPLE, true);
        this.applyEffectPass(isMirror, (class_276)this.extraBuffer, (class_276)this.framebuffer, PassType.GAUSSIAN_V, true);
        this.applyEffectPass(isMirror, (class_276)this.framebuffer, (class_276)this.extraBuffer, PassType.GAUSSIAN_H, true);
        this.applyEffectPass(isMirror, (class_276)this.extraBuffer, (class_276)this.blurredBuffer, PassType.BLUE_NOISE, false);
    }

    private void applyEffectPass(boolean isMirror, class_276 in, class_276 out, PassType pass) {
        this.applyEffectPass(isMirror, in, out, pass, false);
    }

    private void applyEffectPass(boolean isMirror, class_276 in, class_276 out, PassType pass, boolean overrideSampleMode) {
        out.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        out.method_1230(class_310.field_1703);
        out.method_1235(true);
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = out;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float w = class_310.method_1551().method_22683().method_4489();
        float h = class_310.method_1551().method_22683().method_4506();
        RenderSystem.setShaderTexture((int)0, (int)in.method_30277());
        class_5944 shader = switch (pass.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> blurShaderDown;
            case 1 -> blurShaderUp;
            case 2 -> gaussianV;
            case 3 -> gaussianH;
            case 4 -> blueNoise;
            case 5 -> blitShader;
            case 6 -> compositeShader;
        };
        RenderSystem.setShader(() -> shader);
        GlUtil.useProgram(shader.method_1270());
        GlUtil.setTex(shader.method_1270(), "Sampler0", 0, in.method_30277());
        if (overrideSampleMode) {
            GL31.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL31.glTexParameteri((int)3553, (int)10240, (int)9729);
        } else {
            GL31.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL31.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
        if (pass == PassType.BLUE_NOISE) {
            RenderSystem.setShaderTexture((int)1, (class_2960)blueNoiseTexture);
            shader.method_35785("texelSize").method_1255(512.0f / w, 512.0f / h);
        } else if (pass == PassType.COMP) {
            shader.method_34583("Sampler1", (Object)this.secondaryBindTex);
            RenderSystem.setShaderTexture((int)1, (int)this.secondaryBindTex);
        } else {
            shader.method_35785("texelSize").method_1255(radius / w, radius / h);
        }
        RenderSystem.enableBlend();
        float z = 0.0f;
        buffer.method_60830(new Vector3f(-1.0f, -1.0f, z)).method_22913(0.0f, 0.0f).method_39415(-16645632);
        buffer.method_60830(new Vector3f(1.0f, -1.0f, z)).method_22913(1.0f, 0.0f).method_39415(-16645632);
        buffer.method_60830(new Vector3f(1.0f, 1.0f, z)).method_22913(1.0f, 1.0f).method_39415(-16645632);
        buffer.method_60830(new Vector3f(-1.0f, 1.0f, z)).method_22913(0.0f, 1.0f).method_39415(-16645632);
        class_286.method_43433((class_9801)buffer.method_60800());
        out.method_1240();
        BeatcraftRenderer.bloomfog.overrideBuffer = isMirror;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = isMirror ? this.overrideFramebuffer : null;
    }

    public void recordBloomCall(TriConsumer<class_287, Vector3f, Quaternionf> call) {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            return;
        }
        this.bloomCalls.add(call);
    }

    public void recordMiscBloomCall(TriConsumer<Vector3f, Quaternionf, Integer> call) {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            return;
        }
        this.miscBloomCalls.add(call);
    }

    public void recordNoteBloomCall(TriConsumer<class_287, Vector3f, Quaternionf> call) {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            return;
        }
        this.noteBloomCalls.add(call);
    }

    public void recordArrowBloomCall(TriConsumer<class_287, Vector3f, Quaternionf> call) {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            return;
        }
        this.arrowBloomCalls.add(call);
    }

    public void renderBloom() {
        if (!BeatcraftClient.playerConfig.quality.doBloom()) {
            this.bloomCalls.clear();
            this.noteBloomCalls.clear();
            this.arrowBloomCalls.clear();
            this.miscBloomCalls.clear();
            MeshLoader.COLOR_NOTE_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.CHAIN_HEAD_NOTE_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.CHAIN_LINK_NOTE_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.BOMB_NOTE_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.NOTE_ARROW_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.NOTE_DOT_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.CHAIN_DOT_INSTANCED_MESH.cancelBloomCalls();
            MeshLoader.HEADSET_INSTANCED_MESH.cancelBloomCalls();
            LightMesh.cancelBloomDraws();
            bloomOutput.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
            bloomOutput.method_1230(class_310.field_1703);
            class_310.method_1551().method_1522().method_1235(true);
            return;
        }
        Matrix4f old = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
        RenderSystem.getModelViewMatrix().identity();
        RenderSystem.disableCull();
        sceneDepthBuffer = class_310.method_1551().method_1522().method_30278();
        class_310.method_1551().method_1522().method_1240();
        class_310.method_1551().method_1522().method_35610();
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = bloomInput;
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        bloomInput.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        bloomInput.method_1230(class_310.field_1703);
        bloomInput.method_1235(true);
        RenderSystem.defaultBlendFunc();
        class_289 tesselator = class_289.method_1348();
        class_1041 window = class_310.method_1551().method_22683();
        int width = window.method_4489();
        int height = window.method_4506();
        Vector3f cameraPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        for (TriConsumer<class_287, Vector3f, Quaternionf> call : this.bloomCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)this.invCameraRotation);
        }
        this.bloomCalls.clear();
        class_9801 buff = buffer.method_60794();
        RenderSystem.disableDepthTest();
        if (buff != null) {
            Matrix4f worldTransform = new Matrix4f();
            worldTransform.translate((Vector3fc)cameraPos);
            worldTransform.rotate((Quaternionfc)this.invCameraRotation.conjugate(new Quaternionf()));
            RenderSystem.setShader(() -> bloomMaskLightShader);
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.setShaderTexture((int)0, (int)sceneDepthBuffer);
            bloomMaskLightShader.method_34583("Sampler0", (Object)sceneDepthBuffer);
            bloomMaskLightShader.method_35785("WorldTransform").method_1250(worldTransform);
            bloomMaskLightShader.method_35785("u_fog").method_1253(Bloomfog.getFogHeights(cameraPos));
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableDepthTest();
        }
        buffer = tesselator.method_60827(class_293.class_5596.field_27379, class_290.field_1575);
        for (TriConsumer triConsumer : this.noteBloomCalls) {
            triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)this.invCameraRotation);
        }
        this.noteBloomCalls.clear();
        buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.setShader(() -> bloomMaskLightTextureShader);
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.setShaderTexture((int)0, (class_2960)MeshLoader.NOTE_TEXTURE);
            RenderSystem.setShaderTexture((int)1, (int)sceneDepthBuffer);
            bloomMaskLightShader.method_34583("Sampler1", (Object)sceneDepthBuffer);
            bloomMaskLightShader.method_35785("u_fog").method_1253(Bloomfog.getFogHeights(cameraPos));
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableDepthTest();
        }
        buffer = tesselator.method_60827(class_293.class_5596.field_27379, class_290.field_1575);
        for (TriConsumer triConsumer : this.arrowBloomCalls) {
            triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)this.invCameraRotation);
        }
        this.arrowBloomCalls.clear();
        buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.setShader(() -> bloomMaskLightTextureShader);
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.setShaderTexture((int)0, (class_2960)MeshLoader.ARROW_TEXTURE);
            RenderSystem.setShaderTexture((int)1, (int)sceneDepthBuffer);
            bloomMaskLightShader.method_34583("Sampler1", (Object)sceneDepthBuffer);
            bloomMaskLightShader.method_35785("u_fog").method_1253(Bloomfog.getFogHeights(cameraPos));
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableDepthTest();
        }
        for (TriConsumer triConsumer : this.miscBloomCalls) {
            triConsumer.accept((Object)cameraPos, (Object)this.invCameraRotation, (Object)sceneDepthBuffer);
        }
        this.miscBloomCalls.clear();
        MeshLoader.COLOR_NOTE_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.CHAIN_HEAD_NOTE_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.CHAIN_LINK_NOTE_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.BOMB_NOTE_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.NOTE_ARROW_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.NOTE_DOT_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.CHAIN_DOT_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        MeshLoader.HEADSET_INSTANCED_MESH.renderBloom(cameraPos, this.invCameraRotation);
        LightMesh.renderAllBloom(sceneDepthBuffer);
        bloomInput.method_1240();
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        class_310.method_1551().method_1522().method_1242();
        float r = radius;
        radius = 3.25f;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        this.applyEffectPass(false, (class_276)bloomInput, (class_276)bloomSwap, PassType.GAUSSIAN_H, true);
        this.applyEffectPass(false, (class_276)bloomSwap, (class_276)bloomOutput, PassType.GAUSSIAN_V, true);
        radius = r;
        class_310.method_1551().method_1522().method_1235(true);
        RenderSystem.depthMask((boolean)false);
        buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        float f = 0.0f;
        buffer.method_60830(new Vector3f(-1.0f, -1.0f, f)).method_22913(0.0f, 0.0f).method_39415(-16645632);
        buffer.method_60830(new Vector3f(1.0f, -1.0f, f)).method_22913(1.0f, 0.0f).method_39415(-16645632);
        buffer.method_60830(new Vector3f(1.0f, 1.0f, f)).method_22913(1.0f, 1.0f).method_39415(-16645632);
        buffer.method_60830(new Vector3f(-1.0f, 1.0f, f)).method_22913(0.0f, 1.0f).method_39415(-16645632);
        RenderSystem.setShader(() -> blitShader);
        RenderSystem.setShaderTexture((int)0, (int)bloomOutput.method_30277());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        Matrix4f oldProjMat = RenderSystem.getProjectionMatrix();
        class_8251 oldVertexSort = RenderSystem.getVertexSorting();
        Matrix4f orthoMatrix = new Matrix4f().ortho(0.0f, (float)width, (float)height, 0.0f, -1000.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)orthoMatrix, (class_8251)class_8251.field_43360);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.setProjectionMatrix((Matrix4f)oldProjMat, (class_8251)oldVertexSort);
        RenderSystem.enableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.getModelViewMatrix().set((Matrix4fc)old);
    }

    static {
        blueNoiseTexture = Beatcraft.id("textures/noise/blue_noise.png");
        radius = 11.0f;
        arrowShaderProgram = 0;
        INSTANCE = null;
        bloomfog_resize = false;
    }

    public static class BloomfogTex
    extends class_1044 {
        private final class_6367 buffer;

        protected BloomfogTex(class_6367 buffer) {
            this.buffer = buffer;
        }

        public int method_4624() {
            return this.buffer.method_30277();
        }

        public void method_4625(class_3300 manager) throws IOException {
        }
    }

    @FunctionalInterface
    public static interface QuadConsumer<T, U, S, V> {
        public void accept(T var1, U var2, S var3, V var4);
    }

    private static enum PassType {
        DOWNSAMPLE,
        UPSAMPLE,
        GAUSSIAN_V,
        GAUSSIAN_H,
        BLUE_NOISE,
        BLIT,
        COMP;

    }
}

