/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.effect;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.client.render.mesh.MeshLoader;
import com.beatcraft.common.memory.MemoryPool;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_6367;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MirrorHandler {
    private final BeatmapController mapController;
    private static final ArrayList<MirrorHandler> mirrors = new ArrayList();
    public static Quaternionf invCameraRotation = new Quaternionf();
    private static final ArrayList<BiConsumer<class_287, Vector3f>> plainMirrorCalls = new ArrayList();
    private final ArrayList<TriConsumer<class_287, Vector3f, Quaternionf>> drawCalls = new ArrayList();
    private final ArrayList<Bloomfog.QuadConsumer<class_287, Vector3f, Quaternionf, Boolean>> mirrorDraws = new ArrayList();
    private final ArrayList<BiConsumer<class_287, Vector3f>> mirrorNotes = new ArrayList();
    private final ArrayList<BiConsumer<class_287, Vector3f>> mirrorArrows = new ArrayList();
    private final ArrayList<BiConsumer<class_287, Vector3f>> mirrorWallGlows = new ArrayList();
    private final ArrayList<Runnable> earlyCalls = new ArrayList();
    private final ArrayList<TriConsumer<class_287, Vector3f, Integer>> obstacleRenderCalls = new ArrayList();
    public static class_6367 mirrorFramebuffer;
    public static class_6367 depthFramebuffer;
    public static class_5944 mirrorShader;
    public static class_5944 mirrorPositionColorClip;

    public static void init() {
        class_1041 window = class_310.method_1551().method_22683();
        mirrorFramebuffer = new class_6367(window.method_4489(), window.method_4506(), true, class_310.field_1703);
        depthFramebuffer = new class_6367(window.method_4489(), window.method_4506(), true, class_310.field_1703);
        try {
            mirrorShader = new class_5944((class_5912)class_310.method_1551().method_1478(), "light_mirror", class_290.field_1576);
            mirrorPositionColorClip = new class_5944((class_5912)class_310.method_1551().method_1478(), "position_color_clip", class_290.field_1576);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MirrorHandler(BeatmapController map) {
        this.mapController = map;
        mirrors.add(this);
    }

    public static void resize() {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        class_1041 window = class_310.method_1551().method_22683();
        mirrorFramebuffer.method_1234(Math.max(1, window.method_4489()), Math.max(1, window.method_4506()), class_310.field_1703);
        depthFramebuffer.method_1234(Math.max(1, window.method_4489()), Math.max(1, window.method_4506()), class_310.field_1703);
    }

    public void recordMirrorLightDraw(Bloomfog.QuadConsumer<class_287, Vector3f, Quaternionf, Boolean> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.mirrorDraws.add(call);
    }

    public void recordMirrorNoteDraw(BiConsumer<class_287, Vector3f> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.mirrorNotes.add(call);
    }

    public void recordMirrorArrowDraw(BiConsumer<class_287, Vector3f> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.mirrorArrows.add(call);
    }

    public void recordMirrorLaserRenderCall(BiConsumer<class_287, Vector3f> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.mirrorWallGlows.add(call);
    }

    public void recordEarlyRenderCall(Runnable call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.earlyCalls.add(call);
    }

    public void recordCall(TriConsumer<class_287, Vector3f, Quaternionf> call) {
        this.drawCalls.add(call);
    }

    public void recordPlainCall(BiConsumer<class_287, Vector3f> call) {
        plainMirrorCalls.add(call);
    }

    public void recordMirroredObstacleRenderCall(TriConsumer<class_287, Vector3f, Integer> call) {
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            return;
        }
        this.obstacleRenderCalls.add(call);
    }

    private void renderEarly(class_289 tesselator, Vector3f cameraPos) {
        for (Runnable call : this.earlyCalls) {
            call.run();
        }
        this.earlyCalls.clear();
    }

    private void renderObstacles(class_289 tesselator, Vector3f cameraPos) {
        if (this.mapController == null) {
            this.obstacleRenderCalls.clear();
            return;
        }
        int color = this.mapController.difficulty.getSetDifficulty().getColorScheme().getObstacleColor().toARGB(0.15f);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (TriConsumer<class_287, Vector3f, Integer> call : this.obstacleRenderCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)color);
        }
        this.obstacleRenderCalls.clear();
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.enableBlend();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShader(class_757::method_34540);
            buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }
    }

    private void renderNotes(class_289 tesselator, Vector3f cameraPos) {
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        Quaternionf q = MemoryPool.newQuaternionf();
        MeshLoader.MIRROR_COLOR_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_CHAIN_HEAD_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_CHAIN_LINK_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_BOMB_NOTE_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_NOTE_ARROW_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_NOTE_DOT_INSTANCED_MESH.render(cameraPos);
        MeshLoader.MIRROR_CHAIN_DOT_INSTANCED_MESH.render(cameraPos);
        MemoryPool.releaseSafe(q);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }

    private void renderNotes0(class_289 tesselator, Vector3f cameraPos) {
        class_287 triBuffer = tesselator.method_60827(class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        int oldTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShader(() -> BeatcraftRenderer.noteShader);
        RenderSystem.setShaderTexture((int)0, (class_2960)MeshLoader.NOTE_TEXTURE);
        for (BiConsumer<class_287, Vector3f> renderCall : this.mirrorNotes) {
            try {
                renderCall.accept(triBuffer, cameraPos);
            }
            catch (Exception e) {
                Beatcraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        class_9801 triBuff = triBuffer.method_60794();
        if (triBuff != null) {
            class_286.method_43433((class_9801)triBuff);
        }
        triBuffer = tesselator.method_60827(class_293.class_5596.field_27379, class_290.field_1575);
        RenderSystem.setShader(() -> BeatcraftRenderer.arrowShader);
        RenderSystem.setShaderTexture((int)0, (class_2960)MeshLoader.ARROW_TEXTURE);
        for (BiConsumer<class_287, Vector3f> renderCall : this.mirrorArrows) {
            try {
                renderCall.accept(triBuffer, cameraPos);
            }
            catch (Exception e) {
                Beatcraft.LOGGER.error("Render call failed! ", (Throwable)e);
            }
        }
        triBuff = triBuffer.method_60794();
        if (triBuff != null) {
            class_286.method_43433((class_9801)triBuff);
        }
        RenderSystem.setShaderTexture((int)0, (int)oldTexture);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        this.mirrorNotes.clear();
        this.mirrorArrows.clear();
    }

    private void renderFloorLights(class_289 tesselator, Vector3f cameraPos) {
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (BiConsumer<class_287, Vector3f> call : this.mirrorWallGlows) {
            call.accept(buffer, cameraPos);
        }
        this.mirrorWallGlows.clear();
        class_9801 buff = buffer.method_60794();
        if (buff == null) {
            return;
        }
        buff.method_60819(((BufferBuilderAccessor)buffer).beatcraft$getAllocator(), class_8251.field_43360);
        class_286.method_43433((class_9801)buff);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
    }

    private void renderForDepth(class_289 tesselator, Vector3f cameraPos) {
        depthFramebuffer.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
        depthFramebuffer.method_1230(class_310.field_1703);
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = depthFramebuffer;
        depthFramebuffer.method_1235(true);
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (TriConsumer<class_287, Vector3f, Quaternionf> call : this.drawCalls) {
            call.accept((Object)buffer, (Object)cameraPos, (Object)invCameraRotation.conjugate(new Quaternionf()));
        }
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(class_757::method_34540);
            class_286.method_43433((class_9801)buff);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
        }
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        depthFramebuffer.method_1240();
        class_310.method_1551().method_1522().method_1235(true);
    }

    public void drawMirror() {
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        Vector3f cameraPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        Matrix4f worldTransform = new Matrix4f();
        worldTransform.translate((Vector3fc)cameraPos);
        Quaternionf q = MemoryPool.newQuaternionf(invCameraRotation).conjugate();
        worldTransform.rotate((Quaternionfc)q);
        if (BeatcraftClient.playerConfig.quality.doMirror()) {
            this.renderForDepth(tesselator, cameraPos);
        }
        for (BiConsumer<class_287, Vector3f> biConsumer : plainMirrorCalls) {
            biConsumer.accept(buffer, cameraPos);
        }
        plainMirrorCalls.clear();
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            q.set((Quaternionfc)invCameraRotation);
            q.conjugate();
            for (TriConsumer triConsumer : this.drawCalls) {
                triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)q);
            }
            this.drawCalls.clear();
        }
        MemoryPool.releaseSafe(q);
        class_9801 buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.disableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShader(() -> Bloomfog.bloomfogPositionColor);
            Bloomfog.bloomfogPositionColor.method_35785("WorldTransform").method_1250(worldTransform);
            Bloomfog.bloomfogPositionColor.method_35785("u_fog").method_1253(Bloomfog.getFogHeights(cameraPos));
            BeatcraftRenderer.bloomfog.loadTex();
            class_286.method_43433((class_9801)buff);
            RenderSystem.enableCull();
        }
        mirrorFramebuffer.method_1236(0.0f, 0.0f, 0.0f, 1.0f);
        mirrorFramebuffer.method_1230(class_310.field_1703);
        if (!BeatcraftClient.playerConfig.quality.doMirror()) {
            this.earlyCalls.clear();
            this.mirrorDraws.clear();
            this.mirrorNotes.clear();
            this.mirrorArrows.clear();
            this.mirrorWallGlows.clear();
            this.obstacleRenderCalls.clear();
            MeshLoader.MIRROR_COLOR_NOTE_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_CHAIN_HEAD_NOTE_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_CHAIN_LINK_NOTE_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_BOMB_NOTE_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_NOTE_ARROW_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_NOTE_DOT_INSTANCED_MESH.cancelDraws();
            MeshLoader.MIRROR_CHAIN_DOT_INSTANCED_MESH.cancelDraws();
            LightMesh.cancelMirrorDraws();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            class_310.method_1551().method_1522().method_1235(true);
            return;
        }
        class_310.method_1551().method_1522().method_1240();
        BeatcraftRenderer.bloomfog.overrideBuffer = true;
        BeatcraftRenderer.bloomfog.overrideFramebuffer = mirrorFramebuffer;
        mirrorFramebuffer.method_1235(true);
        this.renderEarly(tesselator, cameraPos);
        buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (Bloomfog.QuadConsumer<class_287, Vector3f, Quaternionf, Boolean> quadConsumer : this.mirrorDraws) {
            quadConsumer.accept(buffer, cameraPos, new Quaternionf(), true);
        }
        this.mirrorDraws.clear();
        buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.setShader(() -> mirrorPositionColorClip);
            RenderSystem.setShaderTexture((int)0, (int)depthFramebuffer.method_30278());
            mirrorPositionColorClip.method_34583("Sampler0", (Object)depthFramebuffer.method_30278());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableCull();
            class_286.method_43433((class_9801)buff);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableCull();
        }
        this.renderNotes(tesselator, cameraPos);
        this.renderFloorLights(tesselator, cameraPos);
        this.renderObstacles(tesselator, cameraPos);
        LightMesh.renderAllMirror();
        BeatcraftRenderer.bloomfog.overrideFramebuffer = null;
        BeatcraftRenderer.bloomfog.overrideBuffer = false;
        mirrorFramebuffer.method_1240();
        class_310.method_1551().method_1522().method_1235(true);
        buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        for (TriConsumer<class_287, Vector3f, Quaternionf> triConsumer : this.drawCalls) {
            triConsumer.accept((Object)buffer, (Object)cameraPos, (Object)invCameraRotation.conjugate(new Quaternionf()));
        }
        this.drawCalls.clear();
        buff = buffer.method_60794();
        if (buff != null) {
            RenderSystem.setShader(() -> mirrorShader);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderTexture((int)0, (int)mirrorFramebuffer.method_30277());
            mirrorShader.method_34583("Sampler0", (Object)mirrorFramebuffer.method_30277());
            RenderSystem.setShaderTexture((int)1, (int)mirrorFramebuffer.method_30278());
            mirrorShader.method_34583("Sampler1", (Object)mirrorFramebuffer.method_30278());
            RenderSystem.setShaderTexture((int)2, (int)BeatcraftRenderer.bloomfog.blurredBuffer.method_30277());
            mirrorShader.method_34583("Sampler2", (Object)BeatcraftRenderer.bloomfog.blurredBuffer.method_30277());
            mirrorShader.method_35785("WorldPos").method_34413(cameraPos);
            mirrorShader.method_35785("GameTime").method_1251(BeatcraftClient.random.method_43057());
            class_286.method_43433((class_9801)buff);
            RenderSystem.depthMask((boolean)false);
        }
    }
}

