/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.effect;

import com.beatcraft.client.BeatcraftClient;
import com.beatcraft.client.beatmap.BeatmapManager;
import com.beatcraft.client.logic.PhysicsTransform;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.HUDRenderer;
import com.beatcraft.common.data.ControllerProfile;
import com.beatcraft.common.data.components.ModComponents;
import com.beatcraft.common.data.types.CycleStack;
import com.beatcraft.common.items.ModItems;
import com.beatcraft.common.items.data.ItemStackWithSaberTrailStack;
import com.beatcraft.common.replay.PlayFrame;
import com.beatcraft.mixin_utils.BufferBuilderAccessor;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_757;
import net.minecraft.class_811;
import net.minecraft.class_8251;
import net.minecraft.class_9331;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.vivecraft.client_vr.ClientDataHolderVR;
import oshi.util.tuples.Pair;
import oshi.util.tuples.Triplet;

public class SaberRenderer {
    public static final HashMap<UUID, PlayFrame> otherPlayerSabers = new HashMap();
    private static final ArrayList<Function<class_287, Void>> render_calls = new ArrayList();

    private static void renderOtherPlayerSabers() {
        otherPlayerSabers.forEach((uuid, playFrame) -> {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return;
            }
            class_1657 player = world.method_18470(uuid);
            if (player == null) {
                return;
            }
            class_1799 stack = player.method_6047();
            class_1799 stack2 = player.method_6079();
            if (player.method_6068() == class_1306.field_6182) {
                class_1799 s3 = stack;
                stack = stack2;
                stack2 = s3;
            }
            if (stack.method_31574(ModItems.SABER_ITEM)) {
                SaberRenderer.renderReplaySaber(stack, playFrame.rightSaberPosition(), playFrame.rightSaberRotation());
            }
            if (stack2.method_31574(ModItems.SABER_ITEM)) {
                SaberRenderer.renderReplaySaber(stack2, playFrame.leftSaberPosition(), playFrame.leftSaberRotation());
            }
        });
    }

    public static void renderReplaySaber(class_1799 item, Vector3f position, Quaternionf orientation) {
        SaberRenderer.renderReplayTrail(item, position, orientation);
        class_4587 matrices = new class_4587();
        Vector3f cam = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        matrices.method_46416(-cam.x, -cam.y, -cam.z);
        matrices.method_46416(position.x, position.y, position.z);
        matrices.method_22907(orientation);
        matrices.method_22905(0.3333f, 0.3333f, 0.3333f);
        BeatcraftRenderer.recordSaberRenderCall(() -> class_310.method_1551().method_1480().method_23178(item, class_811.field_4322, 255, 0, matrices, (class_4597)HUDRenderer.buffers, (class_1937)class_310.method_1551().field_1687, 0));
    }

    public static void renderSaber(class_1799 item, class_4587 matrices, class_4597 vertexConsumerProvider, class_1268 hand, class_742 player, float tickDelta) {
        matrices.method_22903();
        Vector3f worldPos = matrices.method_23760().method_23761().getTranslation(new Vector3f());
        Quaternionf worldRotation = matrices.method_23760().method_23761().getNormalizedRotation(new Quaternionf());
        SaberRenderer.renderTrail(true, matrices, hand.equals((Object)class_1268.field_5808), player, tickDelta, item);
        class_310.method_1551().method_1480().method_23178(item, class_811.field_4322, 255, 0, matrices, vertexConsumerProvider, null, 0);
        UUID uuid = player.method_5667();
        if (!BeatcraftClient.controllerTransforms.containsKey(uuid)) {
            BeatcraftClient.controllerTransforms.put(uuid, (Triplet<PhysicsTransform, PhysicsTransform, PhysicsTransform>)new Triplet((Object)new PhysicsTransform(-0.4f, 0.0f, 0.0f), (Object)new PhysicsTransform(0.0f, 0.0f, 0.0f), (Object)new PhysicsTransform(0.4f, 0.0f, 0.0f)));
        }
        boolean isRightHanded = player.method_6068() == class_1306.field_6183;
        class_1268 right = isRightHanded ? class_1268.field_5808 : class_1268.field_5810;
        Triplet<PhysicsTransform, PhysicsTransform, PhysicsTransform> sabers = BeatcraftClient.controllerTransforms.get(uuid);
        Vector3f camPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
        Matrix4f mat = new Matrix4f().translate((Vector3fc)camPos).mul((Matrix4fc)matrices.method_23760().method_23761());
        if (hand == right) {
            ((PhysicsTransform)sabers.getC()).update(mat);
        } else {
            ((PhysicsTransform)sabers.getA()).update(mat);
        }
        matrices.method_22909();
    }

    public static void renderReplayTrail(class_1799 stack, Vector3f basePos, Quaternionf rotation) {
        Vector3f hiltPos = new Vector3f(0.0f, 0.175f, 0.0f).rotate((Quaternionfc)rotation).add((Vector3fc)basePos);
        Vector3f tipPos = new Vector3f(0.0f, 1.025f, 0.0f).rotate((Quaternionfc)rotation).add((Vector3fc)basePos);
        CycleStack<Pair<Vector3f, Vector3f>> cycleStack = ((ItemStackWithSaberTrailStack)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
        int sync = (Integer)stack.method_57825((class_9331)ModComponents.AUTO_SYNC_COLOR.get(), (Object)-1);
        int color = sync == -1 || !BeatmapManager.hasNearbyActiveBeatmap(basePos) ? (Integer)stack.method_57825((class_9331)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)0) + -16777216 : (sync == 0 ? BeatmapManager.nearestActiveBeatmap((Vector3f)basePos).difficulty.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapManager.nearestActiveBeatmap((Vector3f)basePos).difficulty.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
        SaberRenderer.queueRender(hiltPos, tipPos, cycleStack, color);
    }

    public static void renderTrail(boolean doCollisionCheck, class_4587 matrix, boolean mainHand, class_742 player, float tickDelta, class_1799 stack) {
        if (stack.method_31574(ModItems.SABER_ITEM)) {
            Quaternionf rotation;
            Vector3f translation;
            matrix.method_22905(0.3333f, 0.3333f, 0.3333f);
            matrix.method_22904(0.0, -0.25, 0.35);
            matrix.method_22907(new Quaternionf().rotationXYZ(-0.7853982f, 0.0f, 0.0f));
            ControllerProfile profile = BeatcraftClient.playerConfig.controller.activeProfile();
            if (player.method_6068() == class_1306.field_6183 && mainHand || player.method_6068() == class_1306.field_6182 && !mainHand) {
                translation = profile.getRightTranslation();
                rotation = profile.getRightRotation();
                boolean rightHand = true;
            } else {
                translation = profile.getLeftTranslation();
                rotation = profile.getLeftRotation();
                boolean rightHand = false;
            }
            matrix.method_46416(translation.x, translation.y, translation.z);
            matrix.method_22907(rotation);
            if (doCollisionCheck) {
                matrix.method_22903();
                matrix.method_22904(0.0, 0.525, 0.0);
                Vector3f blade_base = matrix.method_23760().method_23761().getTranslation(new Vector3f());
                matrix.method_22909();
                matrix.method_22903();
                matrix.method_22904(0.0, 3.0749999999999997, 0.0);
                Vector3f blade_tip = matrix.method_23760().method_23761().getTranslation(new Vector3f());
                matrix.method_22909();
                Vector3f playerPos = class_310.method_1551().field_1773.method_19418().method_19326().method_46409();
                blade_tip.add((Vector3fc)playerPos);
                blade_base.add((Vector3fc)playerPos);
                CycleStack<Pair<Vector3f, Vector3f>> stash = ((ItemStackWithSaberTrailStack)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
                int sync = (Integer)stack.method_57825((class_9331)ModComponents.AUTO_SYNC_COLOR.get(), (Object)-1);
                int color = sync == -1 || !BeatmapManager.hasNearbyActiveBeatmap(blade_base) ? (Integer)stack.method_57825((class_9331)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)0) + -16777216 : (sync == 0 ? BeatmapManager.nearestActiveBeatmap((Vector3f)blade_base).difficulty.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapManager.nearestActiveBeatmap((Vector3f)blade_base).difficulty.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
                if (stash != null) {
                    SaberRenderer.queueRender(blade_base, blade_tip, stash, color);
                }
            }
        }
    }

    public static void renderItemEntityTrail(class_1542 entity, float tickDelta, class_1087 bakedModel) {
        class_1799 stack = entity.method_6983();
        if (stack.method_31574(ModItems.SABER_ITEM)) {
            class_4587 matrix = new class_4587();
            float j = class_3532.method_15374((float)(((float)entity.method_6985() + tickDelta) / 10.0f + entity.field_7203)) * 0.1f + 0.1f;
            float k = bakedModel.method_4709().method_3503((class_811)class_811.field_4318).field_4285.y();
            matrix.method_46416(0.0f, j + 0.25f * k, 0.0f);
            float l = entity.method_27314(tickDelta);
            matrix.method_22907(new Quaternionf().rotateAxis(l, 0.0f, 1.0f, 0.0f));
            matrix.method_22903();
            bakedModel.method_4709().method_3503(class_811.field_4318).method_23075(false, matrix);
            matrix.method_22903();
            matrix.method_22904(0.0, 1.05, 0.0);
            Vector3f blade_base = matrix.method_23760().method_23761().getTranslation(new Vector3f());
            matrix.method_22909();
            matrix.method_22903();
            matrix.method_22904(0.0, 3.0749999999999997, 0.0);
            Vector3f blade_tip = matrix.method_23760().method_23761().getTranslation(new Vector3f());
            matrix.method_22909();
            Vector3f pos = entity.method_30950(tickDelta).method_46409();
            blade_base.add((Vector3fc)pos);
            blade_tip.add((Vector3fc)pos);
            CycleStack<Pair<Vector3f, Vector3f>> stash = ((ItemStackWithSaberTrailStack)stack).beatcraft$getTrailStash(ClientDataHolderVR.getInstance().currentPass);
            int sync = (Integer)stack.method_57825((class_9331)ModComponents.AUTO_SYNC_COLOR.get(), (Object)-1);
            int color = sync == -1 || !BeatmapManager.hasNearbyActiveBeatmap(blade_base) ? (Integer)stack.method_57825((class_9331)ModComponents.SABER_COLOR_COMPONENT.get(), (Object)0) + -16777216 : (sync == 0 ? BeatmapManager.nearestActiveBeatmap((Vector3f)blade_base).difficulty.getSetDifficulty().getColorScheme().getNoteLeftColor().toARGB() : BeatmapManager.nearestActiveBeatmap((Vector3f)blade_base).difficulty.getSetDifficulty().getColorScheme().getNoteRightColor().toARGB());
            if (stash != null) {
                SaberRenderer.queueRender(blade_base, blade_tip, stash, color);
            }
        }
    }

    public static void queueRender(Vector3f blade_base, Vector3f blade_tip, CycleStack<Pair<Vector3f, Vector3f>> cycleStack, int col) {
        Function<class_287, Void> callable = trail_buffer -> {
            SaberRenderer.render(blade_base, blade_tip, cycleStack, col, trail_buffer);
            return null;
        };
        render_calls.add(callable);
    }

    public static void renderAll() {
        SaberRenderer.renderOtherPlayerSabers();
        if (render_calls.isEmpty()) {
            return;
        }
        class_289 tesselator = class_289.method_1348();
        class_287 trail_buffer = tesselator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        for (Function<class_287, Void> runnable : render_calls) {
            runnable.apply(trail_buffer);
        }
        class_9801 buffer = trail_buffer.method_60794();
        render_calls.clear();
        if (buffer != null) {
            buffer.method_60819(((BufferBuilderAccessor)trail_buffer).beatcraft$getAllocator(), class_8251.field_43361);
            class_286.method_43433((class_9801)buffer);
        }
        RenderSystem.disableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
    }

    public static void render(Vector3f blade_base, Vector3f blade_tip, CycleStack<Pair<Vector3f, Vector3f>> cycleStack, int col, class_287 trail_buffer) {
        if (cycleStack.getSize() <= 3) {
            return;
        }
        Vector3f current_base = blade_base;
        Vector3f current_tip = blade_tip;
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        if (!cycleStack.isEmpty()) {
            int opacity = 0;
            float step = 127.0f / (float)cycleStack.getSize();
            for (Pair<Vector3f, Vector3f> ab : cycleStack) {
                Vector3f a = (Vector3f)ab.getA();
                Vector3f b = (Vector3f)ab.getB();
                int op = 127 - (int)(step * (float)opacity) << 24;
                int op2 = 127 - (int)(step * (float)(opacity + 1)) << 24;
                ++opacity;
                if (op == 0 || op2 == 0) continue;
                trail_buffer.method_22912((float)((double)current_base.x - cam.field_1352), (float)((double)current_base.y - cam.field_1351), (float)((double)current_base.z - cam.field_1350)).method_39415(col + op);
                trail_buffer.method_22912((float)((double)a.x - cam.field_1352), (float)((double)a.y - cam.field_1351), (float)((double)a.z - cam.field_1350)).method_39415(col + op2);
                trail_buffer.method_22912((float)((double)b.x - cam.field_1352), (float)((double)b.y - cam.field_1351), (float)((double)b.z - cam.field_1350)).method_39415(col + op2);
                trail_buffer.method_22912((float)((double)current_tip.x - cam.field_1352), (float)((double)current_tip.y - cam.field_1351), (float)((double)current_tip.z - cam.field_1350)).method_39415(col + op);
                current_base = a;
                current_tip = b;
            }
        }
        cycleStack.push((Pair<Vector3f, Vector3f>)new Pair((Object)blade_base, (Object)blade_tip));
    }
}

