/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.gl;

import com.beatcraft.common.data.types.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;

public class GlUtil {
    private static final Map<String, Integer> shaderProgramCache = new HashMap<String, Integer>();
    private static final Pattern qcBlock = Pattern.compile("#QUEST.*?#ENDQUEST", 32);
    private static final Pattern pcBlock = Pattern.compile("#PC.*?#ENDPC", 32);
    private static final HashMap<Integer, HashMap<String, Object>> programUniformsCache = new HashMap();
    private static int currentProgram;

    public static int createShaderProgram(String vshSource, String fshSource) {
        int program = GL31.glCreateProgram();
        try {
            int vertexShader = GlUtil.compileShader(35633, vshSource);
            int fragmentShader = GlUtil.compileShader(35632, fshSource);
            GL31.glAttachShader((int)program, (int)vertexShader);
            GL31.glAttachShader((int)program, (int)fragmentShader);
            GL31.glLinkProgram((int)program);
            if (GL31.glGetProgrami((int)program, (int)35714) == 0) {
                String log = GL31.glGetProgramInfoLog((int)program);
                throw new RuntimeException("Failed to link shader program: " + log);
            }
            GL31.glValidateProgram((int)program);
            if (GL31.glGetProgrami((int)program, (int)35715) == 0) {
                String log = GL31.glGetProgramInfoLog((int)program);
                throw new RuntimeException("Failed to validate shader program: " + log);
            }
            GL31.glDetachShader((int)program, (int)vertexShader);
            GL31.glDetachShader((int)program, (int)fragmentShader);
            GL31.glDeleteShader((int)vertexShader);
            GL31.glDeleteShader((int)fragmentShader);
            return program;
        }
        catch (Exception e) {
            GL31.glDeleteProgram((int)program);
            throw new RuntimeException("Failed to create shader program", e);
        }
    }

    public static int createShaderProgram(class_2960 vertexShaderLoc, class_2960 fragmentShaderLoc) {
        return GlUtil.createShaderProgram(vertexShaderLoc, fragmentShaderLoc, GlUtil::reProcess);
    }

    public static int createShaderProgram(class_2960 vertexShaderLoc, class_2960 fragmentShaderLoc, Function<String, String> shaderProcessor) {
        int program = GL31.glCreateProgram();
        try {
            int vertexShader = GlUtil.compileShader(35633, vertexShaderLoc, shaderProcessor);
            int fragmentShader = GlUtil.compileShader(35632, fragmentShaderLoc, shaderProcessor);
            GL31.glAttachShader((int)program, (int)vertexShader);
            GL31.glAttachShader((int)program, (int)fragmentShader);
            GL31.glLinkProgram((int)program);
            if (GL31.glGetProgrami((int)program, (int)35714) == 0) {
                String log = GL31.glGetProgramInfoLog((int)program);
                throw new RuntimeException("Failed to link shader program: " + log);
            }
            GL31.glValidateProgram((int)program);
            if (GL31.glGetProgrami((int)program, (int)35715) == 0) {
                String log = GL31.glGetProgramInfoLog((int)program);
                throw new RuntimeException("Failed to validate shader program: " + log);
            }
            GL31.glDetachShader((int)program, (int)vertexShader);
            GL31.glDetachShader((int)program, (int)fragmentShader);
            GL31.glDeleteShader((int)vertexShader);
            GL31.glDeleteShader((int)fragmentShader);
            return program;
        }
        catch (Exception e) {
            GL31.glDeleteProgram((int)program);
            throw new RuntimeException("Failed to create shader program", e);
        }
    }

    public static String reProcess(String shader) {
        String vendor = GL31.glGetString((int)7936);
        if (vendor != null && vendor.contains("QuestCraft")) {
            Matcher m = pcBlock.matcher(shader);
            shader = m.replaceAll("").replace("#QUEST", "").replace("#ENDQUEST", "").trim();
        } else {
            Matcher m = qcBlock.matcher(shader);
            shader = m.replaceAll("").replace("#PC", "").replace("#ENDPC", "").trim();
        }
        return shader;
    }

    public static int compileShader(int type, String source) {
        source = GlUtil.reProcess(source);
        int shader = GL31.glCreateShader((int)type);
        GL31.glShaderSource((int)shader, (CharSequence)source);
        GL31.glCompileShader((int)shader);
        if (GL31.glGetShaderi((int)shader, (int)35713) == 0) {
            String log = GL31.glGetShaderInfoLog((int)shader);
            GL31.glDeleteShader((int)shader);
            throw new RuntimeException("Failed to compile shader: " + log);
        }
        return shader;
    }

    public static int compileShader(int type, class_2960 shaderLoc) throws IOException {
        return GlUtil.compileShader(type, shaderLoc, GlUtil::reProcess);
    }

    public static int compileShader(int type, class_2960 shaderLoc, Function<String, String> preProcessor) throws IOException {
        int shader = GL31.glCreateShader((int)type);
        class_3300 resourceManager = class_310.method_1551().method_1478();
        String source = ((class_3298)resourceManager.method_14486(shaderLoc).orElseThrow(() -> new IOException("Could not find shader: " + String.valueOf(shaderLoc)))).method_43039().lines().collect(Collectors.joining("\n"));
        source = preProcessor.apply(source);
        GL31.glShaderSource((int)shader, (CharSequence)source);
        GL31.glCompileShader((int)shader);
        if (GL31.glGetShaderi((int)shader, (int)35713) == 0) {
            String log = GL31.glGetShaderInfoLog((int)shader);
            GL31.glDeleteShader((int)shader);
            throw new RuntimeException("Failed to compile shader: " + log);
        }
        return shader;
    }

    public static int getOrCreateShaderProgram(class_2960 vertexShaderLoc, class_2960 fragmentShaderLoc) {
        String cacheKey = vertexShaderLoc.method_12836() + ":" + vertexShaderLoc.method_12832() + "_" + fragmentShaderLoc.method_12832();
        return shaderProgramCache.computeIfAbsent(cacheKey, k -> GlUtil.createShaderProgram(vertexShaderLoc, fragmentShaderLoc));
    }

    public static void destroyShaderProgram(class_2960 vertexShaderLoc, class_2960 fragmentShaderLoc) {
        String cacheKey = vertexShaderLoc.method_12836() + ":" + vertexShaderLoc.method_12832() + "_" + fragmentShaderLoc.method_12832();
        if (shaderProgramCache.containsKey(cacheKey)) {
            Integer program = shaderProgramCache.remove(cacheKey);
            GL31.glDeleteProgram((int)program);
            programUniformsCache.remove(program);
            if (currentProgram == program) {
                currentProgram = 0;
            }
        }
    }

    public static void destroyShaderProgram(int program) {
        AtomicReference toRemove = new AtomicReference();
        shaderProgramCache.forEach((key, val) -> {
            if (val == program) {
                toRemove.set(key);
            }
        });
        String remove = (String)toRemove.get();
        if (remove != null) {
            shaderProgramCache.remove(remove);
            GL30.glDeleteProgram((int)program);
        }
    }

    public static void clear() {
        shaderProgramCache.clear();
        programUniformsCache.clear();
    }

    public static void setMat4f(int shaderProgram, String uni, Matrix4f mat4) {
        int uniLoc = GL31.glGetUniformLocation((int)shaderProgram, (CharSequence)uni);
        GL31.glUniformMatrix4fv((int)uniLoc, (boolean)false, (float[])mat4.get(new float[16]));
    }

    public static void setTex(int program, String name, int textureSlot, int glId) {
        GL31.glActiveTexture((int)(33984 + textureSlot));
        int loc = GL31.glGetUniformLocation((int)program, (CharSequence)name);
        GL31.glBindTexture((int)3553, (int)glId);
        GL31.glUniform1i((int)loc, (int)textureSlot);
    }

    public static void useProgram(int program) {
        currentProgram = program;
        GL31.glUseProgram((int)program);
    }

    public static boolean cacheUni(int program, String name, Object value) {
        HashMap<String, Object> uniCache;
        if (!programUniformsCache.containsKey(program)) {
            programUniformsCache.put(program, new HashMap());
        }
        if ((uniCache = programUniformsCache.get(program)).containsKey(name) && Objects.deepEquals(uniCache.get(name), value)) {
            return false;
        }
        uniCache.put(name, value);
        return true;
    }

    public static void uniformTex(String name, int textureSlot, int glId) {
        GlUtil.setTex(currentProgram, name, textureSlot, glId);
    }

    public static void uniform1f(String name, float value) {
        if (GlUtil.cacheUni(currentProgram, name, Float.valueOf(value))) {
            int loc = GL31.glGetUniformLocation((int)currentProgram, (CharSequence)name);
            GL31.glUniform1f((int)loc, (float)value);
        }
    }

    public static void uniform1i(String name, int value) {
        if (GlUtil.cacheUni(currentProgram, name, value)) {
            int loc = GL31.glGetUniformLocation((int)currentProgram, (CharSequence)name);
            GL31.glUniform1i((int)loc, (int)value);
        }
    }

    public static void uniform2f(String name, float f0, float f1) {
        if (GlUtil.cacheUni(currentProgram, name, new float[]{f0, f1})) {
            int loc = GL31.glGetUniformLocation((int)currentProgram, (CharSequence)name);
            GL31.glUniform2f((int)loc, (float)f0, (float)f1);
        }
    }

    public static void uniform3f(String name, float f0, float f1, float f2) {
        if (GlUtil.cacheUni(currentProgram, name, new float[]{f0, f1, f2})) {
            int loc = GL31.glGetUniformLocation((int)currentProgram, (CharSequence)name);
            GL31.glUniform3f((int)loc, (float)f0, (float)f1, (float)f2);
        }
    }

    public static void uniform4f(String name, float f0, float f1, float f2, float f3) {
        if (GlUtil.cacheUni(currentProgram, name, new float[]{f0, f1, f2, f3})) {
            int loc = GL31.glGetUniformLocation((int)currentProgram, (CharSequence)name);
            GL31.glUniform4f((int)loc, (float)f0, (float)f1, (float)f2, (float)f3);
        }
    }

    public static void uniformMat4f(String name, Matrix4f mat4) {
        if (GlUtil.cacheUni(currentProgram, name, mat4)) {
            programUniformsCache.get(currentProgram).put(name, new Matrix4f((Matrix4fc)mat4));
            GlUtil.setMat4f(currentProgram, name, mat4);
        }
    }

    public static void uniformColor(String name, Color color) {
        GlUtil.uniform4f(name, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }
}

