/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing;

import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.instancing.DrawPass;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.common.data.types.Color;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.GL20;

public class ArrowInstanceData
implements InstancedMesh.InstanceData {
    private final Matrix4f transform;
    private final Color color;
    private float dissolve;
    private int index;
    private static final ArrayList<ArrowInstanceData> sharedCache = new ArrayList();
    private static final int TRANSFORM_LOCATION = 3;
    private static final int COLOR_LOCATION = 7;
    private static final int DISSOLVE_INDEX_LOCATION = 8;

    private ArrowInstanceData(Matrix4f transform, Color color, float dissolve, int index) {
        this.transform = new Matrix4f((Matrix4fc)transform);
        this.color = color;
        this.dissolve = dissolve;
        this.index = index;
    }

    public static ArrowInstanceData create(Matrix4f transform, Color color, float dissolve, int index) {
        if (sharedCache.isEmpty()) {
            return new ArrowInstanceData(new Matrix4f((Matrix4fc)transform), new Color(color), dissolve, index);
        }
        ArrowInstanceData x = sharedCache.removeLast();
        x.transform.set((Matrix4fc)transform);
        x.color.set(color);
        x.dissolve = dissolve;
        x.index = index;
        return x;
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    @Override
    public ArrowInstanceData copy() {
        return ArrowInstanceData.create(this.transform, this.color, this.dissolve, this.index);
    }

    @Override
    public void free() {
        sharedCache.add(this);
    }

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    @Override
    public int getFrameSize() {
        return 24;
    }

    @Override
    public int[] getLocations() {
        return new int[]{3, 4, 5, 6, 7, 8};
    }

    @Override
    public void putData(FloatBuffer buffer) {
        buffer.put(this.transform.m00()).put(this.transform.m01()).put(this.transform.m02()).put(this.transform.m03());
        buffer.put(this.transform.m10()).put(this.transform.m11()).put(this.transform.m12()).put(this.transform.m13());
        buffer.put(this.transform.m20()).put(this.transform.m21()).put(this.transform.m22()).put(this.transform.m23());
        buffer.put(this.transform.m30()).put(this.transform.m31()).put(this.transform.m32()).put(this.transform.m33());
        Color c = this.color;
        buffer.put(c.getRed()).put(c.getGreen()).put(c.getBlue()).put(c.getAlpha());
        buffer.put(this.dissolve);
        buffer.put(this.index);
        buffer.put(0.0f).put(0.0f);
    }

    @Override
    public void init() {
        int stride = this.getFrameSize() * 4;
        for (int i = 0; i < 4; ++i) {
            int location = 3 + i;
            GL20.glVertexAttribPointer((int)location, (int)4, (int)5126, (boolean)false, (int)stride, (long)(i * 4 * 4));
            GL20.glEnableVertexAttribArray((int)location);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)location, (int)1);
        }
        GL20.glVertexAttribPointer((int)7, (int)4, (int)5126, (boolean)false, (int)stride, (long)64L);
        GL20.glEnableVertexAttribArray((int)7);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)7, (int)1);
        GL20.glVertexAttribPointer((int)8, (int)2, (int)5126, (boolean)false, (int)stride, (long)80L);
        GL20.glEnableVertexAttribArray((int)8);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)8, (int)1);
    }

    @Override
    public void setup(int program, DrawPass pass) {
        GlUtil.uniform1i("u_pass", pass.ordinal());
        if (pass == DrawPass.Bloom) {
            GlUtil.setTex(program, "u_depth", 1, Bloomfog.sceneDepthBuffer);
        }
    }

    @Override
    public void cleanup() {
    }
}

