/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing;

import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.common.data.types.Color;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.GL20;

public class ColorNoteInstanceData
implements InstancedMesh.InstanceData {
    private final Matrix4f transform;
    private final Color color;
    private float dissolve;
    private int index;
    private final Vector4f slicePosition;
    private static final ArrayList<ColorNoteInstanceData> sharedCache = new ArrayList();
    private static final Vector4f ZERO = new Vector4f(0.0f);
    private static final int TRANSFORM_LOCATION = 3;
    private static final int COLOR_LOCATION = 7;
    private static final int DISSOLVE_INDEX_LOCATION = 8;
    private static final int SLICE_LOCATION = 9;

    private ColorNoteInstanceData(Matrix4f transform, Color color, float dissolve, int index, Vector4f slicePosition) {
        this.transform = transform;
        this.color = color;
        this.dissolve = dissolve;
        this.index = index;
        this.slicePosition = slicePosition;
    }

    public static ColorNoteInstanceData create(Matrix4f transform, Color color, float dissolve, int index, Vector4f slicePosition) {
        if (sharedCache.isEmpty()) {
            return new ColorNoteInstanceData(new Matrix4f((Matrix4fc)transform), new Color(color), dissolve, index, new Vector4f((Vector4fc)slicePosition));
        }
        ColorNoteInstanceData x = sharedCache.removeLast();
        x.transform.set((Matrix4fc)transform);
        x.color.set(color);
        x.dissolve = dissolve;
        x.index = index;
        x.slicePosition.set((Vector4fc)slicePosition);
        return x;
    }

    @Override
    public ColorNoteInstanceData copy() {
        return ColorNoteInstanceData.create(this.transform, this.color, this.dissolve, this.index, this.slicePosition);
    }

    @Override
    public void free() {
        sharedCache.add(this);
    }

    public static ColorNoteInstanceData create(Matrix4f transform, Color color, float dissolve, int index) {
        return ColorNoteInstanceData.create(transform, color, dissolve, index, ZERO);
    }

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    @Override
    public void putData(FloatBuffer buffer) {
        buffer.put(this.transform.m00()).put(this.transform.m01()).put(this.transform.m02()).put(this.transform.m03());
        buffer.put(this.transform.m10()).put(this.transform.m11()).put(this.transform.m12()).put(this.transform.m13());
        buffer.put(this.transform.m20()).put(this.transform.m21()).put(this.transform.m22()).put(this.transform.m23());
        buffer.put(this.transform.m30()).put(this.transform.m31()).put(this.transform.m32()).put(this.transform.m33());
        buffer.put(this.color.getRed()).put(this.color.getGreen()).put(this.color.getBlue()).put(this.color.getAlpha());
        buffer.put(this.dissolve);
        buffer.put(this.index);
        buffer.put(0.0f).put(0.0f);
        buffer.put(this.slicePosition.x).put(this.slicePosition.y).put(this.slicePosition.z).put(this.slicePosition.w);
    }

    @Override
    public int getFrameSize() {
        return 28;
    }

    @Override
    public int[] getLocations() {
        return new int[]{3, 4, 5, 6, 7, 8, 9};
    }

    @Override
    public void init() {
        int stride = this.getFrameSize() * 4;
        for (int i = 0; i < 4; ++i) {
            int location = 3 + i;
            GL20.glVertexAttribPointer((int)location, (int)4, (int)5126, (boolean)false, (int)stride, (long)(i * 4 * 4));
            GL20.glEnableVertexAttribArray((int)location);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)location, (int)1);
        }
        GL20.glVertexAttribPointer((int)7, (int)4, (int)5126, (boolean)false, (int)stride, (long)64L);
        GL20.glEnableVertexAttribArray((int)7);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)7, (int)1);
        GL20.glVertexAttribPointer((int)8, (int)2, (int)5126, (boolean)false, (int)stride, (long)80L);
        GL20.glEnableVertexAttribArray((int)8);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)8, (int)1);
        GL20.glVertexAttribPointer((int)9, (int)4, (int)5126, (boolean)false, (int)stride, (long)96L);
        GL20.glEnableVertexAttribArray((int)9);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)9, (int)1);
    }

    @Override
    public void setup(int program) {
    }

    @Override
    public void cleanup() {
    }
}

