/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing;

import com.beatcraft.client.lightshow.lights.CompoundTransformState;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.memory.MemoryPool;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.apache.commons.lang3.function.TriFunction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.GL20;

public class GlowingCuboidInstanceData
implements InstancedMesh.InstanceData {
    private static final ArrayList<GlowingCuboidInstanceData> sharedCache = new ArrayList();
    private Matrix4f transform;
    private Color color;
    private int TRANSFORM_LOCATION = 3;
    private int COLOR_LOCATION = 7;

    private GlowingCuboidInstanceData(Matrix4f transform, Color color) {
        this.transform = new Matrix4f((Matrix4fc)transform);
        this.color = new Color(color);
    }

    public static GlowingCuboidInstanceData create(boolean mirrorDraw, Hitbox dimensions, Quaternionf orientation, Quaternionf rotation, Quaternionf rotation2, CompoundTransformState transformState, Vector3f position, Quaternionf worldRotation, Vector3f offset, Vector3f cameraPos, Color color, CompoundTransformState.Swizzle translationSwizzle, CompoundTransformState.Polarity translationPolarity, CompoundTransformState.Swizzle rotationSwizzle, CompoundTransformState.Polarity rotationPolarity, TriFunction<Float, Float, Float, Quaternionf> memoryPooledSwizzledQuaternionFactory) {
        if (sharedCache.isEmpty()) {
            Matrix4f mat = new Matrix4f();
            GlowingCuboidInstanceData.applyTransform(mat, dimensions, mirrorDraw, orientation, rotation, rotation2, transformState, position, worldRotation, offset, cameraPos, translationSwizzle, translationPolarity, rotationSwizzle, rotationPolarity, memoryPooledSwizzledQuaternionFactory);
            return new GlowingCuboidInstanceData(mat, new Color(color));
        }
        GlowingCuboidInstanceData x = sharedCache.removeLast();
        GlowingCuboidInstanceData.applyTransform(x.transform, dimensions, mirrorDraw, orientation, rotation, rotation2, transformState, position, worldRotation, offset, cameraPos, translationSwizzle, translationPolarity, rotationSwizzle, rotationPolarity, memoryPooledSwizzledQuaternionFactory);
        x.color.set(color);
        return x;
    }

    private static void mirrorQuat(boolean mirror, Quaternionf src, Quaternionf dest) {
        dest.set(mirror ? -src.x : src.x, src.y, mirror ? -src.z : src.z, src.w);
    }

    private static void applyTransform(Matrix4f mat, Hitbox dimensions, boolean mirrorDraw, Quaternionf ori, Quaternionf rot, Quaternionf rot2, CompoundTransformState transformState, Vector3f pos, Quaternionf worldRot, Vector3f offset, Vector3f cameraPos, CompoundTransformState.Swizzle translationSwizzle, CompoundTransformState.Polarity translationPolarity, CompoundTransformState.Swizzle rotationSwizzle, CompoundTransformState.Polarity rotationPolarity, TriFunction<Float, Float, Float, Quaternionf> memoryPooledSwizzledQuaternionFactory) {
        mat.identity();
        mat.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        Vector3f translation = MemoryPool.newVector3f();
        transformState.getTranslation(translationSwizzle, translationPolarity, translation);
        mat.translate(translation.x, mirrorDraw ? -translation.y : translation.y, translation.z);
        MemoryPool.releaseSafe(translation);
        mat.translate(offset.x, mirrorDraw ? -offset.y : offset.y, offset.z);
        Quaternionf mirrorWorld = MemoryPool.newQuaternionf();
        GlowingCuboidInstanceData.mirrorQuat(mirrorDraw, worldRot, mirrorWorld);
        mat.rotate((Quaternionfc)mirrorWorld);
        MemoryPool.releaseSafe(mirrorWorld);
        mat.translate(pos.x, mirrorDraw ? -pos.y : pos.y, pos.z);
        Quaternionf q = MemoryPool.newQuaternionf();
        GlowingCuboidInstanceData.mirrorQuat(mirrorDraw, rot2, q);
        mat.rotate((Quaternionfc)q);
        GlowingCuboidInstanceData.mirrorQuat(mirrorDraw, rot, q);
        mat.rotate((Quaternionfc)q);
        Quaternionf q2 = transformState.getOrientation(rotationSwizzle, rotationPolarity, memoryPooledSwizzledQuaternionFactory);
        GlowingCuboidInstanceData.mirrorQuat(mirrorDraw, q2, q);
        MemoryPool.releaseSafe(q2);
        mat.rotate((Quaternionfc)q);
        GlowingCuboidInstanceData.mirrorQuat(mirrorDraw, ori, q);
        mat.rotate((Quaternionfc)q);
        MemoryPool.releaseSafe(q);
        Vector3f hbCenter = MemoryPool.newVector3f();
        Vector3f hbExtents = MemoryPool.newVector3f();
        dimensions.getVisualCenter(hbCenter);
        dimensions.getVisualExtents(hbExtents);
        mat.translate((Vector3fc)hbCenter);
        mat.scale((Vector3fc)hbExtents);
        MemoryPool.releaseSafe(hbCenter, hbExtents);
    }

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    @Override
    public void putData(FloatBuffer buffer) {
        buffer.put(this.transform.m00()).put(this.transform.m01()).put(this.transform.m02()).put(this.transform.m03());
        buffer.put(this.transform.m10()).put(this.transform.m11()).put(this.transform.m12()).put(this.transform.m13());
        buffer.put(this.transform.m20()).put(this.transform.m21()).put(this.transform.m22()).put(this.transform.m23());
        buffer.put(this.transform.m30()).put(this.transform.m31()).put(this.transform.m32()).put(this.transform.m33());
        buffer.put(this.color.getRed()).put(this.color.getGreen()).put(this.color.getBlue()).put(this.color.getAlpha());
    }

    @Override
    public int getFrameSize() {
        return 20;
    }

    @Override
    public void init() {
        int stride = this.getFrameSize() * 4;
        for (int i = 0; i < 4; ++i) {
            int location = this.TRANSFORM_LOCATION + i;
            GL20.glVertexAttribPointer((int)location, (int)4, (int)5126, (boolean)false, (int)stride, (long)(i * 4 * 4));
            GL20.glEnableVertexAttribArray((int)location);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)location, (int)1);
        }
        GL20.glVertexAttribPointer((int)this.COLOR_LOCATION, (int)4, (int)5126, (boolean)false, (int)stride, (long)64L);
        GL20.glEnableVertexAttribArray((int)this.COLOR_LOCATION);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)this.COLOR_LOCATION, (int)1);
    }

    @Override
    public int[] getLocations() {
        return new int[]{this.TRANSFORM_LOCATION, this.TRANSFORM_LOCATION + 1, this.TRANSFORM_LOCATION + 2, this.TRANSFORM_LOCATION + 3, this.COLOR_LOCATION};
    }

    @Override
    public void setup(int program) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void free() {
        sharedCache.add(this);
    }

    @Override
    public InstancedMesh.InstanceData copy() {
        return new GlowingCuboidInstanceData(new Matrix4f((Matrix4fc)this.transform), new Color(this.color));
    }
}

