/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.instancing.DrawPass;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.GL20;

public class HeadsetInstanceData
implements InstancedMesh.InstanceData {
    private final Matrix4f transform;
    private static final ArrayList<HeadsetInstanceData> sharedCache = new ArrayList();
    private static final int TRANSFORM_LOCATION = 3;
    private static final int[] LOCATIONS = new int[]{3};
    private static final class_2960 BLOOM_MAP = Beatcraft.id("textures/item/headset_bloom_map.png");

    private HeadsetInstanceData(Matrix4f transform) {
        this.transform = transform;
    }

    public static HeadsetInstanceData create(Matrix4f transform) {
        if (sharedCache.isEmpty()) {
            return new HeadsetInstanceData(new Matrix4f((Matrix4fc)transform));
        }
        HeadsetInstanceData x = sharedCache.removeLast();
        x.transform.set((Matrix4fc)transform);
        return x;
    }

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    @Override
    public void putData(FloatBuffer buffer) {
        buffer.put(this.transform.m00()).put(this.transform.m01()).put(this.transform.m02()).put(this.transform.m03());
        buffer.put(this.transform.m10()).put(this.transform.m11()).put(this.transform.m12()).put(this.transform.m13());
        buffer.put(this.transform.m20()).put(this.transform.m21()).put(this.transform.m22()).put(this.transform.m23());
        buffer.put(this.transform.m30()).put(this.transform.m31()).put(this.transform.m32()).put(this.transform.m33());
    }

    @Override
    public int getFrameSize() {
        return 16;
    }

    @Override
    public void init() {
        int stride = this.getFrameSize() * 4;
        for (int i = 0; i < 4; ++i) {
            int location = 3 + i;
            GL20.glVertexAttribPointer((int)location, (int)4, (int)5126, (boolean)false, (int)stride, (long)(i * 4 * 4));
            GL20.glEnableVertexAttribArray((int)location);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)location, (int)1);
        }
    }

    @Override
    public int[] getLocations() {
        return LOCATIONS;
    }

    @Override
    public void free() {
        sharedCache.add(this);
    }

    @Override
    public void setup(int program, DrawPass pass) {
        GlUtil.uniform1i("u_pass", pass.ordinal());
        if (pass == DrawPass.Bloom) {
            class_1060 manager = class_310.method_1551().method_1531();
            class_1044 aTex = manager.method_4619(BLOOM_MAP);
            RenderSystem.setShaderTexture((int)2, (class_2960)BLOOM_MAP);
            GlUtil.setTex(program, "u_depth", 1, Bloomfog.sceneDepthBuffer);
            GlUtil.setTex(program, "u_bloom_map", 2, aTex.method_4624());
        }
        RenderSystem.enableBlend();
    }

    @Override
    public void cleanup() {
        RenderSystem.disableCull();
    }

    @Override
    public InstancedMesh.InstanceData copy() {
        return HeadsetInstanceData.create(this.transform);
    }
}

