/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing;

import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.client.render.gl.GlUtil;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.common.memory.MemoryPool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.GL31;

public class SmokeInstanceData
implements InstancedMesh.InstanceData {
    private final Matrix4f transform;
    private float delta;
    private static final int TRANSFORM_LOCATION = 3;
    private static final int DELTA_LOCATION = 7;
    private static final ArrayList<SmokeInstanceData> sharedCache = new ArrayList();
    private Quaternionf rot;
    private Vector3f pos;

    private SmokeInstanceData(Quaternionf orientation, Vector3f cameraPos, float delta) {
        this.rot = orientation;
        this.pos = cameraPos;
        Vector3f v = MemoryPool.newVector3f();
        this.transform = new Matrix4f().translate((Vector3fc)cameraPos.negate(v)).rotate((Quaternionfc)orientation);
        MemoryPool.releaseSafe(v);
        this.delta = delta;
    }

    public static SmokeInstanceData create(Quaternionf orientation, Vector3f cameraPos, float delta) {
        if (sharedCache.isEmpty()) {
            return new SmokeInstanceData(new Quaternionf((Quaternionfc)orientation), new Vector3f((Vector3fc)cameraPos), delta);
        }
        SmokeInstanceData x = sharedCache.removeLast();
        Vector3f v = MemoryPool.newVector3f();
        x.transform.identity().translate((Vector3fc)cameraPos.negate(v)).rotate((Quaternionfc)orientation);
        MemoryPool.releaseSafe(v);
        x.delta = delta;
        x.rot = orientation;
        x.pos = cameraPos;
        return x;
    }

    @Override
    public InstancedMesh.InstanceData copy() {
        return SmokeInstanceData.create(this.rot, this.pos, this.delta);
    }

    @Override
    public void free() {
        sharedCache.add(this);
    }

    @Override
    public Matrix4f getTransform() {
        return this.transform;
    }

    @Override
    public void putData(FloatBuffer buffer) {
        buffer.put(this.transform.m00()).put(this.transform.m01()).put(this.transform.m02()).put(this.transform.m03());
        buffer.put(this.transform.m10()).put(this.transform.m11()).put(this.transform.m12()).put(this.transform.m13());
        buffer.put(this.transform.m20()).put(this.transform.m21()).put(this.transform.m22()).put(this.transform.m23());
        buffer.put(this.transform.m30()).put(this.transform.m31()).put(this.transform.m32()).put(this.transform.m33());
        buffer.put(this.delta).put(0.0f).put(0.0f).put(0.0f);
    }

    @Override
    public int getFrameSize() {
        return 20;
    }

    @Override
    public void init() {
        int stride = this.getFrameSize() * 4;
        for (int i = 0; i < 4; ++i) {
            int location = 3 + i;
            GL31.glVertexAttribPointer((int)location, (int)4, (int)5126, (boolean)false, (int)stride, (long)(i * 4 * 4));
            GL31.glEnableVertexAttribArray((int)location);
            ARBInstancedArrays.glVertexAttribDivisorARB((int)location, (int)1);
        }
        GL31.glVertexAttribPointer((int)7, (int)1, (int)5126, (boolean)false, (int)stride, (long)64L);
        GL31.glEnableVertexAttribArray((int)7);
        ARBInstancedArrays.glVertexAttribDivisorARB((int)7, (int)1);
    }

    @Override
    public int[] getLocations() {
        return new int[]{3, 4, 5, 6, 7};
    }

    @Override
    public void setup(int program) {
        int depthBuffer = Bloomfog.sceneDepthBuffer;
        GlUtil.setTex(program, "u_depth", 1, depthBuffer);
        GlUtil.setTex(program, "u_bloomfog", 2, BeatcraftRenderer.bloomfog.getBloomfogColorAttachment());
        GL31.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL31.glTexParameteri((int)3553, (int)10240, (int)9729);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
    }

    @Override
    public void cleanup() {
    }
}

