/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.instancing.lightshow.light_object;

import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.common.data.types.Color;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightMeshInstance {
    private final LightMesh mesh;
    private static final int colorChannelCount = 8;
    public Matrix4f transform;
    private final LightState[] colorChannels = new LightState[8];

    public LightMeshInstance(LightMesh mesh) {
        for (int i = 0; i < 8; ++i) {
            this.colorChannels[i] = new LightState(new Color(), 0.0f);
        }
        this.transform = new Matrix4f().identity();
        this.mesh = mesh;
    }

    public void setColor(int channel, LightState color) {
        if (channel < 0 || channel > 7) {
            throw new IllegalArgumentException("Channel must be between 0-7");
        }
        this.colorChannels[channel].set(color);
    }

    public LightState getLightState(int channel) {
        if (channel < 0 || channel > 7) {
            throw new IllegalArgumentException("Channel must be between 0-7");
        }
        return this.colorChannels[channel];
    }

    public void translate(Vector3f vec) {
        this.transform.translate((Vector3fc)vec);
    }

    public void rotate(Quaternionf quat) {
        this.transform.rotate((Quaternionfc)quat);
    }

    public void scale(Vector3f scale) {
        this.transform.scale((Vector3fc)scale);
    }

    public void scale(float x, float y, float z) {
        this.transform.scale(x, y, z);
    }

    public void setTransform(Matrix4f mat) {
        this.transform.set((Matrix4fc)mat);
    }

    public void draw() {
        this.mesh.draw(this.transform, this.colorChannels);
    }
}

