/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.lights;

import com.beatcraft.client.beatmap.BeatmapController;
import com.beatcraft.client.lightshow.lights.LightObject;
import com.beatcraft.client.lightshow.lights.LightState;
import com.beatcraft.client.logic.Hitbox;
import com.beatcraft.client.render.BeatcraftRenderer;
import com.beatcraft.client.render.RenderUtil;
import com.beatcraft.client.render.effect.Bloomfog;
import com.beatcraft.common.data.types.Color;
import com.beatcraft.common.memory.MemoryPool;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GlowingCuboid
extends LightObject {
    private Hitbox dimensions;
    private List<Vector3f[]> faces;
    private List<Vector3f[]> lines;

    public GlowingCuboid(BeatmapController map, Hitbox dimensions, Vector3f pos, Quaternionf rot) {
        super(map);
        this.position = pos;
        this.orientation = rot;
        this.setDimensions(dimensions);
        this.lightState = new LightState(new Color(0), 0.0f);
    }

    @Override
    public GlowingCuboid cloneOffset(Vector3f offset) {
        return new GlowingCuboid(this.mapController, new Hitbox(new Vector3f((Vector3fc)this.dimensions.min), new Vector3f((Vector3fc)this.dimensions.max)), this.position.add((Vector3fc)offset, new Vector3f()), new Quaternionf((Quaternionfc)this.orientation));
    }

    public void setDimensions(Hitbox dimensions) {
        this.dimensions = dimensions;
        this.faces = BeatcraftRenderer.getCubeFaces(dimensions.min, dimensions.max);
        this.lines = BeatcraftRenderer.getCubeEdges(dimensions.min, dimensions.max);
    }

    @Override
    public void render(class_4587 matrices, class_4184 camera, float alpha, Bloomfog bloomfog) {
        Vector3f pos = MemoryPool.newVector3f(this.position);
        Vector3f off = MemoryPool.newVector3f(this.offset);
        Quaternionf ori = MemoryPool.newQuaternionf(this.orientation);
        Quaternionf rot = MemoryPool.newQuaternionf(this.rotation);
        Quaternionf wrot = MemoryPool.newQuaternionf(this.worldRotation);
        Vector3f pos3 = MemoryPool.newVector3f(this.position);
        Vector3f off3 = MemoryPool.newVector3f(this.offset);
        Quaternionf ori3 = MemoryPool.newQuaternionf(this.orientation);
        Quaternionf rot3 = MemoryPool.newQuaternionf(this.rotation);
        Quaternionf wrot3 = MemoryPool.newQuaternionf(this.worldRotation);
        Vector3f pos4 = MemoryPool.newVector3f(this.position);
        Vector3f off4 = MemoryPool.newVector3f(this.offset);
        Quaternionf ori4 = MemoryPool.newQuaternionf(this.orientation);
        Quaternionf rot4 = MemoryPool.newQuaternionf(this.rotation);
        Quaternionf wrot4 = MemoryPool.newQuaternionf(this.worldRotation);
        LightState state = this.lightState.copy();
        state.clampAlpha();
        Matrix4f mat = matrices.method_23760().method_23761();
        if (bloomfog != null) {
            bloomfog.record((b, c, r, m) -> this._render(mat, (class_287)b, (Vector3f)c, 1, (Quaternionf)r, ori, rot, wrot, pos, off, state, (boolean)m));
            bloomfog.recordBloomCall((TriConsumer<class_287, Vector3f, Quaternionf>)((TriConsumer)(b, v, q) -> this._renderBloom(mat, (class_287)b, (Vector3f)v, (Quaternionf)q, ori3, rot3, wrot3, pos3, off3, state)));
        }
        this.mapController.recordLightRenderCall((BiConsumer<class_287, Vector3f>)((BiConsumer)(b, c) -> this._render(mat, (class_287)b, (Vector3f)c, 0, null, ori4, rot4, wrot4, pos4, off4, state, false)));
    }

    private void _renderBloom(Matrix4f transform, class_287 buffer, Vector3f cameraPos, Quaternionf cameraRotation, Quaternionf orientation, Quaternionf rotation, Quaternionf worldRotation, Vector3f position, Vector3f offset, LightState lightState) {
        int color = lightState.getBloomColor();
        if ((color >> 24 & 0xFF) <= 1) {
            return;
        }
        Matrix4f mat = this.createTransformMatrix(transform, false, orientation, rotation, this.transformState, position, worldRotation, offset, cameraPos);
        for (Vector3f[] face : this.faces) {
            Vector3f v0 = face[0].mulPosition((Matrix4fc)mat, new Vector3f());
            Vector3f v1 = face[1].mulPosition((Matrix4fc)mat, new Vector3f());
            Vector3f v2 = face[2].mulPosition((Matrix4fc)mat, new Vector3f());
            Vector3f v3 = face[3].mulPosition((Matrix4fc)mat, new Vector3f());
            v0.rotate((Quaternionfc)cameraRotation);
            v1.rotate((Quaternionfc)cameraRotation);
            v2.rotate((Quaternionfc)cameraRotation);
            v3.rotate((Quaternionfc)cameraRotation);
            buffer.method_60830(v0).method_39415(color);
            buffer.method_60830(v1).method_39415(color);
            buffer.method_60830(v2).method_39415(color);
            buffer.method_60830(v0).method_39415(color);
            buffer.method_60830(v2).method_39415(color);
            buffer.method_60830(v3).method_39415(color);
        }
    }

    private void _render(Matrix4f transform, class_287 buffer, Vector3f cameraPos, int isBloomfog, Quaternionf cameraRotation, Quaternionf orientation, Quaternionf rotation, Quaternionf worldRotation, Vector3f position, Vector3f offset, LightState lightState, boolean mirrorDraw) {
        int color;
        int n = color = isBloomfog > 0 ? lightState.getBloomColor() : lightState.getEffectiveColor();
        if ((color >> 24 & 0xFF) <= 1) {
            return;
        }
        Matrix4f mat = this.createTransformMatrix(transform, mirrorDraw, orientation, rotation, this.transformState, position, worldRotation, offset, cameraPos);
        if (isBloomfog == 1 && !mirrorDraw) {
            for (Vector3f[] line : this.lines) {
                Vector3f v0 = line[0].mulPosition((Matrix4fc)mat, new Vector3f());
                Vector3f v1 = line[1].mulPosition((Matrix4fc)mat, new Vector3f());
                v0.rotate((Quaternionfc)cameraRotation);
                v1.rotate((Quaternionfc)cameraRotation);
                Vector3f n2 = v1.sub((Vector3fc)v0, new Vector3f());
                List<Vector3f[]> segments = RenderUtil.chopEdge(v0, v1);
                for (Vector3f[] segment : segments) {
                    buffer.method_60830(segment[0]).method_39415(color).method_22914(n2.x, n2.y, n2.z);
                    buffer.method_60830(segment[1]).method_39415(color).method_22914(-n2.x, -n2.y, -n2.z);
                }
            }
        } else {
            for (Vector3f[] face : this.faces) {
                Vector3f v0 = face[0].mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).mulPosition((Matrix4fc)mat);
                Vector3f v1 = face[1].mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).mulPosition((Matrix4fc)mat);
                Vector3f v2 = face[2].mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).mulPosition((Matrix4fc)mat);
                Vector3f v3 = face[3].mul(1.0f, mirrorDraw ? -1.0f : 1.0f, 1.0f, new Vector3f()).mulPosition((Matrix4fc)mat);
                if (isBloomfog > 0) {
                    v0.rotate((Quaternionfc)cameraRotation);
                    v1.rotate((Quaternionfc)cameraRotation);
                    v2.rotate((Quaternionfc)cameraRotation);
                    v3.rotate((Quaternionfc)cameraRotation);
                }
                buffer.method_60830(v0).method_39415(color);
                buffer.method_60830(v1).method_39415(color);
                buffer.method_60830(v2).method_39415(color);
                buffer.method_60830(v3).method_39415(color);
            }
        }
    }

    @Override
    public void setBrightness(float value) {
        this.lightState.setBrightness(value);
    }

    @Override
    public void setColor(int color) {
        this.lightState.setColor(new Color(color));
    }
}

