/*
 * Decompiled with CFR 0.152.
 */
package com.beatcraft.client.render.mesh;

import com.beatcraft.Beatcraft;
import com.beatcraft.client.render.dynamic_loader.DynamicTexture;
import com.beatcraft.client.render.instancing.ArrowInstanceData;
import com.beatcraft.client.render.instancing.BombNoteInstanceData;
import com.beatcraft.client.render.instancing.ColorNoteInstanceData;
import com.beatcraft.client.render.instancing.HeadsetInstanceData;
import com.beatcraft.client.render.instancing.InstancedMesh;
import com.beatcraft.client.render.instancing.SmokeInstanceData;
import com.beatcraft.client.render.instancing.debug.TransformationWidgetInstanceData;
import com.beatcraft.client.render.instancing.lightshow.light_object.LightMesh;
import com.beatcraft.client.render.item.SaberItemRenderer;
import com.beatcraft.client.render.mesh.Quad;
import com.beatcraft.client.render.mesh.QuadMesh;
import com.beatcraft.client.render.mesh.Triangle;
import com.beatcraft.client.render.mesh.TriangleMesh;
import com.beatcraft.common.utils.JsonUtil;
import com.beatcraft.mixin_utils.ModelLoaderAccessor;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_783;
import net.minecraft.class_793;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import oshi.util.tuples.Triplet;

public class MeshLoader {
    public static InstancedMesh<ColorNoteInstanceData> COLOR_NOTE_INSTANCED_MESH;
    public static InstancedMesh<BombNoteInstanceData> BOMB_NOTE_INSTANCED_MESH;
    public static InstancedMesh<ColorNoteInstanceData> CHAIN_HEAD_NOTE_INSTANCED_MESH;
    public static InstancedMesh<ColorNoteInstanceData> CHAIN_LINK_NOTE_INSTANCED_MESH;
    public static InstancedMesh<ArrowInstanceData> NOTE_ARROW_INSTANCED_MESH;
    public static InstancedMesh<ArrowInstanceData> NOTE_DOT_INSTANCED_MESH;
    public static InstancedMesh<ArrowInstanceData> CHAIN_DOT_INSTANCED_MESH;
    public static InstancedMesh<ColorNoteInstanceData> MIRROR_COLOR_NOTE_INSTANCED_MESH;
    public static InstancedMesh<BombNoteInstanceData> MIRROR_BOMB_NOTE_INSTANCED_MESH;
    public static InstancedMesh<ColorNoteInstanceData> MIRROR_CHAIN_HEAD_NOTE_INSTANCED_MESH;
    public static InstancedMesh<ColorNoteInstanceData> MIRROR_CHAIN_LINK_NOTE_INSTANCED_MESH;
    public static InstancedMesh<ArrowInstanceData> MIRROR_NOTE_ARROW_INSTANCED_MESH;
    public static InstancedMesh<ArrowInstanceData> MIRROR_NOTE_DOT_INSTANCED_MESH;
    public static InstancedMesh<ArrowInstanceData> MIRROR_CHAIN_DOT_INSTANCED_MESH;
    public static InstancedMesh<HeadsetInstanceData> HEADSET_INSTANCED_MESH;
    public static final class_2960 NOTE_TEXTURE;
    public static final class_2960 ARROW_TEXTURE;
    public static final class_2960 SMOKE_TEXTURE;
    public static final class_2960 MATRIX_LOCATOR_TEXTURE;
    public static final class_2960 HEADSET_TEXTURE;
    public static InstancedMesh<SmokeInstanceData> SMOKE_INSTANCED_MESH;
    public static InstancedMesh<TransformationWidgetInstanceData> MATRIX_LOCATOR_MESH;
    private static ModelLoaderAccessor modelLoader;
    public static LightMesh KALEIDOSCOPE_SPIKE;

    public static void loadMeshes() {
        COLOR_NOTE_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/item/color_note.json"), NOTE_TEXTURE, "instanced/color_note", 1.0f);
        CHAIN_HEAD_NOTE_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/item/color_note_chain_head.json"), NOTE_TEXTURE, "instanced/color_note", 1.0f);
        CHAIN_LINK_NOTE_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/item/color_note_chain_link.json"), NOTE_TEXTURE, "instanced/color_note", 1.0f);
        BOMB_NOTE_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/item/bomb_note.json"), NOTE_TEXTURE, "instanced/bomb_note", 1.0f);
        NOTE_ARROW_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/item/note_arrow.json"), ARROW_TEXTURE, "instanced/arrow", 1.0f);
        NOTE_DOT_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/item/note_dot.json"), ARROW_TEXTURE, "instanced/arrow", 1.0f);
        CHAIN_DOT_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/item/chain_note_dot.json"), ARROW_TEXTURE, "instanced/arrow", 1.0f);
        HEADSET_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/item/headset.json"), HEADSET_TEXTURE, "instanced/headset", 1.0f);
        MIRROR_COLOR_NOTE_INSTANCED_MESH = COLOR_NOTE_INSTANCED_MESH.copy();
        MIRROR_BOMB_NOTE_INSTANCED_MESH = BOMB_NOTE_INSTANCED_MESH.copy();
        MIRROR_CHAIN_HEAD_NOTE_INSTANCED_MESH = CHAIN_HEAD_NOTE_INSTANCED_MESH.copy();
        MIRROR_CHAIN_LINK_NOTE_INSTANCED_MESH = CHAIN_LINK_NOTE_INSTANCED_MESH.copy();
        MIRROR_NOTE_ARROW_INSTANCED_MESH = NOTE_ARROW_INSTANCED_MESH.copy();
        MIRROR_NOTE_DOT_INSTANCED_MESH = NOTE_DOT_INSTANCED_MESH.copy();
        MIRROR_CHAIN_DOT_INSTANCED_MESH = CHAIN_DOT_INSTANCED_MESH.copy();
        SMOKE_INSTANCED_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/gameplay/smoke.json"), SMOKE_TEXTURE, "instanced/smoke", 6.0f);
        MATRIX_LOCATOR_MESH = MeshLoader.loadInstancedMesh(Beatcraft.id("models/debug/matrix_visualizer.json"), MATRIX_LOCATOR_TEXTURE, "debug/matrix_visualizer", 1.0f);
        try {
            KALEIDOSCOPE_SPIKE = LightMesh.load("kaleidoscope_spike", Beatcraft.id("meshes/environment/kaleidoscope/spikes.json"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void init(ModelLoaderAccessor modelLoader) {
        MeshLoader.modelLoader = modelLoader;
    }

    public static <T extends InstancedMesh.InstanceData> InstancedMesh<T> loadInstancedMesh(class_2960 identifier, class_2960 texture, String shaderSet, float sizeMultiplier) {
        try {
            UnboundJsonModel model = new UnboundJsonModel(identifier);
            ArrayList vertices = new ArrayList();
            model.getElements().forEach(element -> {
                Vector3f origin;
                int axis;
                float angleDegrees;
                Vector3f min = element.from.mul(sizeMultiplier / 16.0f, new Vector3f());
                Vector3f max = element.to.mul(sizeMultiplier / 16.0f, new Vector3f());
                if (element.rotation != null) {
                    angleDegrees = element.rotation.angle();
                    axis = element.rotation.axis();
                    origin = element.rotation.origin().mul(sizeMultiplier);
                } else {
                    axis = 0;
                    angleDegrees = 0.0f;
                    origin = new Vector3f(0.0f, 0.0f, 0.0f);
                }
                element.faces.forEach((dir, face) -> {
                    Vector2f[] uvs = MeshLoader.getUvs(face);
                    uvs = new Vector2f[]{uvs[2], uvs[0], uvs[1], uvs[3]};
                    ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
                    Vector3f normal = new Vector3f();
                    switch (dir) {
                        case field_11033: {
                            normal = new Vector3f(0.0f, -1.0f, 0.0f);
                            verts.addAll(List.of(new Vector3f((Vector3fc)min), new Vector3f(min.x, min.y, max.z), new Vector3f(max.x, min.y, max.z), new Vector3f(max.x, min.y, min.z)));
                            break;
                        }
                        case field_11036: {
                            normal = new Vector3f(0.0f, 1.0f, 0.0f);
                            verts.addAll(List.of(new Vector3f(min.x, max.y, max.z), new Vector3f(min.x, max.y, min.z), new Vector3f(max.x, max.y, min.z), new Vector3f((Vector3fc)max)));
                            break;
                        }
                        case field_11043: {
                            normal = new Vector3f(0.0f, 0.0f, -1.0f);
                            verts.addAll(List.of(new Vector3f(max.x, min.y, min.z), new Vector3f(max.x, max.y, min.z), new Vector3f(min.x, max.y, min.z), new Vector3f((Vector3fc)min)));
                            break;
                        }
                        case field_11035: {
                            normal = new Vector3f(0.0f, 0.0f, 1.0f);
                            verts.addAll(List.of(new Vector3f(min.x, min.y, max.z), new Vector3f(min.x, max.y, max.z), new Vector3f((Vector3fc)max), new Vector3f(max.x, min.y, max.z)));
                            break;
                        }
                        case field_11039: {
                            normal = new Vector3f(-1.0f, 0.0f, 0.0f);
                            verts.addAll(List.of(new Vector3f((Vector3fc)min), new Vector3f(min.x, max.y, min.z), new Vector3f(min.x, max.y, max.z), new Vector3f(min.x, min.y, max.z)));
                            break;
                        }
                        case field_11034: {
                            normal = new Vector3f(1.0f, 0.0f, 0.0f);
                            verts.addAll(List.of(new Vector3f(max.x, min.y, max.z), new Vector3f((Vector3fc)max), new Vector3f(max.x, max.y, min.z), new Vector3f(max.x, min.y, min.z)));
                        }
                    }
                    if (angleDegrees != 0.0f) {
                        Vector3f rotationAxis = axis == 0 ? new Vector3f(1.0f, 0.0f, 0.0f) : (axis == 1 ? new Vector3f(0.0f, 1.0f, 0.0f) : new Vector3f(0.0f, 0.0f, 1.0f));
                        Quaternionf rotation = new Quaternionf().rotationAxis(angleDegrees * ((float)Math.PI / 180), (Vector3fc)rotationAxis);
                        verts.forEach(vert -> vert.sub((Vector3fc)origin).rotate((Quaternionfc)rotation).add((Vector3fc)origin));
                        normal.rotate((Quaternionfc)rotation);
                    }
                    vertices.addAll(List.of(new Triplet((Object)((Vector3f)verts.get(3)), (Object)uvs[3], (Object)new Vector3f((Vector3fc)normal)), new Triplet((Object)((Vector3f)verts.get(2)), (Object)uvs[2], (Object)new Vector3f((Vector3fc)normal)), new Triplet((Object)((Vector3f)verts.get(0)), (Object)uvs[0], (Object)new Vector3f((Vector3fc)normal)), new Triplet((Object)((Vector3f)verts.get(2)), (Object)uvs[2], (Object)new Vector3f((Vector3fc)normal)), new Triplet((Object)((Vector3f)verts.get(1)), (Object)uvs[1], (Object)new Vector3f((Vector3fc)normal)), new Triplet((Object)((Vector3f)verts.get(0)), (Object)uvs[0], (Object)normal)));
                });
            });
            Triplet[] arr = new Triplet[vertices.size()];
            for (int i = 0; i < vertices.size(); ++i) {
                arr[i] = (Triplet)vertices.get(i);
            }
            return new InstancedMesh(Beatcraft.id(shaderSet), texture, arr);
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to load model json!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static QuadMesh loadMesh(class_2960 identifier) {
        try {
            class_793 model = modelLoader.beatCraft$loadJsonModel(identifier);
            QuadMesh mesh = new QuadMesh();
            model.method_3433().forEach(element -> {
                Vector3f min = element.field_4228.mul(0.03125f, new Vector3f());
                Vector3f max = element.field_4231.mul(0.03125f, new Vector3f());
                float angleDegrees = element.field_4232.comp_1120();
                class_2350.class_2351 axis = element.field_4232.comp_1119();
                Vector3f origin = element.field_4232.comp_1118().mul(0.5f);
                int start = mesh.vertices.size();
                if (angleDegrees != 0.0f) {
                    mesh.addUniquePermutedVertices(min, max);
                } else {
                    mesh.addPermutedVertices(min, max);
                }
                int end = mesh.vertices.size();
                element.field_4230.forEach((dir, face) -> {
                    Vector2f[] uvs = MeshLoader.getUvs(face);
                    switch (dir) {
                        case field_11033: {
                            mesh.quads.add(new Quad(mesh.vertIdx(min), mesh.vertIdx(new Vector3f(min.x, min.y, max.z)), mesh.vertIdx(new Vector3f(max.x, min.y, max.z)), mesh.vertIdx(new Vector3f(max.x, min.y, min.z)), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11036: {
                            mesh.quads.add(new Quad(mesh.vertIdx(new Vector3f(min.x, max.y, max.z)), mesh.vertIdx(new Vector3f(min.x, max.y, min.z)), mesh.vertIdx(new Vector3f(max.x, max.y, min.z)), mesh.vertIdx(max), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11043: {
                            mesh.quads.add(new Quad(mesh.vertIdx(new Vector3f(max.x, min.y, min.z)), mesh.vertIdx(new Vector3f(max.x, max.y, min.z)), mesh.vertIdx(new Vector3f(min.x, max.y, min.z)), mesh.vertIdx(min), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11035: {
                            mesh.quads.add(new Quad(mesh.vertIdx(new Vector3f(min.x, min.y, max.z)), mesh.vertIdx(new Vector3f(min.x, max.y, max.z)), mesh.vertIdx(max), mesh.vertIdx(new Vector3f(max.x, min.y, max.z)), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11039: {
                            mesh.quads.add(new Quad(mesh.vertIdx(min), mesh.vertIdx(new Vector3f(min.x, max.y, min.z)), mesh.vertIdx(new Vector3f(min.x, max.y, max.z)), mesh.vertIdx(new Vector3f(min.x, min.y, max.z)), uvs[2], uvs[0], uvs[1], uvs[3]));
                            break;
                        }
                        case field_11034: {
                            mesh.quads.add(new Quad(mesh.vertIdx(new Vector3f(max.x, min.y, max.z)), mesh.vertIdx(max), mesh.vertIdx(new Vector3f(max.x, max.y, min.z)), mesh.vertIdx(new Vector3f(max.x, min.y, min.z)), uvs[2], uvs[0], uvs[1], uvs[3]));
                        }
                    }
                });
                if (angleDegrees != 0.0f) {
                    Vector3f rotationAxis = axis == class_2350.class_2351.field_11048 ? new Vector3f(1.0f, 0.0f, 0.0f) : (axis == class_2350.class_2351.field_11052 ? new Vector3f(0.0f, 1.0f, 0.0f) : new Vector3f(0.0f, 0.0f, 1.0f));
                    Quaternionf rotation = new Quaternionf().rotationAxis(angleDegrees * ((float)Math.PI / 180), (Vector3fc)rotationAxis);
                    mesh.transformVertices(start, end, vert -> {
                        vert.sub((Vector3fc)origin);
                        vert.rotate((Quaternionfc)rotation);
                        vert.add((Vector3fc)origin);
                    });
                }
            });
            return mesh;
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to load model json!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static SaberItemRenderer.SaberModel loadSaberMesh(class_2960 identifier, class_2960 texture) {
        try {
            BufferedReader reader = ((class_3298)class_310.method_1551().method_1478().method_14486(identifier).orElseThrow()).method_43039();
            String rawJson = String.join((CharSequence)"\n", reader.lines().toList());
            JsonObject json = JsonParser.parseString((String)rawJson).getAsJsonObject();
            String[] split = identifier.method_12832().split("/");
            return MeshLoader.loadSectionedMesh(json, split[split.length - 1], texture);
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to load model json!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static SaberItemRenderer.SaberModel loadSaberMesh(String filePath, HashMap<String, File> textureLookup) {
        try {
            Path p = Path.of(filePath, new String[0]);
            String rawJson = Files.readString(p);
            JsonObject json = JsonParser.parseString((String)rawJson).getAsJsonObject();
            JsonObject textures = json.getAsJsonObject("textures");
            String[] parts = null;
            for (int i = 0; i < 5; ++i) {
                if (!textures.has(String.valueOf(i))) continue;
                parts = textures.get(String.valueOf(i)).getAsString().split("[/:]");
            }
            if (parts == null) {
                Beatcraft.LOGGER.error("Failed to load model json! (texture must be named '0' - '4')");
                return null;
            }
            void name = parts[parts.length - 1];
            File f = textureLookup.get(name);
            if (f == null) {
                Beatcraft.LOGGER.error("Undefined texture: '{}'", (Object)name);
                return null;
            }
            DynamicTexture tex = new DynamicTexture(f.getAbsolutePath());
            return MeshLoader.loadSectionedMesh(json, p.getFileName().toString(), tex.id());
        }
        catch (IOException e) {
            Beatcraft.LOGGER.error("Failed to load model json!", (Throwable)e);
            return null;
        }
    }

    private static SaberItemRenderer.SaberModel loadSectionedMesh(JsonObject json, String fileName, class_2960 texture) {
        String displayName = JsonUtil.getOrDefault(json, "display_name", JsonElement::getAsString, fileName);
        List<String> authors = JsonUtil.getOrDefault(json, "authors", JsonElement::getAsJsonArray, new JsonArray()).asList().stream().map(JsonElement::getAsString).toList();
        AtomicInteger complexityScore = new AtomicInteger();
        List<Integer> textureSize = json.getAsJsonArray("texture_size").asList().stream().map(JsonElement::getAsInt).toList();
        HashMap groupAttrs = new HashMap();
        HashMap origins = new HashMap();
        JsonArray groups = json.getAsJsonArray("groups");
        groups.forEach(o -> {
            JsonObject obj = o.getAsJsonObject();
            List<Integer> indices = obj.getAsJsonArray("children").asList().stream().map(JsonElement::getAsInt).toList();
            String groupAttr = obj.get("name").getAsString();
            Vector3f origin = JsonUtil.getVector3(obj.getAsJsonArray("origin")).div(16.0f);
            for (Integer idx : indices) {
                groupAttrs.put(idx, groupAttr + ";");
                origins.put(idx, origin);
            }
        });
        JsonArray elements = json.getAsJsonArray("elements");
        ArrayList<SaberItemRenderer.AttributedMesh> meshes = new ArrayList<SaberItemRenderer.AttributedMesh>();
        BiFunction<Vector3f, String, SaberItemRenderer.AttributedMesh> getMesh = (v, s) -> {
            for (SaberItemRenderer.AttributedMesh m : meshes) {
                if (!m.matchesAttributes(new SaberItemRenderer.AttributedMesh(null, (Vector3f)v, (String)s))) continue;
                return m;
            }
            SaberItemRenderer.AttributedMesh m = new SaberItemRenderer.AttributedMesh(new TriangleMesh(List.of(), List.of()), (Vector3f)v, (String)s);
            meshes.add(m);
            complexityScore.getAndIncrement();
            return m;
        };
        AtomicInteger i = new AtomicInteger(0);
        elements.forEach(e -> {
            JsonObject obj = e.getAsJsonObject();
            int idx = i.getAndIncrement();
            String attrs = groupAttrs.getOrDefault(idx, "") + JsonUtil.getOrDefault(obj, "name", JsonElement::getAsString, "");
            JsonObject rawRotation = obj.getAsJsonObject("rotation");
            Vector3f rotationOrigin = JsonUtil.getVector3(rawRotation.getAsJsonArray("origin")).div(16.0f);
            Vector3f swivel = new Vector3f((Vector3fc)origins.computeIfAbsent(idx, x -> new Vector3f()));
            swivel = new Vector3f((Vector3fc)rotationOrigin).add(0.0f, 0.5f, 0.0f);
            Vector3f min = JsonUtil.getVector3(obj.getAsJsonArray("from")).div(16.0f).add(0.0f, 0.5f, 0.0f);
            Vector3f max = JsonUtil.getVector3(obj.getAsJsonArray("to")).div(16.0f).add(0.0f, 0.5f, 0.0f);
            ArrayList<String> include = new ArrayList<String>(List.of("north", "east", "south", "west", "up", "down"));
            if (min.x == max.x) {
                include.removeAll(List.of("north", "south", "up", "down"));
            }
            if (min.y == max.y) {
                include.removeAll(List.of("north", "east", "south", "west"));
            }
            if (min.z == max.z) {
                include.removeAll(List.of("east", "west", "up", "down"));
            }
            if (include.isEmpty()) {
                return;
            }
            float angleDegrees = rawRotation.get("angle").getAsFloat();
            String rotationAxis = rawRotation.get("axis").getAsString();
            Quaternionf rotQt = new Quaternionf().rotationAxis(angleDegrees * ((float)Math.PI / 180), (Vector3fc)new Vector3f(rotationAxis.equals("x") ? 1.0f : 0.0f, rotationAxis.equals("y") ? 1.0f : 0.0f, rotationAxis.equals("z") ? 1.0f : 0.0f));
            SaberItemRenderer.AttributedMesh mesh = (SaberItemRenderer.AttributedMesh)getMesh.apply(swivel, attrs);
            ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
            ArrayList<Triangle> tris = new ArrayList<Triangle>();
            JsonObject rawFaces = obj.getAsJsonObject("faces");
            int n = 0;
            for (String faceId : include) {
                JsonObject rawFace = rawFaces.getAsJsonObject(faceId);
                Vector4f uv = JsonUtil.getVector4(rawFace.getAsJsonArray("uv"));
                uv.div(16.0f);
                switch (faceId) {
                    case "north": {
                        verts.addAll(List.of(min, new Vector3f(min.x, max.y, min.z), new Vector3f(max.x, max.y, min.z), new Vector3f(max.x, min.y, min.z)));
                        break;
                    }
                    case "east": {
                        verts.addAll(List.of(new Vector3f(max.x, min.y, min.z), new Vector3f(max.x, max.y, min.z), max, new Vector3f(max.x, min.y, max.z)));
                        break;
                    }
                    case "south": {
                        verts.addAll(List.of(new Vector3f(max.x, min.y, max.z), max, new Vector3f(min.x, max.y, max.z), new Vector3f(min.x, min.y, max.z)));
                        break;
                    }
                    case "west": {
                        verts.addAll(List.of(new Vector3f(min.x, min.y, max.z), new Vector3f(min.x, max.y, max.z), new Vector3f(min.x, max.y, min.z), min));
                        break;
                    }
                    case "up": {
                        verts.addAll(List.of(max, new Vector3f(max.x, max.y, min.z), new Vector3f(min.x, max.y, min.z), new Vector3f(min.x, max.y, max.z)));
                        break;
                    }
                    case "down": {
                        verts.addAll(List.of(new Vector3f(max.x, min.y, min.z), new Vector3f(max.x, min.y, max.z), new Vector3f(min.x, min.y, max.z), min));
                    }
                }
                int x2 = n * 4;
                tris.addAll(List.of(new Triangle(x2, x2 + 1, x2 + 2, new Vector2f(uv.x, uv.w), new Vector2f(uv.x, uv.y), new Vector2f(uv.z, uv.y)), new Triangle(x2, x2 + 2, x2 + 3, new Vector2f(uv.x, uv.w), new Vector2f(uv.z, uv.y), new Vector2f(uv.z, uv.w))));
                ++n;
            }
            for (Vector3f vert : verts) {
                vert.sub((Vector3fc)rotationOrigin).rotate((Quaternionfc)rotQt).add((Vector3fc)rotationOrigin);
            }
            mesh.mesh.addGeometry(verts, tris);
        });
        return new SaberItemRenderer.SaberModel(fileName, displayName, authors, meshes, complexityScore.get(), texture);
    }

    private static Vector2f @NotNull [] getUvs(UnboundJsonModel.UnboundJsonFace face) {
        float[] rawUvs = face.textureData().uvs;
        Vector2f[] uvs = new Vector2f[]{new Vector2f(rawUvs[0] / 16.0f, rawUvs[1] / 16.0f), new Vector2f(rawUvs[2] / 16.0f, rawUvs[1] / 16.0f), new Vector2f(rawUvs[0] / 16.0f, rawUvs[3] / 16.0f), new Vector2f(rawUvs[2] / 16.0f, rawUvs[3] / 16.0f)};
        for (int rotation = (int)face.textureData().rotation; rotation > 0; rotation -= 90) {
            uvs = new Vector2f[]{uvs[2], uvs[0], uvs[3], uvs[1]};
        }
        return uvs;
    }

    private static Vector2f @NotNull [] getUvs(class_783 face) {
        float[] rawUvs = face.comp_2870().field_4235;
        Vector2f[] uvs = new Vector2f[]{new Vector2f(rawUvs[0] / 16.0f, rawUvs[1] / 16.0f), new Vector2f(rawUvs[2] / 16.0f, rawUvs[1] / 16.0f), new Vector2f(rawUvs[0] / 16.0f, rawUvs[3] / 16.0f), new Vector2f(rawUvs[2] / 16.0f, rawUvs[3] / 16.0f)};
        for (int rotation = face.comp_2870().field_4234; rotation > 0; rotation -= 90) {
            uvs = new Vector2f[]{uvs[2], uvs[0], uvs[3], uvs[1]};
        }
        return uvs;
    }

    static {
        NOTE_TEXTURE = Beatcraft.id("textures/gameplay_objects/color_note.png");
        ARROW_TEXTURE = Beatcraft.id("textures/gameplay_objects/arrow.png");
        SMOKE_TEXTURE = Beatcraft.id("textures/noise/smoke.png");
        MATRIX_LOCATOR_TEXTURE = Beatcraft.id("textures/debug/matrix_visualizer.png");
        HEADSET_TEXTURE = Beatcraft.id("textures/item/headset.png");
    }

    protected static class UnboundJsonModel {
        private final List<UnboundJsonElement> elements;

        protected List<UnboundJsonElement> getElements() {
            return this.elements;
        }

        protected UnboundJsonModel(class_2960 identifier) throws IOException {
            BufferedReader reader = ((class_3298)class_310.method_1551().method_1478().method_14486(identifier).orElseThrow()).method_43039();
            String rawJson = String.join((CharSequence)"\n", reader.lines().toList());
            JsonObject json = JsonParser.parseString((String)rawJson).getAsJsonObject();
            ArrayList<UnboundJsonElement> arr = new ArrayList<UnboundJsonElement>();
            JsonArray rawElements = json.getAsJsonArray("elements");
            rawElements.forEach(re -> {
                JsonObject elementData = re.getAsJsonObject();
                UnboundJsonElement element = new UnboundJsonElement();
                element.to = JsonUtil.getVector3(elementData.getAsJsonArray("to"));
                element.from = JsonUtil.getVector3(elementData.getAsJsonArray("from"));
                element.rotation = UnboundJsonRotation.parse(elementData.getAsJsonObject("rotation"));
                element.faces = UnboundJsonFace.parseFaces(elementData.getAsJsonObject("faces"));
                arr.add(element);
            });
            this.elements = arr;
        }

        protected static class UnboundJsonElement {
            protected Vector3f from;
            protected Vector3f to;
            protected UnboundJsonRotation rotation;
            protected Map<class_2350, UnboundJsonFace> faces;

            protected UnboundJsonElement() {
            }
        }

        protected record UnboundJsonRotation(int axis, float angle, Vector3f origin) {
            protected static UnboundJsonRotation parse(JsonObject json) {
                if (json == null) {
                    return new UnboundJsonRotation(0, 0.0f, new Vector3f());
                }
                String ax = json.get("axis").getAsString();
                return new UnboundJsonRotation(ax.equals("x") ? 0 : (ax.equals("y") ? 1 : 2), json.get("angle").getAsFloat(), JsonUtil.getVector3(json.getAsJsonArray("origin")).mul(0.0625f));
            }
        }

        protected static class UnboundJsonFace {
            protected UnboundTextureData texData;
            private static final String[] directions = new String[]{"north", "east", "south", "west", "up", "down"};

            protected UnboundJsonFace() {
            }

            protected UnboundTextureData textureData() {
                return this.texData;
            }

            protected static Map<class_2350, UnboundJsonFace> parseFaces(JsonObject json) {
                HashMap<class_2350, UnboundJsonFace> map = new HashMap<class_2350, UnboundJsonFace>();
                for (String face : directions) {
                    if (!json.has(face)) continue;
                    map.put(class_2350.method_10168((String)face), UnboundJsonFace.parseFace(json.getAsJsonObject(face)));
                }
                return map;
            }

            protected static UnboundJsonFace parseFace(JsonObject json) {
                UnboundJsonFace f = new UnboundJsonFace();
                f.texData = new UnboundTextureData();
                JsonArray rawUvs = json.getAsJsonArray("uv");
                f.texData.uvs = new float[]{rawUvs.get(0).getAsFloat(), rawUvs.get(1).getAsFloat(), rawUvs.get(2).getAsFloat(), rawUvs.get(3).getAsFloat()};
                f.texData.rotation = JsonUtil.getOrDefault(json, "rotation", JsonElement::getAsFloat, Float.valueOf(0.0f)).floatValue();
                return f;
            }
        }

        protected static class UnboundTextureData {
            float rotation;
            float[] uvs;

            protected UnboundTextureData() {
            }
        }
    }
}

